# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Server(pulumi.CustomResource):
    audiences: pulumi.Output[list]
    """
    The recipients that the tokens are intended for. This becomes the `aud` claim in an access token.
    """
    credentials_last_rotated: pulumi.Output[str]
    """
    The timestamp when the authorization server started to use the `kid` for signing tokens.
    """
    credentials_next_rotation: pulumi.Output[str]
    """
    The timestamp when the authorization server changes the key for signing tokens. Only returned when `credentials_rotation_mode` is `"AUTO"`.
    """
    credentials_rotation_mode: pulumi.Output[str]
    """
    The key rotation mode for the authorization server. Can be `"AUTO"` or `"MANUAL"`.
    """
    description: pulumi.Output[str]
    """
    The description of the authorization server.
    """
    issuer: pulumi.Output[str]
    """
    The complete URL for a Custom Authorization Server. This becomes the `iss` claim in an access token.
    """
    issuer_mode: pulumi.Output[str]
    """
    Allows you to use a custom issuer URL. It can be set to `"CUSTOM_URL"` or `"ORG_URL"`
    """
    kid: pulumi.Output[str]
    """
    The ID of the JSON Web Key used for signing tokens issued by the authorization server.
    """
    name: pulumi.Output[str]
    """
    The name of the authorization server.
    """
    status: pulumi.Output[str]
    """
    The status of the auth server. It defaults to `"ACTIVE"`
    """
    def __init__(__self__, resource_name, opts=None, audiences=None, credentials_rotation_mode=None, description=None, issuer_mode=None, name=None, status=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates an Authorization Server.

        This resource allows you to create and configure an Authorization Server.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.Server("example",
            audiences=["api://example"],
            description="My Example Auth Server",
            issuer_mode="CUSTOM_URL",
            status="ACTIVE")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] audiences: The recipients that the tokens are intended for. This becomes the `aud` claim in an access token.
        :param pulumi.Input[str] credentials_rotation_mode: The key rotation mode for the authorization server. Can be `"AUTO"` or `"MANUAL"`.
        :param pulumi.Input[str] description: The description of the authorization server.
        :param pulumi.Input[str] issuer_mode: Allows you to use a custom issuer URL. It can be set to `"CUSTOM_URL"` or `"ORG_URL"`
        :param pulumi.Input[str] name: The name of the authorization server.
        :param pulumi.Input[str] status: The status of the auth server. It defaults to `"ACTIVE"`
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if audiences is None:
                raise TypeError("Missing required property 'audiences'")
            __props__['audiences'] = audiences
            __props__['credentials_rotation_mode'] = credentials_rotation_mode
            __props__['description'] = description
            __props__['issuer_mode'] = issuer_mode
            __props__['name'] = name
            __props__['status'] = status
            __props__['credentials_last_rotated'] = None
            __props__['credentials_next_rotation'] = None
            __props__['issuer'] = None
            __props__['kid'] = None
        super(Server, __self__).__init__(
            'okta:auth/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, audiences=None, credentials_last_rotated=None, credentials_next_rotation=None, credentials_rotation_mode=None, description=None, issuer=None, issuer_mode=None, kid=None, name=None, status=None):
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] audiences: The recipients that the tokens are intended for. This becomes the `aud` claim in an access token.
        :param pulumi.Input[str] credentials_last_rotated: The timestamp when the authorization server started to use the `kid` for signing tokens.
        :param pulumi.Input[str] credentials_next_rotation: The timestamp when the authorization server changes the key for signing tokens. Only returned when `credentials_rotation_mode` is `"AUTO"`.
        :param pulumi.Input[str] credentials_rotation_mode: The key rotation mode for the authorization server. Can be `"AUTO"` or `"MANUAL"`.
        :param pulumi.Input[str] description: The description of the authorization server.
        :param pulumi.Input[str] issuer: The complete URL for a Custom Authorization Server. This becomes the `iss` claim in an access token.
        :param pulumi.Input[str] issuer_mode: Allows you to use a custom issuer URL. It can be set to `"CUSTOM_URL"` or `"ORG_URL"`
        :param pulumi.Input[str] kid: The ID of the JSON Web Key used for signing tokens issued by the authorization server.
        :param pulumi.Input[str] name: The name of the authorization server.
        :param pulumi.Input[str] status: The status of the auth server. It defaults to `"ACTIVE"`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["audiences"] = audiences
        __props__["credentials_last_rotated"] = credentials_last_rotated
        __props__["credentials_next_rotation"] = credentials_next_rotation
        __props__["credentials_rotation_mode"] = credentials_rotation_mode
        __props__["description"] = description
        __props__["issuer"] = issuer
        __props__["issuer_mode"] = issuer_mode
        __props__["kid"] = kid
        __props__["name"] = name
        __props__["status"] = status
        return Server(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

