# Copyright Contributors to the Amundsen project.
# SPDX-License-Identifier: Apache-2.0

"""initial commit

Revision ID: c194a2dc1240
Revises:
Create Date: 2021-05-26 16:43:02.410601

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'c194a2dc1240'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'application',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('application_url', sa.String(length=2048), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('id', sa.String(length=128), nullable=False),
        sa.Column('description', sa.Text(), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'badge',
        sa.Column('rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('category', sa.String(length=32), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_cluster',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'database_metadata',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'tag',
        sa.Column('rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('tag_type', sa.String(length=32), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'updated_timestamp',
        sa.Column('rk', sa.String(length=64), nullable=False),
        sa.Column('latest_timestamp', sa.Integer(), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'users',
        sa.Column('rk', sa.String(length=320, collation='latin1_general_cs'), nullable=False),
        sa.Column('email', sa.String(length=320), nullable=False),
        sa.Column('is_active', sa.Boolean(), nullable=True),
        sa.Column('first_name', sa.String(length=64), nullable=True),
        sa.Column('last_name', sa.String(length=64), nullable=True),
        sa.Column('full_name', sa.String(length=256), nullable=True),
        sa.Column('github_username', sa.String(length=128), nullable=True),
        sa.Column('team_name', sa.String(length=128), nullable=True),
        sa.Column('employee_type', sa.String(length=32), nullable=True),
        sa.Column('slack_id', sa.String(length=32), nullable=True),
        sa.Column('role_name', sa.String(length=32), nullable=True),
        sa.Column('updated_at', sa.Integer(), nullable=True),
        sa.Column('manager_rk', sa.String(length=320, collation='latin1_general_cs'), nullable=True),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'cluster_metadata',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('database_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['database_rk'], ['database_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_group',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('dashboard_group_url', sa.String(length=2048), nullable=True),
        sa.Column('cluster_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['cluster_rk'], ['dashboard_cluster.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('created_timestamp', sa.Integer(), nullable=True),
        sa.Column('dashboard_url', sa.String(length=2048), nullable=True),
        sa.Column('dashboard_group_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_group_rk'], ['dashboard_group.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_group_description',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('dashboard_group_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_group_rk'], ['dashboard_group.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'schema_metadata',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('cluster_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['cluster_rk'], ['cluster_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_badge',
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('badge_rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['badge_rk'], ['badge.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('dashboard_rk', 'badge_rk')
    )
    op.create_table(
        'dashboard_description',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_execution',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('timestamp', sa.Integer(), nullable=False),
        sa.Column('state', sa.String(length=16), nullable=False),
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_follower',
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('user_rk', sa.String(length=320, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['user_rk'], ['users.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('dashboard_rk', 'user_rk')
    )
    op.create_table(
        'dashboard_owner',
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('user_rk', sa.String(length=320, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['user_rk'], ['users.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('dashboard_rk', 'user_rk')
    )
    op.create_table(
        'dashboard_query',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('id', sa.String(length=32), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('url', sa.String(length=2048), nullable=True),
        sa.Column('query_text', sa.Text(), nullable=True),
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_tag',
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('tag_rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['tag_rk'], ['tag.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('dashboard_rk', 'tag_rk')
    )
    op.create_table(
        'dashboard_timestamp',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('timestamp', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_usage',
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('user_rk', sa.String(length=320, collation='latin1_general_cs'), nullable=False),
        sa.Column('read_count', sa.Integer(), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['user_rk'], ['users.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('dashboard_rk', 'user_rk')
    )
    op.create_table(
        'schema_description',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('description_source', sa.String(length=32), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('schema_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['schema_rk'], ['schema_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'schema_programmatic_description',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('description_source', sa.String(length=32), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('schema_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['schema_rk'], ['schema_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'table_metadata',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('is_view', sa.Boolean(), nullable=False),
        sa.Column('schema_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['schema_rk'], ['schema_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'application_table',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('application_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['application_rk'], ['application.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'column_metadata',
        sa.Column('rk', sa.String(length=1536, collation='latin1_general_cs'), nullable=False),
        sa.Column('name', sa.String(length=768), nullable=False),
        sa.Column('type', sa.String(length=32), nullable=False),
        sa.Column('sort_order', sa.Integer(), nullable=False),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_chart',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('id', sa.String(length=32), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=True),
        sa.Column('type', sa.String(length=32), nullable=True),
        sa.Column('url', sa.String(length=2048), nullable=True),
        sa.Column('query_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['query_rk'], ['dashboard_query.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'dashboard_table',
        sa.Column('dashboard_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['dashboard_rk'], ['dashboard.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('dashboard_rk', 'table_rk')
    )
    op.create_table(
        'table_badge',
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('badge_rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['badge_rk'], ['badge.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('table_rk', 'badge_rk')
    )
    op.create_table(
        'table_description',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('description_source', sa.String(length=32), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'table_follower',
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('user_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['user_rk'], ['users.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('table_rk', 'user_rk')
    )
    op.create_table(
        'table_owner',
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('user_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['user_rk'], ['users.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('table_rk', 'user_rk')
    )
    op.create_table(
        'table_programmatic_description',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('description_source', sa.String(length=32), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'table_source',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('source', sa.String(length=2048), nullable=False),
        sa.Column('source_type', sa.String(length=32), nullable=False),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'table_tag',
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('tag_rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['tag_rk'], ['tag.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('table_rk', 'tag_rk')
    )
    op.create_table(
        'table_timestamp',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('last_updated_timestamp', sa.Integer(), nullable=False),
        sa.Column('timestamp', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(length=256), nullable=False),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'table_usage',
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('user_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('read_count', sa.Integer(), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['user_rk'], ['users.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('table_rk', 'user_rk')
    )
    op.create_table(
        'table_watermark',
        sa.Column('rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('partition_key', sa.String(length=32), nullable=False),
        sa.Column('partition_value', sa.String(length=32), nullable=False),
        sa.Column('create_time', sa.String(length=32), nullable=False),
        sa.Column('table_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['table_rk'], ['table_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'column_badge',
        sa.Column('column_rk', sa.String(length=1536, collation='latin1_general_cs'), nullable=False),
        sa.Column('badge_rk', sa.String(length=128, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['badge_rk'], ['badge.rk'], ondelete='cascade'),
        sa.ForeignKeyConstraint(['column_rk'], ['column_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('column_rk', 'badge_rk')
    )
    op.create_table(
        'column_description',
        sa.Column('rk', sa.String(length=1536, collation='latin1_general_cs'), nullable=False),
        sa.Column('description_source', sa.String(length=32), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('column_rk', sa.String(length=1024, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=True),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(['column_rk'], ['column_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    op.create_table(
        'column_stat',
        sa.Column('rk', sa.String(length=1536, collation='latin1_general_cs'), nullable=False),
        sa.Column('stat_type', sa.String(length=256), nullable=False),
        sa.Column('stat_val', sa.String(length=128), nullable=False),
        sa.Column('start_epoch', sa.String(length=16), nullable=False),
        sa.Column('end_epoch', sa.String(length=16), nullable=False),
        sa.Column('column_rk', sa.String(length=1536, collation='latin1_general_cs'), nullable=False),
        sa.Column('published_tag', sa.String(length=128), nullable=False),
        sa.Column('publisher_last_updated_epoch_ms', sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(['column_rk'], ['column_metadata.rk'], ondelete='cascade'),
        sa.PrimaryKeyConstraint('rk')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('column_stat')
    op.drop_table('column_description')
    op.drop_table('column_badge')
    op.drop_table('table_watermark')
    op.drop_table('table_usage')
    op.drop_table('table_timestamp')
    op.drop_table('table_tag')
    op.drop_table('table_source')
    op.drop_table('table_programmatic_description')
    op.drop_table('table_owner')
    op.drop_table('table_follower')
    op.drop_table('table_description')
    op.drop_table('table_badge')
    op.drop_table('dashboard_table')
    op.drop_table('dashboard_chart')
    op.drop_table('column_metadata')
    op.drop_table('application_table')
    op.drop_table('table_metadata')
    op.drop_table('schema_programmatic_description')
    op.drop_table('schema_description')
    op.drop_table('dashboard_usage')
    op.drop_table('dashboard_timestamp')
    op.drop_table('dashboard_tag')
    op.drop_table('dashboard_query')
    op.drop_table('dashboard_owner')
    op.drop_table('dashboard_follower')
    op.drop_table('dashboard_execution')
    op.drop_table('dashboard_description')
    op.drop_table('dashboard_badge')
    op.drop_table('schema_metadata')
    op.drop_table('dashboard_group_description')
    op.drop_table('dashboard')
    op.drop_table('dashboard_group')
    op.drop_table('cluster_metadata')
    op.drop_table('users')
    op.drop_table('updated_timestamp')
    op.drop_table('tag')
    op.drop_table('database_metadata')
    op.drop_table('dashboard_cluster')
    op.drop_table('badge')
    op.drop_table('application')
    # ### end Alembic commands ###
