# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2020-03-30 10:59
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Role',
            fields=[
                ('group_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='auth.Group')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='rbac_permissions.Role')),
            ],
            bases=('auth.group',),
        ),
        migrations.CreateModel(
            name='RoleMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('permission', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='memberships', to='auth.Permission')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='memberships', to='rbac_permissions.Role')),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('paths', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=list, null=True)),
                ('rules', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='rolemembership',
            name='transaction',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='rbac_permissions.Transaction'),
        ),
        migrations.AddField(
            model_name='role',
            name='permission_set',
            field=models.ManyToManyField(related_name='roles', through='rbac_permissions.RoleMembership', to='auth.Permission', verbose_name='permissions'),
        ),
    ]
