"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [comprehend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehend.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehend extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [comprehend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehend.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'comprehend';
        this.accessLevelList = {
            Read: [
                'BatchDetectDominantLanguage',
                'BatchDetectEntities',
                'BatchDetectKeyPhrases',
                'BatchDetectSentiment',
                'BatchDetectSyntax',
                'ClassifyDocument',
                'ContainsPiiEntities',
                'DescribeDocumentClassificationJob',
                'DescribeDocumentClassifier',
                'DescribeDominantLanguageDetectionJob',
                'DescribeEndpoint',
                'DescribeEntitiesDetectionJob',
                'DescribeEntityRecognizer',
                'DescribeEventsDetectionJob',
                'DescribeKeyPhrasesDetectionJob',
                'DescribePiiEntitiesDetectionJob',
                'DescribeResourcePolicy',
                'DescribeSentimentDetectionJob',
                'DescribeTopicsDetectionJob',
                'DetectDominantLanguage',
                'DetectEntities',
                'DetectKeyPhrases',
                'DetectPiiEntities',
                'DetectSentiment',
                'DetectSyntax',
                'ListDocumentClassificationJobs',
                'ListDocumentClassifierSummaries',
                'ListDocumentClassifiers',
                'ListDominantLanguageDetectionJobs',
                'ListEndpoints',
                'ListEntitiesDetectionJobs',
                'ListEntityRecognizerSummaries',
                'ListEntityRecognizers',
                'ListEventsDetectionJobs',
                'ListKeyPhrasesDetectionJobs',
                'ListPiiEntitiesDetectionJobs',
                'ListSentimentDetectionJobs',
                'ListTagsForResource',
                'ListTopicsDetectionJobs'
            ],
            Write: [
                'CreateDocumentClassifier',
                'CreateEndpoint',
                'CreateEntityRecognizer',
                'DeleteDocumentClassifier',
                'DeleteEndpoint',
                'DeleteEntityRecognizer',
                'DeleteResourcePolicy',
                'ImportModel',
                'PutResourcePolicy',
                'StartDocumentClassificationJob',
                'StartDominantLanguageDetectionJob',
                'StartEntitiesDetectionJob',
                'StartEventsDetectionJob',
                'StartKeyPhrasesDetectionJob',
                'StartPiiEntitiesDetectionJob',
                'StartSentimentDetectionJob',
                'StartTopicsDetectionJob',
                'StopDominantLanguageDetectionJob',
                'StopEntitiesDetectionJob',
                'StopEventsDetectionJob',
                'StopKeyPhrasesDetectionJob',
                'StopPiiEntitiesDetectionJob',
                'StopSentimentDetectionJob',
                'StopTrainingDocumentClassifier',
                'StopTrainingEntityRecognizer',
                'UpdateEndpoint'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to detect the language or languages present in the list of text documents
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectDominantLanguage.html
     */
    toBatchDetectDominantLanguage() {
        return this.to('BatchDetectDominantLanguage');
    }
    /**
     * Grants permission to detect the named entities ("People", "Places", "Locations", etc) within the given list of text documents
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectEntities.html
     */
    toBatchDetectEntities() {
        return this.to('BatchDetectEntities');
    }
    /**
     * Grants permission to detect the phrases in the list of text documents that are most indicative of the content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectKeyPhrases.html
     */
    toBatchDetectKeyPhrases() {
        return this.to('BatchDetectKeyPhrases');
    }
    /**
     * Grants permission to detect the sentiment of a text in the list of documents (Positive, Negative, Neutral, or Mixed)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectSentiment.html
     */
    toBatchDetectSentiment() {
        return this.to('BatchDetectSentiment');
    }
    /**
     * Grants permission to detect syntactic information (like Part of Speech, Tokens) in a list of text documents
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectSyntax.html
     */
    toBatchDetectSyntax() {
        return this.to('BatchDetectSyntax');
    }
    /**
     * Grants permission to create a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ClassifyDocument.html
     */
    toClassifyDocument() {
        return this.to('ClassifyDocument');
    }
    /**
     * Grants permission to classify the personally identifiable information within given documents at realtime
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ContainsPiiEntities.html
     */
    toContainsPiiEntities() {
        return this.to('ContainsPiiEntities');
    }
    /**
     * Grants permission to create a new document classifier that you can use to categorize documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifModelKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateDocumentClassifier.html
     */
    toCreateDocumentClassifier() {
        return this.to('CreateDocumentClassifier');
    }
    /**
     * Grants permission to create a model-specific endpoint for synchronous inference for a previously trained custom model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateEndpoint.html
     */
    toCreateEndpoint() {
        return this.to('CreateEndpoint');
    }
    /**
     * Grants permission to create an entity recognizer using submitted files
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifModelKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateEntityRecognizer.html
     */
    toCreateEntityRecognizer() {
        return this.to('CreateEntityRecognizer');
    }
    /**
     * Grants permission to delete a previously created document classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteDocumentClassifier.html
     */
    toDeleteDocumentClassifier() {
        return this.to('DeleteDocumentClassifier');
    }
    /**
     * Grants permission to delete a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteEndpoint.html
     */
    toDeleteEndpoint() {
        return this.to('DeleteEndpoint');
    }
    /**
     * Grants permission to delete a submitted entity recognizer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteEntityRecognizer.html
     */
    toDeleteEntityRecognizer() {
        return this.to('DeleteEntityRecognizer');
    }
    /**
     * Grants permission to remove policy on resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to get the properties associated with a document classification job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDocumentClassificationJob.html
     */
    toDescribeDocumentClassificationJob() {
        return this.to('DescribeDocumentClassificationJob');
    }
    /**
     * Grants permission to get the properties associated with a document classifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDocumentClassifier.html
     */
    toDescribeDocumentClassifier() {
        return this.to('DescribeDocumentClassifier');
    }
    /**
     * Grants permission to get the properties associated with a dominant language detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDominantLanguageDetectionJob.html
     */
    toDescribeDominantLanguageDetectionJob() {
        return this.to('DescribeDominantLanguageDetectionJob');
    }
    /**
     * Grants permission to get the properties associated with a specific endpoint. Use this operation to get the status of an endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEndpoint.html
     */
    toDescribeEndpoint() {
        return this.to('DescribeEndpoint');
    }
    /**
     * Grants permission to get the properties associated with an entities detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEntitiesDetectionJob.html
     */
    toDescribeEntitiesDetectionJob() {
        return this.to('DescribeEntitiesDetectionJob');
    }
    /**
     * Grants permission to provide details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEntityRecognizer.html
     */
    toDescribeEntityRecognizer() {
        return this.to('DescribeEntityRecognizer');
    }
    /**
     * Grants permission to get the properties associated with an Events detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEventsDetectionJob.html
     */
    toDescribeEventsDetectionJob() {
        return this.to('DescribeEventsDetectionJob');
    }
    /**
     * Grants permission to get the properties associated with a key phrases detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeKeyPhrasesDetectionJob.html
     */
    toDescribeKeyPhrasesDetectionJob() {
        return this.to('DescribeKeyPhrasesDetectionJob');
    }
    /**
     * Grants permission to get the properties associated with a PII entities detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribePiiEntitiesDetectionJob.html
     */
    toDescribePiiEntitiesDetectionJob() {
        return this.to('DescribePiiEntitiesDetectionJob');
    }
    /**
     * Grants permission to read attached policy on resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeResourcePolicy.html
     */
    toDescribeResourcePolicy() {
        return this.to('DescribeResourcePolicy');
    }
    /**
     * Grants permission to get the properties associated with a sentiment detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeSentimentDetectionJob.html
     */
    toDescribeSentimentDetectionJob() {
        return this.to('DescribeSentimentDetectionJob');
    }
    /**
     * Grants permission to get the properties associated with a topic detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeTopicsDetectionJob.html
     */
    toDescribeTopicsDetectionJob() {
        return this.to('DescribeTopicsDetectionJob');
    }
    /**
     * Grants permission to detect the language or languages present in the text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html
     */
    toDetectDominantLanguage() {
        return this.to('DetectDominantLanguage');
    }
    /**
     * Grants permission to detect the named entities ("People", "Places", "Locations", etc) within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectEntities.html
     */
    toDetectEntities() {
        return this.to('DetectEntities');
    }
    /**
     * Grants permission to detect the phrases in the text that are most indicative of the content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectKeyPhrases.html
     */
    toDetectKeyPhrases() {
        return this.to('DetectKeyPhrases');
    }
    /**
     * Grants permission to detect the personally identifiable information entities ("Name", "SSN", "PIN", etc) within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectPiiEntities.html
     */
    toDetectPiiEntities() {
        return this.to('DetectPiiEntities');
    }
    /**
     * Grants permission to detect the sentiment of a text in a document (Positive, Negative, Neutral, or Mixed)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectSentiment.html
     */
    toDetectSentiment() {
        return this.to('DetectSentiment');
    }
    /**
     * Grants permission to detect syntactic information (like Part of Speech, Tokens) in a text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectSyntax.html
     */
    toDetectSyntax() {
        return this.to('DetectSyntax');
    }
    /**
     * Grants permission to import a trained Comprehend model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifModelKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ImportModel.html
     */
    toImportModel() {
        return this.to('ImportModel');
    }
    /**
     * Grants permission to get a list of the document classification jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassificationJobs.html
     */
    toListDocumentClassificationJobs() {
        return this.to('ListDocumentClassificationJobs');
    }
    /**
     * Grants permission to get a list of summaries of the document classifiers that you have created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassifierSummaries.html
     */
    toListDocumentClassifierSummaries() {
        return this.to('ListDocumentClassifierSummaries');
    }
    /**
     * Grants permission to get a list of the document classifiers that you have created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassifiers.html
     */
    toListDocumentClassifiers() {
        return this.to('ListDocumentClassifiers');
    }
    /**
     * Grants permission to get a list of the dominant language detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDominantLanguageDetectionJobs.html
     */
    toListDominantLanguageDetectionJobs() {
        return this.to('ListDominantLanguageDetectionJobs');
    }
    /**
     * Grants permission to get a list of all existing endpoints that you've created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEndpoints.html
     */
    toListEndpoints() {
        return this.to('ListEndpoints');
    }
    /**
     * Grants permission to get a list of the entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntitiesDetectionJobs.html
     */
    toListEntitiesDetectionJobs() {
        return this.to('ListEntitiesDetectionJobs');
    }
    /**
     * Grants permission to get a list of summaries for the entity recognizers that you have created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntityRecognizerSummaries.html
     */
    toListEntityRecognizerSummaries() {
        return this.to('ListEntityRecognizerSummaries');
    }
    /**
     * Grants permission to get a list of the properties of all entity recognizers that you created, including recognizers currently in training
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntityRecognizers.html
     */
    toListEntityRecognizers() {
        return this.to('ListEntityRecognizers');
    }
    /**
     * Grants permission to get a list of Events detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEventsDetectionJobs.html
     */
    toListEventsDetectionJobs() {
        return this.to('ListEventsDetectionJobs');
    }
    /**
     * Grants permission to get a list of key phrase detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListKeyPhrasesDetectionJobs.html
     */
    toListKeyPhrasesDetectionJobs() {
        return this.to('ListKeyPhrasesDetectionJobs');
    }
    /**
     * Grants permission to get a list of PII entities detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListPiiEntitiesDetectionJobs.html
     */
    toListPiiEntitiesDetectionJobs() {
        return this.to('ListPiiEntitiesDetectionJobs');
    }
    /**
     * Grants permission to get a list of sentiment detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListSentimentDetectionJobs.html
     */
    toListSentimentDetectionJobs() {
        return this.to('ListSentimentDetectionJobs');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to get a list of the topic detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListTopicsDetectionJobs.html
     */
    toListTopicsDetectionJobs() {
        return this.to('ListTopicsDetectionJobs');
    }
    /**
     * Grants permission to attach policy to resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_PutResourcePolicy.html
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Grants permission to start an asynchronous document classification job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartDocumentClassificationJob.html
     */
    toStartDocumentClassificationJob() {
        return this.to('StartDocumentClassificationJob');
    }
    /**
     * Grants permission to start an asynchronous dominant language detection job for a collection of documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartDominantLanguageDetectionJob.html
     */
    toStartDominantLanguageDetectionJob() {
        return this.to('StartDominantLanguageDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartEntitiesDetectionJob.html
     */
    toStartEntitiesDetectionJob() {
        return this.to('StartEntitiesDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous Events detection job for a collection of documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifOutputKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartEventsDetectionJob.html
     */
    toStartEventsDetectionJob() {
        return this.to('StartEventsDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous key phrase detection job for a collection of documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartKeyPhrasesDetectionJob.html
     */
    toStartKeyPhrasesDetectionJob() {
        return this.to('StartKeyPhrasesDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous PII entities detection job for a collection of documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifOutputKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartPiiEntitiesDetectionJob.html
     */
    toStartPiiEntitiesDetectionJob() {
        return this.to('StartPiiEntitiesDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous sentiment detection job for a collection of documents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartSentimentDetectionJob.html
     */
    toStartSentimentDetectionJob() {
        return this.to('StartSentimentDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous job to detect the most common topics in the collection of documents and the phrases associated with each topic
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartTopicsDetectionJob.html
     */
    toStartTopicsDetectionJob() {
        return this.to('StartTopicsDetectionJob');
    }
    /**
     * Grants permission to stop a dominant language detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopDominantLanguageDetectionJob.html
     */
    toStopDominantLanguageDetectionJob() {
        return this.to('StopDominantLanguageDetectionJob');
    }
    /**
     * Grants permission to stop an entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopEntitiesDetectionJob.html
     */
    toStopEntitiesDetectionJob() {
        return this.to('StopEntitiesDetectionJob');
    }
    /**
     * Grants permission to stop an Events detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopEventsDetectionJob.html
     */
    toStopEventsDetectionJob() {
        return this.to('StopEventsDetectionJob');
    }
    /**
     * Grants permission to stop a key phrase detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopKeyPhrasesDetectionJob.html
     */
    toStopKeyPhrasesDetectionJob() {
        return this.to('StopKeyPhrasesDetectionJob');
    }
    /**
     * Grants permission to stop a PII entities detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopPiiEntitiesDetectionJob.html
     */
    toStopPiiEntitiesDetectionJob() {
        return this.to('StopPiiEntitiesDetectionJob');
    }
    /**
     * Grants permission to stop a sentiment detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopSentimentDetectionJob.html
     */
    toStopSentimentDetectionJob() {
        return this.to('StopSentimentDetectionJob');
    }
    /**
     * Grants permission to stop a previously created document classifier training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopTrainingDocumentClassifier.html
     */
    toStopTrainingDocumentClassifier() {
        return this.to('StopTrainingDocumentClassifier');
    }
    /**
     * Grants permission to stop a previously created entity recognizer training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopTrainingEntityRecognizer.html
     */
    toStopTrainingEntityRecognizer() {
        return this.to('StopTrainingEntityRecognizer');
    }
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource with given key
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update information about the specified endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_UpdateEndpoint.html
     */
    toUpdateEndpoint() {
        return this.to('UpdateEndpoint');
    }
    /**
     * Adds a resource of type document-classifier to the statement
     *
     * @param documentClassifierName - Identifier for the documentClassifierName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDocumentClassifier(documentClassifierName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:document-classifier/${documentClassifierName}`);
    }
    /**
     * Adds a resource of type document-classifier-endpoint to the statement
     *
     * @param documentClassifierEndpointName - Identifier for the documentClassifierEndpointName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDocumentClassifierEndpoint(documentClassifierEndpointName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:document-classifier-endpoint/${documentClassifierEndpointName}`);
    }
    /**
     * Adds a resource of type entity-recognizer to the statement
     *
     * @param entityRecognizerName - Identifier for the entityRecognizerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEntityRecognizer(entityRecognizerName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:entity-recognizer/${entityRecognizerName}`);
    }
    /**
     * Adds a resource of type entity-recognizer-endpoint to the statement
     *
     * @param entityRecognizerEndpointName - Identifier for the entityRecognizerEndpointName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEntityRecognizerEndpoint(entityRecognizerEndpointName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:entity-recognizer-endpoint/${entityRecognizerEndpointName}`);
    }
    /**
     * Adds a resource of type dominant-language-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDominantLanguageDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:dominant-language-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type entities-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEntitiesDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:entities-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type pii-entities-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPiiEntitiesDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:pii-entities-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type events-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEventsDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:events-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type key-phrases-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKeyPhrasesDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:key-phrases-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type sentiment-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSentimentDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:sentiment-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type topics-detection-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTopicsDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:topics-detection-job/${jobId}`);
    }
    /**
     * Adds a resource of type document-classification-job to the statement
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDocumentClassificationJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:document-classification-job/${jobId}`);
    }
    /**
     * Filters access by the model KMS key associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toImportModel()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifModelKmsKey(value, operator) {
        return this.if(`ModelKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the output KMS key associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartEventsDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartPiiEntitiesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifOutputKmsKey(value, operator) {
        return this.if(`OutputKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the volume KMS key associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVolumeKmsKey(value, operator) {
        return this.if(`VolumeKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the list of all VPC security group ids associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcSecurityGroupIds(value, operator) {
        return this.if(`VpcSecurityGroupIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the list of all VPC subnets associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcSubnets(value, operator) {
        return this.if(`VpcSubnets`, value, operator || 'StringLike');
    }
}
exports.Comprehend = Comprehend;
_a = JSII_RTTI_SYMBOL_1;
Comprehend[_a] = { fqn: "iam-floyd.Comprehend", version: "0.344.0" };
//# sourceMappingURL=data:application/json;base64,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