import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [connect-campaigns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_high-volumeoutboundcommunications.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ConnectCampaigns extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [connect-campaigns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_high-volumeoutboundcommunications.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a campaign
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toCreateCampaign(): this;
    /**
     * Grants permission to delete a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toDeleteCampaign(): this;
    /**
     * Grants permission to describe a specific campaign
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toDescribeCampaign(): this;
    /**
     * Grants permission to get state of a campaign
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toGetCampaignState(): this;
    /**
     * Grants permission to get state of campaigns
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toGetCampaignStateBatch(): this;
    /**
     * Grants permission to provide summary of all campaigns
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toListCampaigns(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to pause a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toPauseCampaign(): this;
    /**
     * Grants permission to add configuration information for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toPutConnectInstanceConfig(): this;
    /**
     * Grants permission to create dial requests for the specified campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toPutDialRequestBatch(): this;
    /**
     * Grants permission to resume a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toResumeCampaign(): this;
    /**
     * Grants permission to start a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toStartCampaign(): this;
    /**
     * Grants permission to stop a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toStopCampaign(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the dialer configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUpdateCampaignDialerConfig(): this;
    /**
     * Grants permission to update the name of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUpdateCampaignName(): this;
    /**
     * Grants permission to update the outbound call configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUpdateCampaignOutboundCallConfig(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     *
     * @param campaignId - Identifier for the campaignId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCampaign(campaignId: string, account?: string, region?: string, partition?: string): this;
}
