"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotevents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotevents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotevents.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotevents extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotevents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotevents.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iotevents';
        this.accessLevelList = {
            Write: [
                'BatchAcknowledgeAlarm',
                'BatchDisableAlarm',
                'BatchEnableAlarm',
                'BatchPutMessage',
                'BatchResetAlarm',
                'BatchSnoozeAlarm',
                'BatchUpdateDetector',
                'CreateAlarmModel',
                'CreateDetectorModel',
                'CreateInput',
                'DeleteAlarmModel',
                'DeleteDetectorModel',
                'DeleteInput',
                'PutLoggingOptions',
                'StartDetectorModelAnalysis',
                'UpdateAlarmModel',
                'UpdateDetectorModel',
                'UpdateInput',
                'UpdateInputRouting'
            ],
            Read: [
                'DescribeAlarm',
                'DescribeAlarmModel',
                'DescribeDetector',
                'DescribeDetectorModel',
                'DescribeDetectorModelAnalysis',
                'DescribeInput',
                'DescribeLoggingOptions',
                'GetDetectorModelAnalysisResults',
                'ListTagsForResource'
            ],
            List: [
                'ListAlarmModelVersions',
                'ListAlarmModels',
                'ListAlarms',
                'ListDetectorModelVersions',
                'ListDetectorModels',
                'ListDetectors',
                'ListInputRoutings',
                'ListInputs'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to send one or more acknowledge action requests to AWS IoT Events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchAcknowledgeAlarm.html
     */
    toBatchAcknowledgeAlarm() {
        return this.to('BatchAcknowledgeAlarm');
    }
    /**
     * Grants permission to disable one or more alarm instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchDisableAlarm.html
     */
    toBatchDisableAlarm() {
        return this.to('BatchDisableAlarm');
    }
    /**
     * Grants permission to enable one or more alarm instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchEnableAlarm.html
     */
    toBatchEnableAlarm() {
        return this.to('BatchEnableAlarm');
    }
    /**
     * Grants permission to send a set of messages to the AWS IoT Events system
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html
     */
    toBatchPutMessage() {
        return this.to('BatchPutMessage');
    }
    /**
     * Grants permission to reset one or more alarm instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchResetAlarm.html
     */
    toBatchResetAlarm() {
        return this.to('BatchResetAlarm');
    }
    /**
     * Grants permission to change one or more alarm instances to the snooze mode
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchSnoozeAlarm.html
     */
    toBatchSnoozeAlarm() {
        return this.to('BatchSnoozeAlarm');
    }
    /**
     * Grants permission to update a detector instance within the AWS IoT Events system
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchUpdateDetector.html
     */
    toBatchUpdateDetector() {
        return this.to('BatchUpdateDetector');
    }
    /**
     * Grants permission to create an alarm model to monitor an AWS IoT Events input attribute or an AWS IoT SiteWise asset property
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html
     */
    toCreateAlarmModel() {
        return this.to('CreateAlarmModel');
    }
    /**
     * Grants permission to create a detector model to monitor an AWS IoT Events input attribute
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html
     */
    toCreateDetectorModel() {
        return this.to('CreateDetectorModel');
    }
    /**
     * Grants permission to create an Input in IotEvents
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateInput.html
     */
    toCreateInput() {
        return this.to('CreateInput');
    }
    /**
     * Grants permission to delete an alarm model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DeleteAlarmModel.html
     */
    toDeleteAlarmModel() {
        return this.to('DeleteAlarmModel');
    }
    /**
     * Grants permission to delete a detector model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DeleteDetectorModel.html
     */
    toDeleteDetectorModel() {
        return this.to('DeleteDetectorModel');
    }
    /**
     * Grants permission to delete an input
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DeleteInput.html
     */
    toDeleteInput() {
        return this.to('DeleteInput');
    }
    /**
     * Grants permission to retrieve information about an alarm instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_DescribeAlarm.html
     */
    toDescribeAlarm() {
        return this.to('DescribeAlarm');
    }
    /**
     * Grants permission to retrieve information about an alarm model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DescribeAlarmModel.html
     */
    toDescribeAlarmModel() {
        return this.to('DescribeAlarmModel');
    }
    /**
     * Grants permission to retriev information about a detector instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_DescribeDetector.html
     */
    toDescribeDetector() {
        return this.to('DescribeDetector');
    }
    /**
     * Grants permission to retrieve information about a detector model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DescribeDetectorModel.html
     */
    toDescribeDetectorModel() {
        return this.to('DescribeDetectorModel');
    }
    /**
     * Grants permission to retrieve the detector model analysis information
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DescribeDetectorModelAnalysis.html
     */
    toDescribeDetectorModelAnalysis() {
        return this.to('DescribeDetectorModelAnalysis');
    }
    /**
     * Grants permission to retrieve an information about Input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DescribeInput.html
     */
    toDescribeInput() {
        return this.to('DescribeInput');
    }
    /**
     * Grants permission to retrieve the current settings of the AWS IoT Events logging options
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_DescribeLoggingOptions.html
     */
    toDescribeLoggingOptions() {
        return this.to('DescribeLoggingOptions');
    }
    /**
     * Grants permission to retrieve the detector model analysis results
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_GetDetectorModelAnalysisResults.html
     */
    toGetDetectorModelAnalysisResults() {
        return this.to('GetDetectorModelAnalysisResults');
    }
    /**
     * Grants permission to list all the versions of an alarm model
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListAlarmModelVersions.html
     */
    toListAlarmModelVersions() {
        return this.to('ListAlarmModelVersions');
    }
    /**
     * Grants permission to list the alarm models that you created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListAlarmModels.html
     */
    toListAlarmModels() {
        return this.to('ListAlarmModels');
    }
    /**
     * Grants permission to retrieve information about all alarm instances per alarmModel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListAlarms.html
     */
    toListAlarms() {
        return this.to('ListAlarms');
    }
    /**
     * Grants permission to list all the versions of a detector model
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListDetectorModelVersions.html
     */
    toListDetectorModelVersions() {
        return this.to('ListDetectorModelVersions');
    }
    /**
     * Grants permission to list the detector models that you created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListDetectorModels.html
     */
    toListDetectorModels() {
        return this.to('ListDetectorModels');
    }
    /**
     * Grants permission to retrieve information about all detector instances per detectormodel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html
     */
    toListDetectors() {
        return this.to('ListDetectors');
    }
    /**
     * Grants permission to list one or more input routings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListInputRoutings.html
     */
    toListInputRoutings() {
        return this.to('ListInputRoutings');
    }
    /**
     * Grants permission to lists the inputs you have created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListInputs.html
     */
    toListInputs() {
        return this.to('ListInputs');
    }
    /**
     * Grants permission to list the tags (metadata) which you have assigned to the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to set or update the AWS IoT Events logging options
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_PutLoggingOptions.html
     */
    toPutLoggingOptions() {
        return this.to('PutLoggingOptions');
    }
    /**
     * Grants permission to start the detector model analysis
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_StartDetectorModelAnalysis.html
     */
    toStartDetectorModelAnalysis() {
        return this.to('StartDetectorModelAnalysis');
    }
    /**
     * Grants permission to adds to or modifies the tags of the given resource.Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove the given tags (metadata) from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an alarm model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_UpdateAlarmModel.html
     */
    toUpdateAlarmModel() {
        return this.to('UpdateAlarmModel');
    }
    /**
     * Grants permission to update a detector model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_UpdateDetectorModel.html
     */
    toUpdateDetectorModel() {
        return this.to('UpdateDetectorModel');
    }
    /**
     * Grants permission to update an input
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_UpdateInput.html
     */
    toUpdateInput() {
        return this.to('UpdateInput');
    }
    /**
     * Grants permission to update input routing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotevents/latest/apireference/API_UpdateInputRouting.html
     */
    toUpdateInputRouting() {
        return this.to('UpdateInputRouting');
    }
    /**
     * Adds a resource of type detectorModel to the statement
     *
     * https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-getting-started.html
     *
     * @param detectorModelName - Identifier for the detectorModelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDetectorModel(detectorModelName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotevents:${region || '*'}:${account || '*'}:detectorModel/${detectorModelName}`);
    }
    /**
     * Adds a resource of type alarmModel to the statement
     *
     * https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-getting-started.html
     *
     * @param alarmModelName - Identifier for the alarmModelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAlarmModel(alarmModelName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotevents:${region || '*'}:${account || '*'}:alarmModel/${alarmModelName}`);
    }
    /**
     * Adds a resource of type input to the statement
     *
     * https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-getting-started.html
     *
     * @param inputName - Identifier for the inputName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInput(inputName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotevents:${region || '*'}:${account || '*'}:input/${inputName}`);
    }
    /**
     * Filters access by the instanceId (key-value) of the message
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyValue(value, operator) {
        return this.if(`keyValue`, value, operator || 'StringLike');
    }
}
exports.Iotevents = Iotevents;
_a = JSII_RTTI_SYMBOL_1;
Iotevents[_a] = { fqn: "iam-floyd.Iotevents", version: "0.344.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW90ZXZlbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW90ZXZlbnRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQXNEO0FBRXREOzs7O0dBSUc7QUFDSCxNQUFhLFNBQVUsU0FBUSx3QkFBZTtJQUc1Qzs7OztPQUlHO0lBQ0gsWUFBWSxHQUFZO1FBQ3RCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQVJOLGtCQUFhLEdBQUcsV0FBVyxDQUFDO1FBZ2N6QixvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsdUJBQXVCO2dCQUN2QixtQkFBbUI7Z0JBQ25CLGtCQUFrQjtnQkFDbEIsaUJBQWlCO2dCQUNqQixpQkFBaUI7Z0JBQ2pCLGtCQUFrQjtnQkFDbEIscUJBQXFCO2dCQUNyQixrQkFBa0I7Z0JBQ2xCLHFCQUFxQjtnQkFDckIsYUFBYTtnQkFDYixrQkFBa0I7Z0JBQ2xCLHFCQUFxQjtnQkFDckIsYUFBYTtnQkFDYixtQkFBbUI7Z0JBQ25CLDRCQUE0QjtnQkFDNUIsa0JBQWtCO2dCQUNsQixxQkFBcUI7Z0JBQ3JCLGFBQWE7Z0JBQ2Isb0JBQW9CO2FBQ3JCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLGVBQWU7Z0JBQ2Ysb0JBQW9CO2dCQUNwQixrQkFBa0I7Z0JBQ2xCLHVCQUF1QjtnQkFDdkIsK0JBQStCO2dCQUMvQixlQUFlO2dCQUNmLHdCQUF3QjtnQkFDeEIsaUNBQWlDO2dCQUNqQyxxQkFBcUI7YUFDdEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osd0JBQXdCO2dCQUN4QixpQkFBaUI7Z0JBQ2pCLFlBQVk7Z0JBQ1osMkJBQTJCO2dCQUMzQixvQkFBb0I7Z0JBQ3BCLGVBQWU7Z0JBQ2YsbUJBQW1CO2dCQUNuQixZQUFZO2FBQ2I7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsYUFBYTtnQkFDYixlQUFlO2FBQ2hCO1NBQ0YsQ0FBQztJQXRlRixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDRCQUE0QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQW1ERDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxlQUFlLENBQUMsaUJBQXlCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDckcsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sY0FBZSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLGtCQUFtQixpQkFBa0IsRUFBRSxDQUFDLENBQUM7SUFDdEksQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLFlBQVksQ0FBQyxjQUFzQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQy9GLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxLQUFNLGNBQWUsTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxlQUFnQixjQUFlLEVBQUUsQ0FBQyxDQUFDO0lBQ2hJLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxPQUFPLENBQUMsU0FBaUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNyRixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxjQUFlLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksVUFBVyxTQUFVLEVBQUUsQ0FBQyxDQUFDO0lBQ3RILENBQUM7SUFFRDs7Ozs7T0FLRztJQUNJLFVBQVUsQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQ3RFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUM5RCxDQUFDOztBQTdpQkgsOEJBOGlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtpb3RldmVudHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2lvdGV2ZW50cy5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIElvdGV2ZW50cyBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2lvdGV2ZW50cyc7XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbaW90ZXZlbnRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3Npb3RldmVudHMuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzZW5kIG9uZSBvciBtb3JlIGFja25vd2xlZGdlIGFjdGlvbiByZXF1ZXN0cyB0byBBV1MgSW9UIEV2ZW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfaW90ZXZlbnRzLWRhdGFfQmF0Y2hBY2tub3dsZWRnZUFsYXJtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0JhdGNoQWNrbm93bGVkZ2VBbGFybSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hBY2tub3dsZWRnZUFsYXJtJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGlzYWJsZSBvbmUgb3IgbW9yZSBhbGFybSBpbnN0YW5jZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX2lvdGV2ZW50cy1kYXRhX0JhdGNoRGlzYWJsZUFsYXJtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0JhdGNoRGlzYWJsZUFsYXJtKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaERpc2FibGVBbGFybScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGVuYWJsZSBvbmUgb3IgbW9yZSBhbGFybSBpbnN0YW5jZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX2lvdGV2ZW50cy1kYXRhX0JhdGNoRW5hYmxlQWxhcm0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hFbmFibGVBbGFybSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hFbmFibGVBbGFybScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHNlbmQgYSBzZXQgb2YgbWVzc2FnZXMgdG8gdGhlIEFXUyBJb1QgRXZlbnRzIHN5c3RlbVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfaW90ZXZlbnRzLWRhdGFfQmF0Y2hQdXRNZXNzYWdlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0JhdGNoUHV0TWVzc2FnZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hQdXRNZXNzYWdlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVzZXQgb25lIG9yIG1vcmUgYWxhcm0gaW5zdGFuY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9pb3RldmVudHMtZGF0YV9CYXRjaFJlc2V0QWxhcm0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hSZXNldEFsYXJtKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaFJlc2V0QWxhcm0nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjaGFuZ2Ugb25lIG9yIG1vcmUgYWxhcm0gaW5zdGFuY2VzIHRvIHRoZSBzbm9vemUgbW9kZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfaW90ZXZlbnRzLWRhdGFfQmF0Y2hTbm9vemVBbGFybS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9CYXRjaFNub296ZUFsYXJtKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaFNub296ZUFsYXJtJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgZGV0ZWN0b3IgaW5zdGFuY2Ugd2l0aGluIHRoZSBBV1MgSW9UIEV2ZW50cyBzeXN0ZW1cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX2lvdGV2ZW50cy1kYXRhX0JhdGNoVXBkYXRlRGV0ZWN0b3IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hVcGRhdGVEZXRlY3RvcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hVcGRhdGVEZXRlY3RvcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhbiBhbGFybSBtb2RlbCB0byBtb25pdG9yIGFuIEFXUyBJb1QgRXZlbnRzIGlucHV0IGF0dHJpYnV0ZSBvciBhbiBBV1MgSW9UIFNpdGVXaXNlIGFzc2V0IHByb3BlcnR5XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVBbGFybU1vZGVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUFsYXJtTW9kZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUFsYXJtTW9kZWwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBkZXRlY3RvciBtb2RlbCB0byBtb25pdG9yIGFuIEFXUyBJb1QgRXZlbnRzIGlucHV0IGF0dHJpYnV0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlRGV0ZWN0b3JNb2RlbC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVEZXRlY3Rvck1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVEZXRlY3Rvck1vZGVsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGFuIElucHV0IGluIElvdEV2ZW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlSW5wdXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUlucHV0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFuIGFsYXJtIG1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVBbGFybU1vZGVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUFsYXJtTW9kZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUFsYXJtTW9kZWwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBkZXRlY3RvciBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlRGV0ZWN0b3JNb2RlbC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVEZXRlY3Rvck1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVEZXRlY3Rvck1vZGVsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFuIGlucHV0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVJbnB1dC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlSW5wdXQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSBpbmZvcm1hdGlvbiBhYm91dCBhbiBhbGFybSBpbnN0YW5jZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9pb3RldmVudHMtZGF0YV9EZXNjcmliZUFsYXJtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQWxhcm0oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQWxhcm0nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSBpbmZvcm1hdGlvbiBhYm91dCBhbiBhbGFybSBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUFsYXJtTW9kZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVBbGFybU1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUFsYXJtTW9kZWwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2IGluZm9ybWF0aW9uIGFib3V0IGEgZGV0ZWN0b3IgaW5zdGFuY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfaW90ZXZlbnRzLWRhdGFfRGVzY3JpYmVEZXRlY3Rvci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZURldGVjdG9yKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZURldGVjdG9yJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmV0cmlldmUgaW5mb3JtYXRpb24gYWJvdXQgYSBkZXRlY3RvciBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZURldGVjdG9yTW9kZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVEZXRlY3Rvck1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZURldGVjdG9yTW9kZWwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSB0aGUgZGV0ZWN0b3IgbW9kZWwgYW5hbHlzaXMgaW5mb3JtYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVEZXRlY3Rvck1vZGVsQW5hbHlzaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVEZXRlY3Rvck1vZGVsQW5hbHlzaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRGV0ZWN0b3JNb2RlbEFuYWx5c2lzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmV0cmlldmUgYW4gaW5mb3JtYXRpb24gYWJvdXQgSW5wdXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVJbnB1dC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUlucHV0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmV0cmlldmUgdGhlIGN1cnJlbnQgc2V0dGluZ3Mgb2YgdGhlIEFXUyBJb1QgRXZlbnRzIGxvZ2dpbmcgb3B0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUxvZ2dpbmdPcHRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlTG9nZ2luZ09wdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlTG9nZ2luZ09wdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSB0aGUgZGV0ZWN0b3IgbW9kZWwgYW5hbHlzaXMgcmVzdWx0c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXREZXRlY3Rvck1vZGVsQW5hbHlzaXNSZXN1bHRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldERldGVjdG9yTW9kZWxBbmFseXNpc1Jlc3VsdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldERldGVjdG9yTW9kZWxBbmFseXNpc1Jlc3VsdHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCB0aGUgdmVyc2lvbnMgb2YgYW4gYWxhcm0gbW9kZWxcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEFsYXJtTW9kZWxWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QWxhcm1Nb2RlbFZlcnNpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0QWxhcm1Nb2RlbFZlcnNpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0aGUgYWxhcm0gbW9kZWxzIHRoYXQgeW91IGNyZWF0ZWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEFsYXJtTW9kZWxzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBbGFybU1vZGVscygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEFsYXJtTW9kZWxzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmV0cmlldmUgaW5mb3JtYXRpb24gYWJvdXQgYWxsIGFsYXJtIGluc3RhbmNlcyBwZXIgYWxhcm1Nb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9pb3RldmVudHMtZGF0YV9MaXN0QWxhcm1zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBbGFybXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBbGFybXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCB0aGUgdmVyc2lvbnMgb2YgYSBkZXRlY3RvciBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0RGV0ZWN0b3JNb2RlbFZlcnNpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3REZXRlY3Rvck1vZGVsVmVyc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3REZXRlY3Rvck1vZGVsVmVyc2lvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHRoZSBkZXRlY3RvciBtb2RlbHMgdGhhdCB5b3UgY3JlYXRlZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0RGV0ZWN0b3JNb2RlbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdERldGVjdG9yTW9kZWxzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RGV0ZWN0b3JNb2RlbHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSBpbmZvcm1hdGlvbiBhYm91dCBhbGwgZGV0ZWN0b3IgaW5zdGFuY2VzIHBlciBkZXRlY3Rvcm1vZGVsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX2lvdGV2ZW50cy1kYXRhX0xpc3REZXRlY3RvcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdERldGVjdG9ycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdERldGVjdG9ycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3Qgb25lIG9yIG1vcmUgaW5wdXQgcm91dGluZ3NcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdElucHV0Um91dGluZ3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdElucHV0Um91dGluZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RJbnB1dFJvdXRpbmdzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdHMgdGhlIGlucHV0cyB5b3UgaGF2ZSBjcmVhdGVkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RJbnB1dHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdElucHV0cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdElucHV0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIHRhZ3MgKG1ldGFkYXRhKSB3aGljaCB5b3UgaGF2ZSBhc3NpZ25lZCB0byB0aGUgcmVzb3VyY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFRhZ3NGb3JSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGFnc0ZvclJlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc2V0IG9yIHVwZGF0ZSB0aGUgQVdTIElvVCBFdmVudHMgbG9nZ2luZyBvcHRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9QdXRMb2dnaW5nT3B0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9QdXRMb2dnaW5nT3B0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUHV0TG9nZ2luZ09wdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCB0aGUgZGV0ZWN0b3IgbW9kZWwgYW5hbHlzaXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1N0YXJ0RGV0ZWN0b3JNb2RlbEFuYWx5c2lzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0RGV0ZWN0b3JNb2RlbEFuYWx5c2lzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydERldGVjdG9yTW9kZWxBbmFseXNpcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGFkZHMgdG8gb3IgbW9kaWZpZXMgdGhlIHRhZ3Mgb2YgdGhlIGdpdmVuIHJlc291cmNlLlRhZ3MgYXJlIG1ldGFkYXRhIHdoaWNoIGNhbiBiZSB1c2VkIHRvIG1hbmFnZSBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1RhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1RhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdUYWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJlbW92ZSB0aGUgZ2l2ZW4gdGFncyAobWV0YWRhdGEpIGZyb20gdGhlIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VudGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVW50YWdSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVW50YWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhbiBhbGFybSBtb2RlbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQWxhcm1Nb2RlbC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBbGFybU1vZGVsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVBbGFybU1vZGVsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgZGV0ZWN0b3IgbW9kZWxcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZURldGVjdG9yTW9kZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRGV0ZWN0b3JNb2RlbCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRGV0ZWN0b3JNb2RlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhbiBpbnB1dFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlSW5wdXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUlucHV0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGlucHV0IHJvdXRpbmdcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90ZXZlbnRzL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZUlucHV0Um91dGluZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVJbnB1dFJvdXRpbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUlucHV0Um91dGluZycpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFdyaXRlOiBbXG4gICAgICAnQmF0Y2hBY2tub3dsZWRnZUFsYXJtJyxcbiAgICAgICdCYXRjaERpc2FibGVBbGFybScsXG4gICAgICAnQmF0Y2hFbmFibGVBbGFybScsXG4gICAgICAnQmF0Y2hQdXRNZXNzYWdlJyxcbiAgICAgICdCYXRjaFJlc2V0QWxhcm0nLFxuICAgICAgJ0JhdGNoU25vb3plQWxhcm0nLFxuICAgICAgJ0JhdGNoVXBkYXRlRGV0ZWN0b3InLFxuICAgICAgJ0NyZWF0ZUFsYXJtTW9kZWwnLFxuICAgICAgJ0NyZWF0ZURldGVjdG9yTW9kZWwnLFxuICAgICAgJ0NyZWF0ZUlucHV0JyxcbiAgICAgICdEZWxldGVBbGFybU1vZGVsJyxcbiAgICAgICdEZWxldGVEZXRlY3Rvck1vZGVsJyxcbiAgICAgICdEZWxldGVJbnB1dCcsXG4gICAgICAnUHV0TG9nZ2luZ09wdGlvbnMnLFxuICAgICAgJ1N0YXJ0RGV0ZWN0b3JNb2RlbEFuYWx5c2lzJyxcbiAgICAgICdVcGRhdGVBbGFybU1vZGVsJyxcbiAgICAgICdVcGRhdGVEZXRlY3Rvck1vZGVsJyxcbiAgICAgICdVcGRhdGVJbnB1dCcsXG4gICAgICAnVXBkYXRlSW5wdXRSb3V0aW5nJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0Rlc2NyaWJlQWxhcm0nLFxuICAgICAgJ0Rlc2NyaWJlQWxhcm1Nb2RlbCcsXG4gICAgICAnRGVzY3JpYmVEZXRlY3RvcicsXG4gICAgICAnRGVzY3JpYmVEZXRlY3Rvck1vZGVsJyxcbiAgICAgICdEZXNjcmliZURldGVjdG9yTW9kZWxBbmFseXNpcycsXG4gICAgICAnRGVzY3JpYmVJbnB1dCcsXG4gICAgICAnRGVzY3JpYmVMb2dnaW5nT3B0aW9ucycsXG4gICAgICAnR2V0RGV0ZWN0b3JNb2RlbEFuYWx5c2lzUmVzdWx0cycsXG4gICAgICAnTGlzdFRhZ3NGb3JSZXNvdXJjZSdcbiAgICBdLFxuICAgIExpc3Q6IFtcbiAgICAgICdMaXN0QWxhcm1Nb2RlbFZlcnNpb25zJyxcbiAgICAgICdMaXN0QWxhcm1Nb2RlbHMnLFxuICAgICAgJ0xpc3RBbGFybXMnLFxuICAgICAgJ0xpc3REZXRlY3Rvck1vZGVsVmVyc2lvbnMnLFxuICAgICAgJ0xpc3REZXRlY3Rvck1vZGVscycsXG4gICAgICAnTGlzdERldGVjdG9ycycsXG4gICAgICAnTGlzdElucHV0Um91dGluZ3MnLFxuICAgICAgJ0xpc3RJbnB1dHMnXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnVGFnUmVzb3VyY2UnLFxuICAgICAgJ1VudGFnUmVzb3VyY2UnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBkZXRlY3Rvck1vZGVsIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90ZXZlbnRzLWdldHRpbmctc3RhcnRlZC5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBkZXRlY3Rvck1vZGVsTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBkZXRlY3Rvck1vZGVsTmFtZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25EZXRlY3Rvck1vZGVsKGRldGVjdG9yTW9kZWxOYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTppb3RldmVudHM6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06ZGV0ZWN0b3JNb2RlbC8keyBkZXRlY3Rvck1vZGVsTmFtZSB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgYWxhcm1Nb2RlbCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3RldmVudHMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2lvdGV2ZW50cy1nZXR0aW5nLXN0YXJ0ZWQuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gYWxhcm1Nb2RlbE5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgYWxhcm1Nb2RlbE5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uQWxhcm1Nb2RlbChhbGFybU1vZGVsTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06aW90ZXZlbnRzOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmFsYXJtTW9kZWwvJHsgYWxhcm1Nb2RlbE5hbWUgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGlucHV0IHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdGV2ZW50cy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90ZXZlbnRzLWdldHRpbmctc3RhcnRlZC5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBpbnB1dE5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgaW5wdXROYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbklucHV0KGlucHV0TmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06aW90ZXZlbnRzOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmlucHV0LyR7IGlucHV0TmFtZSB9YCk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgdGhlIGluc3RhbmNlSWQgKGtleS12YWx1ZSkgb2YgdGhlIG1lc3NhZ2VcbiAgICpcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbc3RyaW5nIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19TdHJpbmcpLiAqKkRlZmF1bHQ6KiogYFN0cmluZ0xpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZLZXlWYWx1ZSh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihga2V5VmFsdWVgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxufVxuIl19