# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input[str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: "")` - A description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - A unique name for the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: "")` - A resource quota to attach to the namespace.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input[str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: "")` - A description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - A unique name for the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: "")` - A resource quota to attach to the namespace.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provisions a namespace within a Nomad cluster.

        Nomad auto-generates a default namespace called `default`. This namespace
        cannot be removed, so destroying a `Namespace` resource where
        `name = "default"` will cause the namespace to be reset to its default
        configuration.

        ## Example Usage

        Registering a namespace:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        dev = nomad.Namespace("dev",
            description="Shared development environment.",
            quota="dev")
        ```

        Registering a namespace with a quota:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        web_team = nomad.QuoteSpecification("webTeam",
            description="web team quota",
            limits=[nomad.QuoteSpecificationLimitArgs(
                region="global",
                region_limit=nomad.QuoteSpecificationLimitRegionLimitArgs(
                    cpu=1000,
                    memory_mb=256,
                ),
            )])
        web = nomad.Namespace("web",
            description="Web team production environment.",
            quota=web_team.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input[str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NamespaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provisions a namespace within a Nomad cluster.

        Nomad auto-generates a default namespace called `default`. This namespace
        cannot be removed, so destroying a `Namespace` resource where
        `name = "default"` will cause the namespace to be reset to its default
        configuration.

        ## Example Usage

        Registering a namespace:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        dev = nomad.Namespace("dev",
            description="Shared development environment.",
            quota="dev")
        ```

        Registering a namespace with a quota:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        web_team = nomad.QuoteSpecification("webTeam",
            description="web team quota",
            limits=[nomad.QuoteSpecificationLimitArgs(
                region="global",
                region_limit=nomad.QuoteSpecificationLimitRegionLimitArgs(
                    cpu=1000,
                    memory_mb=256,
                ),
            )])
        web = nomad.Namespace("web",
            description="Web team production environment.",
            quota=web_team.name)
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["quota"] = quota
        super(Namespace, __self__).__init__(
            'nomad:index/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            quota: Optional[pulumi.Input[str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input[str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["quota"] = quota
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: "")` - A description of the namespace.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - A unique name for the namespace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: "")` - A resource quota to attach to the namespace.
        """
        return pulumi.get(self, "quota")

