# coding: utf-8

"""
    Kodexa

    Content Intelligence  # noqa: E501

    OpenAPI spec version: 2.0.132
    Contact: suppot@kodexa.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from kodexa_cloud.api_client import ApiClient


class CloudSessionControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_pipeline_session_using_post(self, pipeline_id, **kwargs):  # noqa: E501
        """createPipelineSession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pipeline_session_using_post(pipeline_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pipeline_id: pipelineId (required)
        :param str x_access_token: x-access-token
        :return: CloudSession
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pipeline_session_using_post_with_http_info(pipeline_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pipeline_session_using_post_with_http_info(pipeline_id, **kwargs)  # noqa: E501
            return data

    def create_pipeline_session_using_post_with_http_info(self, pipeline_id, **kwargs):  # noqa: E501
        """createPipelineSession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pipeline_session_using_post_with_http_info(pipeline_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pipeline_id: pipelineId (required)
        :param str x_access_token: x-access-token
        :return: CloudSession
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pipeline_id', 'x_access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pipeline_session_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pipeline_id' is set
        if ('pipeline_id' not in params or
                params['pipeline_id'] is None):
            raise ValueError("Missing the required parameter `pipeline_id` when calling `create_pipeline_session_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pipeline_id' in params:
            query_params.append(('pipelineId', params['pipeline_id']))  # noqa: E501

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudSession',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_execution_document_using_get(self, document_id, execution_id, session_id, **kwargs):  # noqa: E501
        """getExecutionDocument  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_document_using_get(document_id, execution_id, session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str document_id: documentId (required)
        :param str execution_id: executionId (required)
        :param str session_id: sessionId (required)
        :param str x_access_token: x-access-token
        :return: ByteArrayResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_execution_document_using_get_with_http_info(document_id, execution_id, session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_execution_document_using_get_with_http_info(document_id, execution_id, session_id, **kwargs)  # noqa: E501
            return data

    def get_execution_document_using_get_with_http_info(self, document_id, execution_id, session_id, **kwargs):  # noqa: E501
        """getExecutionDocument  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_document_using_get_with_http_info(document_id, execution_id, session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str document_id: documentId (required)
        :param str execution_id: executionId (required)
        :param str session_id: sessionId (required)
        :param str x_access_token: x-access-token
        :return: ByteArrayResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'execution_id', 'session_id', 'x_access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_execution_document_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params or
                params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_execution_document_using_get`")  # noqa: E501
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_execution_document_using_get`")  # noqa: E501
        # verify the required parameter 'session_id' is set
        if ('session_id' not in params or
                params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_execution_document_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']  # noqa: E501
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']  # noqa: E501
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions/{sessionId}/executions/{executionId}/documents/{documentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ByteArrayResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_execution_file_using_get(self, execution_id, file_id, session_id, **kwargs):  # noqa: E501
        """getExecutionFile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_file_using_get(execution_id, file_id, session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str execution_id: executionId (required)
        :param str file_id: fileId (required)
        :param str session_id: sessionId (required)
        :param str x_access_token: x-access-token
        :return: ByteArrayResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_execution_file_using_get_with_http_info(execution_id, file_id, session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_execution_file_using_get_with_http_info(execution_id, file_id, session_id, **kwargs)  # noqa: E501
            return data

    def get_execution_file_using_get_with_http_info(self, execution_id, file_id, session_id, **kwargs):  # noqa: E501
        """getExecutionFile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_file_using_get_with_http_info(execution_id, file_id, session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str execution_id: executionId (required)
        :param str file_id: fileId (required)
        :param str session_id: sessionId (required)
        :param str x_access_token: x-access-token
        :return: ByteArrayResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id', 'file_id', 'session_id', 'x_access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_execution_file_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_execution_file_using_get`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_execution_file_using_get`")  # noqa: E501
        # verify the required parameter 'session_id' is set
        if ('session_id' not in params or
                params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_execution_file_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']  # noqa: E501
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions/{sessionId}/executions/{executionId}/files/{fileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ByteArrayResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_execution_using_get(self, execution_id, id, **kwargs):  # noqa: E501
        """getExecution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_using_get(execution_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str execution_id: executionId (required)
        :param str id: id (required)
        :param str x_access_token: x-access-token
        :return: CloudExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_execution_using_get_with_http_info(execution_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_execution_using_get_with_http_info(execution_id, id, **kwargs)  # noqa: E501
            return data

    def get_execution_using_get_with_http_info(self, execution_id, id, **kwargs):  # noqa: E501
        """getExecution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_using_get_with_http_info(execution_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str execution_id: executionId (required)
        :param str id: id (required)
        :param str x_access_token: x-access-token
        :return: CloudExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id', 'id', 'x_access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_execution_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_execution_using_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_execution_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions/{id}/executions/{executionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_store_content_using_get(self, execution_id, session_id, store_id, **kwargs):  # noqa: E501
        """getStoreContent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_store_content_using_get(execution_id, session_id, store_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str execution_id: executionId (required)
        :param str session_id: sessionId (required)
        :param str store_id: storeId (required)
        :param str x_access_token: x-access-token
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_store_content_using_get_with_http_info(execution_id, session_id, store_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_store_content_using_get_with_http_info(execution_id, session_id, store_id, **kwargs)  # noqa: E501
            return data

    def get_store_content_using_get_with_http_info(self, execution_id, session_id, store_id, **kwargs):  # noqa: E501
        """getStoreContent  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_store_content_using_get_with_http_info(execution_id, session_id, store_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str execution_id: executionId (required)
        :param str session_id: sessionId (required)
        :param str store_id: storeId (required)
        :param str x_access_token: x-access-token
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id', 'session_id', 'store_id', 'x_access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_store_content_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_store_content_using_get`")  # noqa: E501
        # verify the required parameter 'session_id' is set
        if ('session_id' not in params or
                params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_store_content_using_get`")  # noqa: E501
        # verify the required parameter 'store_id' is set
        if ('store_id' not in params or
                params['store_id'] is None):
            raise ValueError("Missing the required parameter `store_id` when calling `get_store_content_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']  # noqa: E501
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']  # noqa: E501
        if 'store_id' in params:
            path_params['storeId'] = params['store_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions/{sessionId}/executions/{executionId}/stores/{storeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sessions_using_get(self, **kwargs):  # noqa: E501
        """listSessions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sessions_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_access_token: x-access-token
        :return: list[CloudSession]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_sessions_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sessions_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sessions_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """listSessions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sessions_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_access_token: x-access-token
        :return: list[CloudSession]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sessions_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CloudSession]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_execution_using_post(self, id, **kwargs):  # noqa: E501
        """startExecution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_execution_using_post(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :param str document:
        :param str file:
        :param str x_access_token: x-access-token
        :param str options: options
        :return: CloudExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_execution_using_post_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.start_execution_using_post_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def start_execution_using_post_with_http_info(self, id, **kwargs):  # noqa: E501
        """startExecution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_execution_using_post_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :param str document:
        :param str file:
        :param str x_access_token: x-access-token
        :param str options: options
        :return: CloudExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'document', 'file', 'x_access_token', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_execution_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `start_execution_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'options' in params:
            query_params.append(('options', params['options']))  # noqa: E501

        header_params = {}
        if 'x_access_token' in params:
            header_params['x-access-token'] = params['x_access_token']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'document' in params:
            local_var_files['document'] = params['document']  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/sessions/{id}/execute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
