# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'BranchCommit',
    'BranchProtectionAllowedToMerge',
    'BranchProtectionAllowedToPush',
    'ProjectPushRules',
    'GetBranchCommitResult',
    'GetGroupMembershipMemberResult',
    'GetProjectProtectedBranchMergeAccessLevelResult',
    'GetProjectProtectedBranchPushAccessLevelResult',
    'GetProjectProtectedBranchesProtectedBranchResult',
    'GetProjectProtectedBranchesProtectedBranchMergeAccessLevelResult',
    'GetProjectProtectedBranchesProtectedBranchPushAccessLevelResult',
    'GetProjectPushRulesResult',
    'GetProjectsProjectResult',
    'GetProjectsProjectForkedFromProjectResult',
    'GetProjectsProjectNamespaceResult',
    'GetProjectsProjectOwnerResult',
    'GetProjectsProjectPermissionsResult',
    'GetProjectsProjectSharedWithGroupResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class BranchCommit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorEmail":
            suggest = "author_email"
        elif key == "authorName":
            suggest = "author_name"
        elif key == "authoredDate":
            suggest = "authored_date"
        elif key == "committedDate":
            suggest = "committed_date"
        elif key == "committerEmail":
            suggest = "committer_email"
        elif key == "committerName":
            suggest = "committer_name"
        elif key == "parentIds":
            suggest = "parent_ids"
        elif key == "shortId":
            suggest = "short_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchCommit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchCommit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchCommit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 author_email: Optional[str] = None,
                 author_name: Optional[str] = None,
                 authored_date: Optional[str] = None,
                 committed_date: Optional[str] = None,
                 committer_email: Optional[str] = None,
                 committer_name: Optional[str] = None,
                 id: Optional[str] = None,
                 message: Optional[str] = None,
                 parent_ids: Optional[Sequence[str]] = None,
                 short_id: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str id: The ID of this resource.
        """
        if author_email is not None:
            pulumi.set(__self__, "author_email", author_email)
        if author_name is not None:
            pulumi.set(__self__, "author_name", author_name)
        if authored_date is not None:
            pulumi.set(__self__, "authored_date", authored_date)
        if committed_date is not None:
            pulumi.set(__self__, "committed_date", committed_date)
        if committer_email is not None:
            pulumi.set(__self__, "committer_email", committer_email)
        if committer_name is not None:
            pulumi.set(__self__, "committer_name", committer_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if parent_ids is not None:
            pulumi.set(__self__, "parent_ids", parent_ids)
        if short_id is not None:
            pulumi.set(__self__, "short_id", short_id)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> Optional[str]:
        return pulumi.get(self, "author_email")

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[str]:
        return pulumi.get(self, "author_name")

    @property
    @pulumi.getter(name="authoredDate")
    def authored_date(self) -> Optional[str]:
        return pulumi.get(self, "authored_date")

    @property
    @pulumi.getter(name="committedDate")
    def committed_date(self) -> Optional[str]:
        return pulumi.get(self, "committed_date")

    @property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> Optional[str]:
        return pulumi.get(self, "committer_email")

    @property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> Optional[str]:
        return pulumi.get(self, "committer_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="parentIds")
    def parent_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "parent_ids")

    @property
    @pulumi.getter(name="shortId")
    def short_id(self) -> Optional[str]:
        return pulumi.get(self, "short_id")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        return pulumi.get(self, "title")


@pulumi.output_type
class BranchProtectionAllowedToMerge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"
        elif key == "accessLevelDescription":
            suggest = "access_level_description"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchProtectionAllowedToMerge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchProtectionAllowedToMerge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchProtectionAllowedToMerge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: Optional[str] = None,
                 access_level_description: Optional[str] = None,
                 group_id: Optional[int] = None,
                 user_id: Optional[int] = None):
        """
        :param str access_level: Level of access.
        :param str access_level_description: Readable description of level of access.
        :param int group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param int user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        """
        Level of access.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[str]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class BranchProtectionAllowedToPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"
        elif key == "accessLevelDescription":
            suggest = "access_level_description"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchProtectionAllowedToPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchProtectionAllowedToPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchProtectionAllowedToPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: Optional[str] = None,
                 access_level_description: Optional[str] = None,
                 group_id: Optional[int] = None,
                 user_id: Optional[int] = None):
        """
        :param str access_level: Level of access.
        :param str access_level_description: Readable description of level of access.
        :param int group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param int user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        """
        Level of access.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[str]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class ProjectPushRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorEmailRegex":
            suggest = "author_email_regex"
        elif key == "branchNameRegex":
            suggest = "branch_name_regex"
        elif key == "commitCommitterCheck":
            suggest = "commit_committer_check"
        elif key == "commitMessageNegativeRegex":
            suggest = "commit_message_negative_regex"
        elif key == "commitMessageRegex":
            suggest = "commit_message_regex"
        elif key == "denyDeleteTag":
            suggest = "deny_delete_tag"
        elif key == "fileNameRegex":
            suggest = "file_name_regex"
        elif key == "maxFileSize":
            suggest = "max_file_size"
        elif key == "memberCheck":
            suggest = "member_check"
        elif key == "preventSecrets":
            suggest = "prevent_secrets"
        elif key == "rejectUnsignedCommits":
            suggest = "reject_unsigned_commits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPushRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPushRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPushRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 author_email_regex: Optional[str] = None,
                 branch_name_regex: Optional[str] = None,
                 commit_committer_check: Optional[bool] = None,
                 commit_message_negative_regex: Optional[str] = None,
                 commit_message_regex: Optional[str] = None,
                 deny_delete_tag: Optional[bool] = None,
                 file_name_regex: Optional[str] = None,
                 max_file_size: Optional[int] = None,
                 member_check: Optional[bool] = None,
                 prevent_secrets: Optional[bool] = None,
                 reject_unsigned_commits: Optional[bool] = None):
        """
        :param str author_email_regex: All commit author emails must match this regex, e.g. `@my-company.com$`.
        :param str branch_name_regex: All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
        :param bool commit_committer_check: Users can only push commits to this repository that were committed with one of their own verified emails.
        :param str commit_message_negative_regex: No commit message is allowed to match this regex, for example `ssh\:\/\/`.
        :param str commit_message_regex: All commit messages must match this regex, e.g. `Fixed \d+\..*`.
        :param bool deny_delete_tag: Deny deleting a tag.
        :param str file_name_regex: All commited filenames must not match this regex, e.g. `(jar|exe)$`.
        :param int max_file_size: Maximum file size (MB).
        :param bool member_check: Restrict commits by author (email) to existing GitLab users.
        :param bool prevent_secrets: GitLab will reject any files that are likely to contain secrets.
        :param bool reject_unsigned_commits: Reject commit when it’s not signed through GPG.
        """
        if author_email_regex is not None:
            pulumi.set(__self__, "author_email_regex", author_email_regex)
        if branch_name_regex is not None:
            pulumi.set(__self__, "branch_name_regex", branch_name_regex)
        if commit_committer_check is not None:
            pulumi.set(__self__, "commit_committer_check", commit_committer_check)
        if commit_message_negative_regex is not None:
            pulumi.set(__self__, "commit_message_negative_regex", commit_message_negative_regex)
        if commit_message_regex is not None:
            pulumi.set(__self__, "commit_message_regex", commit_message_regex)
        if deny_delete_tag is not None:
            pulumi.set(__self__, "deny_delete_tag", deny_delete_tag)
        if file_name_regex is not None:
            pulumi.set(__self__, "file_name_regex", file_name_regex)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if member_check is not None:
            pulumi.set(__self__, "member_check", member_check)
        if prevent_secrets is not None:
            pulumi.set(__self__, "prevent_secrets", prevent_secrets)
        if reject_unsigned_commits is not None:
            pulumi.set(__self__, "reject_unsigned_commits", reject_unsigned_commits)

    @property
    @pulumi.getter(name="authorEmailRegex")
    def author_email_regex(self) -> Optional[str]:
        """
        All commit author emails must match this regex, e.g. `@my-company.com$`.
        """
        return pulumi.get(self, "author_email_regex")

    @property
    @pulumi.getter(name="branchNameRegex")
    def branch_name_regex(self) -> Optional[str]:
        """
        All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
        """
        return pulumi.get(self, "branch_name_regex")

    @property
    @pulumi.getter(name="commitCommitterCheck")
    def commit_committer_check(self) -> Optional[bool]:
        """
        Users can only push commits to this repository that were committed with one of their own verified emails.
        """
        return pulumi.get(self, "commit_committer_check")

    @property
    @pulumi.getter(name="commitMessageNegativeRegex")
    def commit_message_negative_regex(self) -> Optional[str]:
        """
        No commit message is allowed to match this regex, for example `ssh\:\/\/`.
        """
        return pulumi.get(self, "commit_message_negative_regex")

    @property
    @pulumi.getter(name="commitMessageRegex")
    def commit_message_regex(self) -> Optional[str]:
        """
        All commit messages must match this regex, e.g. `Fixed \d+\..*`.
        """
        return pulumi.get(self, "commit_message_regex")

    @property
    @pulumi.getter(name="denyDeleteTag")
    def deny_delete_tag(self) -> Optional[bool]:
        """
        Deny deleting a tag.
        """
        return pulumi.get(self, "deny_delete_tag")

    @property
    @pulumi.getter(name="fileNameRegex")
    def file_name_regex(self) -> Optional[str]:
        """
        All commited filenames must not match this regex, e.g. `(jar|exe)$`.
        """
        return pulumi.get(self, "file_name_regex")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[int]:
        """
        Maximum file size (MB).
        """
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="memberCheck")
    def member_check(self) -> Optional[bool]:
        """
        Restrict commits by author (email) to existing GitLab users.
        """
        return pulumi.get(self, "member_check")

    @property
    @pulumi.getter(name="preventSecrets")
    def prevent_secrets(self) -> Optional[bool]:
        """
        GitLab will reject any files that are likely to contain secrets.
        """
        return pulumi.get(self, "prevent_secrets")

    @property
    @pulumi.getter(name="rejectUnsignedCommits")
    def reject_unsigned_commits(self) -> Optional[bool]:
        """
        Reject commit when it’s not signed through GPG.
        """
        return pulumi.get(self, "reject_unsigned_commits")


@pulumi.output_type
class GetBranchCommitResult(dict):
    def __init__(__self__, *,
                 author_email: str,
                 author_name: str,
                 authored_date: str,
                 committed_date: str,
                 committer_email: str,
                 committer_name: str,
                 id: str,
                 message: str,
                 parent_ids: Sequence[str],
                 short_id: str,
                 title: str):
        """
        :param str id: The ID of this resource.
        """
        pulumi.set(__self__, "author_email", author_email)
        pulumi.set(__self__, "author_name", author_name)
        pulumi.set(__self__, "authored_date", authored_date)
        pulumi.set(__self__, "committed_date", committed_date)
        pulumi.set(__self__, "committer_email", committer_email)
        pulumi.set(__self__, "committer_name", committer_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "parent_ids", parent_ids)
        pulumi.set(__self__, "short_id", short_id)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> str:
        return pulumi.get(self, "author_email")

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> str:
        return pulumi.get(self, "author_name")

    @property
    @pulumi.getter(name="authoredDate")
    def authored_date(self) -> str:
        return pulumi.get(self, "authored_date")

    @property
    @pulumi.getter(name="committedDate")
    def committed_date(self) -> str:
        return pulumi.get(self, "committed_date")

    @property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> str:
        return pulumi.get(self, "committer_email")

    @property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> str:
        return pulumi.get(self, "committer_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="parentIds")
    def parent_ids(self) -> Sequence[str]:
        return pulumi.get(self, "parent_ids")

    @property
    @pulumi.getter(name="shortId")
    def short_id(self) -> str:
        return pulumi.get(self, "short_id")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")


@pulumi.output_type
class GetGroupMembershipMemberResult(dict):
    def __init__(__self__, *,
                 access_level: str,
                 avatar_url: str,
                 expires_at: str,
                 id: int,
                 name: str,
                 state: str,
                 username: str,
                 web_url: str):
        """
        :param str access_level: Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
        :param int id: The ID of this resource.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "web_url", web_url)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        return pulumi.get(self, "web_url")


@pulumi.output_type
class GetProjectProtectedBranchMergeAccessLevelResult(dict):
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: int,
                 user_id: int):
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        return pulumi.get(self, "access_level_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetProjectProtectedBranchPushAccessLevelResult(dict):
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: int,
                 user_id: int):
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        return pulumi.get(self, "access_level_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetProjectProtectedBranchesProtectedBranchResult(dict):
    def __init__(__self__, *,
                 allow_force_push: bool,
                 code_owner_approval_required: bool,
                 id: int,
                 merge_access_levels: Sequence['outputs.GetProjectProtectedBranchesProtectedBranchMergeAccessLevelResult'],
                 name: str,
                 push_access_levels: Sequence['outputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevelResult']):
        """
        :param int id: The ID of this resource.
        """
        pulumi.set(__self__, "allow_force_push", allow_force_push)
        pulumi.set(__self__, "code_owner_approval_required", code_owner_approval_required)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "merge_access_levels", merge_access_levels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "push_access_levels", push_access_levels)

    @property
    @pulumi.getter(name="allowForcePush")
    def allow_force_push(self) -> bool:
        return pulumi.get(self, "allow_force_push")

    @property
    @pulumi.getter(name="codeOwnerApprovalRequired")
    def code_owner_approval_required(self) -> bool:
        return pulumi.get(self, "code_owner_approval_required")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mergeAccessLevels")
    def merge_access_levels(self) -> Sequence['outputs.GetProjectProtectedBranchesProtectedBranchMergeAccessLevelResult']:
        return pulumi.get(self, "merge_access_levels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushAccessLevels")
    def push_access_levels(self) -> Sequence['outputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevelResult']:
        return pulumi.get(self, "push_access_levels")


@pulumi.output_type
class GetProjectProtectedBranchesProtectedBranchMergeAccessLevelResult(dict):
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: int,
                 user_id: int):
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        return pulumi.get(self, "access_level_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetProjectProtectedBranchesProtectedBranchPushAccessLevelResult(dict):
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: int,
                 user_id: int):
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        return pulumi.get(self, "access_level_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetProjectPushRulesResult(dict):
    def __init__(__self__, *,
                 author_email_regex: str,
                 branch_name_regex: str,
                 commit_committer_check: bool,
                 commit_message_negative_regex: str,
                 commit_message_regex: str,
                 deny_delete_tag: bool,
                 file_name_regex: str,
                 max_file_size: int,
                 member_check: bool,
                 prevent_secrets: bool,
                 reject_unsigned_commits: bool):
        pulumi.set(__self__, "author_email_regex", author_email_regex)
        pulumi.set(__self__, "branch_name_regex", branch_name_regex)
        pulumi.set(__self__, "commit_committer_check", commit_committer_check)
        pulumi.set(__self__, "commit_message_negative_regex", commit_message_negative_regex)
        pulumi.set(__self__, "commit_message_regex", commit_message_regex)
        pulumi.set(__self__, "deny_delete_tag", deny_delete_tag)
        pulumi.set(__self__, "file_name_regex", file_name_regex)
        pulumi.set(__self__, "max_file_size", max_file_size)
        pulumi.set(__self__, "member_check", member_check)
        pulumi.set(__self__, "prevent_secrets", prevent_secrets)
        pulumi.set(__self__, "reject_unsigned_commits", reject_unsigned_commits)

    @property
    @pulumi.getter(name="authorEmailRegex")
    def author_email_regex(self) -> str:
        return pulumi.get(self, "author_email_regex")

    @property
    @pulumi.getter(name="branchNameRegex")
    def branch_name_regex(self) -> str:
        return pulumi.get(self, "branch_name_regex")

    @property
    @pulumi.getter(name="commitCommitterCheck")
    def commit_committer_check(self) -> bool:
        return pulumi.get(self, "commit_committer_check")

    @property
    @pulumi.getter(name="commitMessageNegativeRegex")
    def commit_message_negative_regex(self) -> str:
        return pulumi.get(self, "commit_message_negative_regex")

    @property
    @pulumi.getter(name="commitMessageRegex")
    def commit_message_regex(self) -> str:
        return pulumi.get(self, "commit_message_regex")

    @property
    @pulumi.getter(name="denyDeleteTag")
    def deny_delete_tag(self) -> bool:
        return pulumi.get(self, "deny_delete_tag")

    @property
    @pulumi.getter(name="fileNameRegex")
    def file_name_regex(self) -> str:
        return pulumi.get(self, "file_name_regex")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> int:
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="memberCheck")
    def member_check(self) -> bool:
        return pulumi.get(self, "member_check")

    @property
    @pulumi.getter(name="preventSecrets")
    def prevent_secrets(self) -> bool:
        return pulumi.get(self, "prevent_secrets")

    @property
    @pulumi.getter(name="rejectUnsignedCommits")
    def reject_unsigned_commits(self) -> bool:
        return pulumi.get(self, "reject_unsigned_commits")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 _links: Mapping[str, str],
                 allow_merge_on_skipped_pipeline: bool,
                 approvals_before_merge: int,
                 archived: bool,
                 avatar_url: str,
                 build_coverage_regex: str,
                 ci_config_path: str,
                 ci_forward_deployment_enabled: bool,
                 container_registry_enabled: bool,
                 created_at: str,
                 creator_id: int,
                 custom_attributes: Sequence[Mapping[str, Any]],
                 default_branch: str,
                 description: str,
                 forked_from_project: 'outputs.GetProjectsProjectForkedFromProjectResult',
                 forks_count: int,
                 http_url_to_repo: str,
                 id: int,
                 import_error: str,
                 import_status: str,
                 issues_enabled: bool,
                 jobs_enabled: bool,
                 last_activity_at: str,
                 lfs_enabled: bool,
                 merge_method: str,
                 merge_pipelines_enabled: bool,
                 merge_requests_enabled: bool,
                 merge_trains_enabled: bool,
                 mirror: bool,
                 mirror_overwrites_diverged_branches: bool,
                 mirror_trigger_builds: bool,
                 mirror_user_id: int,
                 name: str,
                 name_with_namespace: str,
                 namespace: 'outputs.GetProjectsProjectNamespaceResult',
                 only_allow_merge_if_all_discussions_are_resolved: bool,
                 only_allow_merge_if_pipeline_succeeds: bool,
                 only_mirror_protected_branches: bool,
                 open_issues_count: int,
                 owner: 'outputs.GetProjectsProjectOwnerResult',
                 packages_enabled: bool,
                 path: str,
                 path_with_namespace: str,
                 permissions: 'outputs.GetProjectsProjectPermissionsResult',
                 public: bool,
                 public_builds: bool,
                 readme_url: str,
                 request_access_enabled: bool,
                 resolve_outdated_diff_discussions: bool,
                 runners_token: str,
                 shared_runners_enabled: bool,
                 shared_with_groups: Sequence['outputs.GetProjectsProjectSharedWithGroupResult'],
                 snippets_enabled: bool,
                 ssh_url_to_repo: str,
                 star_count: int,
                 statistics: Mapping[str, int],
                 tag_lists: Sequence[str],
                 visibility: str,
                 web_url: str,
                 wiki_enabled: bool):
        """
        :param bool archived: Limit by archived status.
        :param int id: The ID of this resource.
        :param Mapping[str, int] statistics: Include project statistics. Cannot be used with `group_id`.
        :param str visibility: Limit by visibility `public`, `internal`, or `private`.
        """
        pulumi.set(__self__, "_links", _links)
        pulumi.set(__self__, "allow_merge_on_skipped_pipeline", allow_merge_on_skipped_pipeline)
        pulumi.set(__self__, "approvals_before_merge", approvals_before_merge)
        pulumi.set(__self__, "archived", archived)
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "build_coverage_regex", build_coverage_regex)
        pulumi.set(__self__, "ci_config_path", ci_config_path)
        pulumi.set(__self__, "ci_forward_deployment_enabled", ci_forward_deployment_enabled)
        pulumi.set(__self__, "container_registry_enabled", container_registry_enabled)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "custom_attributes", custom_attributes)
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "forked_from_project", forked_from_project)
        pulumi.set(__self__, "forks_count", forks_count)
        pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "import_error", import_error)
        pulumi.set(__self__, "import_status", import_status)
        pulumi.set(__self__, "issues_enabled", issues_enabled)
        pulumi.set(__self__, "jobs_enabled", jobs_enabled)
        pulumi.set(__self__, "last_activity_at", last_activity_at)
        pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        pulumi.set(__self__, "merge_method", merge_method)
        pulumi.set(__self__, "merge_pipelines_enabled", merge_pipelines_enabled)
        pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        pulumi.set(__self__, "merge_trains_enabled", merge_trains_enabled)
        pulumi.set(__self__, "mirror", mirror)
        pulumi.set(__self__, "mirror_overwrites_diverged_branches", mirror_overwrites_diverged_branches)
        pulumi.set(__self__, "mirror_trigger_builds", mirror_trigger_builds)
        pulumi.set(__self__, "mirror_user_id", mirror_user_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_with_namespace", name_with_namespace)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "only_allow_merge_if_all_discussions_are_resolved", only_allow_merge_if_all_discussions_are_resolved)
        pulumi.set(__self__, "only_allow_merge_if_pipeline_succeeds", only_allow_merge_if_pipeline_succeeds)
        pulumi.set(__self__, "only_mirror_protected_branches", only_mirror_protected_branches)
        pulumi.set(__self__, "open_issues_count", open_issues_count)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "packages_enabled", packages_enabled)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "public", public)
        pulumi.set(__self__, "public_builds", public_builds)
        pulumi.set(__self__, "readme_url", readme_url)
        pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        pulumi.set(__self__, "runners_token", runners_token)
        pulumi.set(__self__, "shared_runners_enabled", shared_runners_enabled)
        pulumi.set(__self__, "shared_with_groups", shared_with_groups)
        pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        pulumi.set(__self__, "ssh_url_to_repo", ssh_url_to_repo)
        pulumi.set(__self__, "star_count", star_count)
        pulumi.set(__self__, "statistics", statistics)
        pulumi.set(__self__, "tag_lists", tag_lists)
        pulumi.set(__self__, "visibility", visibility)
        pulumi.set(__self__, "web_url", web_url)
        pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter
    def _links(self) -> Mapping[str, str]:
        return pulumi.get(self, "_links")

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> bool:
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> int:
        return pulumi.get(self, "approvals_before_merge")

    @property
    @pulumi.getter
    def archived(self) -> bool:
        """
        Limit by archived status.
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter(name="buildCoverageRegex")
    def build_coverage_regex(self) -> str:
        return pulumi.get(self, "build_coverage_regex")

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> str:
        return pulumi.get(self, "ci_config_path")

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> bool:
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    def container_registry_enabled(self) -> bool:
        return pulumi.get(self, "container_registry_enabled")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> int:
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Sequence[Mapping[str, Any]]:
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forkedFromProject")
    def forked_from_project(self) -> 'outputs.GetProjectsProjectForkedFromProjectResult':
        return pulumi.get(self, "forked_from_project")

    @property
    @pulumi.getter(name="forksCount")
    def forks_count(self) -> int:
        return pulumi.get(self, "forks_count")

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> str:
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importError")
    def import_error(self) -> str:
        return pulumi.get(self, "import_error")

    @property
    @pulumi.getter(name="importStatus")
    def import_status(self) -> str:
        return pulumi.get(self, "import_status")

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> bool:
        return pulumi.get(self, "issues_enabled")

    @property
    @pulumi.getter(name="jobsEnabled")
    def jobs_enabled(self) -> bool:
        return pulumi.get(self, "jobs_enabled")

    @property
    @pulumi.getter(name="lastActivityAt")
    def last_activity_at(self) -> str:
        return pulumi.get(self, "last_activity_at")

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> bool:
        return pulumi.get(self, "lfs_enabled")

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> str:
        return pulumi.get(self, "merge_method")

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> bool:
        return pulumi.get(self, "merge_pipelines_enabled")

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> bool:
        return pulumi.get(self, "merge_requests_enabled")

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> bool:
        return pulumi.get(self, "merge_trains_enabled")

    @property
    @pulumi.getter
    def mirror(self) -> bool:
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> bool:
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> bool:
        return pulumi.get(self, "mirror_trigger_builds")

    @property
    @pulumi.getter(name="mirrorUserId")
    def mirror_user_id(self) -> int:
        return pulumi.get(self, "mirror_user_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameWithNamespace")
    def name_with_namespace(self) -> str:
        return pulumi.get(self, "name_with_namespace")

    @property
    @pulumi.getter
    def namespace(self) -> 'outputs.GetProjectsProjectNamespaceResult':
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> bool:
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> bool:
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> bool:
        return pulumi.get(self, "only_mirror_protected_branches")

    @property
    @pulumi.getter(name="openIssuesCount")
    def open_issues_count(self) -> int:
        return pulumi.get(self, "open_issues_count")

    @property
    @pulumi.getter
    def owner(self) -> 'outputs.GetProjectsProjectOwnerResult':
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> bool:
        return pulumi.get(self, "packages_enabled")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> str:
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.GetProjectsProjectPermissionsResult':
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def public(self) -> bool:
        return pulumi.get(self, "public")

    @property
    @pulumi.getter(name="publicBuilds")
    def public_builds(self) -> bool:
        return pulumi.get(self, "public_builds")

    @property
    @pulumi.getter(name="readmeUrl")
    def readme_url(self) -> str:
        return pulumi.get(self, "readme_url")

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> bool:
        return pulumi.get(self, "request_access_enabled")

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> bool:
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> str:
        return pulumi.get(self, "runners_token")

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> bool:
        return pulumi.get(self, "shared_runners_enabled")

    @property
    @pulumi.getter(name="sharedWithGroups")
    def shared_with_groups(self) -> Sequence['outputs.GetProjectsProjectSharedWithGroupResult']:
        return pulumi.get(self, "shared_with_groups")

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> bool:
        return pulumi.get(self, "snippets_enabled")

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> str:
        return pulumi.get(self, "ssh_url_to_repo")

    @property
    @pulumi.getter(name="starCount")
    def star_count(self) -> int:
        return pulumi.get(self, "star_count")

    @property
    @pulumi.getter
    def statistics(self) -> Mapping[str, int]:
        """
        Include project statistics. Cannot be used with `group_id`.
        """
        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Sequence[str]:
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter
    def visibility(self) -> str:
        """
        Limit by visibility `public`, `internal`, or `private`.
        """
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> bool:
        return pulumi.get(self, "wiki_enabled")


@pulumi.output_type
class GetProjectsProjectForkedFromProjectResult(dict):
    def __init__(__self__, *,
                 http_url_to_repo: str,
                 id: int,
                 name: str,
                 name_with_namespace: str,
                 path: str,
                 path_with_namespace: str,
                 web_url: str):
        """
        :param int id: The ID of this resource.
        """
        pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_with_namespace", name_with_namespace)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        pulumi.set(__self__, "web_url", web_url)

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> str:
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameWithNamespace")
    def name_with_namespace(self) -> str:
        return pulumi.get(self, "name_with_namespace")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> str:
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        return pulumi.get(self, "web_url")


@pulumi.output_type
class GetProjectsProjectNamespaceResult(dict):
    def __init__(__self__, *,
                 full_path: str,
                 id: int,
                 kind: str,
                 name: str,
                 path: str):
        """
        :param int id: The ID of this resource.
        """
        pulumi.set(__self__, "full_path", full_path)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> str:
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")


@pulumi.output_type
class GetProjectsProjectOwnerResult(dict):
    def __init__(__self__, *,
                 avatar_url: str,
                 id: int,
                 name: str,
                 state: str,
                 username: str,
                 website_url: str):
        """
        :param int id: The ID of this resource.
        """
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "website_url", website_url)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> str:
        return pulumi.get(self, "website_url")


@pulumi.output_type
class GetProjectsProjectPermissionsResult(dict):
    def __init__(__self__, *,
                 group_access: Mapping[str, int],
                 project_access: Mapping[str, int]):
        pulumi.set(__self__, "group_access", group_access)
        pulumi.set(__self__, "project_access", project_access)

    @property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> Mapping[str, int]:
        return pulumi.get(self, "group_access")

    @property
    @pulumi.getter(name="projectAccess")
    def project_access(self) -> Mapping[str, int]:
        return pulumi.get(self, "project_access")


@pulumi.output_type
class GetProjectsProjectSharedWithGroupResult(dict):
    def __init__(__self__, *,
                 group_access_level: str,
                 group_id: int,
                 group_name: str):
        """
        :param int group_id: The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
        """
        pulumi.set(__self__, "group_access_level", group_access_level)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupAccessLevel")
    def group_access_level(self) -> str:
        return pulumi.get(self, "group_access_level")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        """
        The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 avatar_url: str,
                 bio: str,
                 can_create_group: bool,
                 can_create_project: bool,
                 color_scheme_id: int,
                 created_at: str,
                 current_sign_in_at: str,
                 email: str,
                 extern_uid: str,
                 external: bool,
                 id: int,
                 is_admin: bool,
                 last_sign_in_at: str,
                 linkedin: str,
                 location: str,
                 name: str,
                 organization: str,
                 projects_limit: int,
                 provider: str,
                 skype: str,
                 state: str,
                 theme_id: int,
                 twitter: str,
                 two_factor_enabled: bool,
                 username: str,
                 website_url: str):
        """
        :param str extern_uid: Lookup users by external UID. (Requires administrator privileges)
        :param int id: The ID of this resource.
        """
        pulumi.set(__self__, "avatar_url", avatar_url)
        pulumi.set(__self__, "bio", bio)
        pulumi.set(__self__, "can_create_group", can_create_group)
        pulumi.set(__self__, "can_create_project", can_create_project)
        pulumi.set(__self__, "color_scheme_id", color_scheme_id)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "current_sign_in_at", current_sign_in_at)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "extern_uid", extern_uid)
        pulumi.set(__self__, "external", external)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "last_sign_in_at", last_sign_in_at)
        pulumi.set(__self__, "linkedin", linkedin)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "projects_limit", projects_limit)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "skype", skype)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "theme_id", theme_id)
        pulumi.set(__self__, "twitter", twitter)
        pulumi.set(__self__, "two_factor_enabled", two_factor_enabled)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "website_url", website_url)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> str:
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter
    def bio(self) -> str:
        return pulumi.get(self, "bio")

    @property
    @pulumi.getter(name="canCreateGroup")
    def can_create_group(self) -> bool:
        return pulumi.get(self, "can_create_group")

    @property
    @pulumi.getter(name="canCreateProject")
    def can_create_project(self) -> bool:
        return pulumi.get(self, "can_create_project")

    @property
    @pulumi.getter(name="colorSchemeId")
    def color_scheme_id(self) -> int:
        return pulumi.get(self, "color_scheme_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentSignInAt")
    def current_sign_in_at(self) -> str:
        return pulumi.get(self, "current_sign_in_at")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="externUid")
    def extern_uid(self) -> str:
        """
        Lookup users by external UID. (Requires administrator privileges)
        """
        return pulumi.get(self, "extern_uid")

    @property
    @pulumi.getter
    def external(self) -> bool:
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter(name="lastSignInAt")
    def last_sign_in_at(self) -> str:
        return pulumi.get(self, "last_sign_in_at")

    @property
    @pulumi.getter
    def linkedin(self) -> str:
        return pulumi.get(self, "linkedin")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> str:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="projectsLimit")
    def projects_limit(self) -> int:
        return pulumi.get(self, "projects_limit")

    @property
    @pulumi.getter
    def provider(self) -> str:
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def skype(self) -> str:
        return pulumi.get(self, "skype")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> int:
        return pulumi.get(self, "theme_id")

    @property
    @pulumi.getter
    def twitter(self) -> str:
        return pulumi.get(self, "twitter")

    @property
    @pulumi.getter(name="twoFactorEnabled")
    def two_factor_enabled(self) -> bool:
        return pulumi.get(self, "two_factor_enabled")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> str:
        return pulumi.get(self, "website_url")


