"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackendServerToVServerGroupAddition = exports.BackendServerToVServerGroupAdditionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "BackendServerToVServerGroupAdditionProperty", { enumerable: true, get: function () { return slb_generated_1.RosBackendServerToVServerGroupAddition; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::BackendServerToVServerGroupAddition`
 */
class BackendServerToVServerGroupAddition extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::BackendServerToVServerGroupAddition`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosBackendServerToVServerGroupAddition = new slb_generated_1.RosBackendServerToVServerGroupAddition(this, id, {
            vServerGroupId: props.vServerGroupId,
            backendServers: props.backendServers,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBackendServerToVServerGroupAddition;
        this.attrVServerGroupId = rosBackendServerToVServerGroupAddition.attrVServerGroupId;
    }
}
exports.BackendServerToVServerGroupAddition = BackendServerToVServerGroupAddition;
//# sourceMappingURL=data:application/json;base64,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