"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "LoadBalancerProperty", { enumerable: true, get: function () { return slb_generated_1.RosLoadBalancer; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::LoadBalancer`
 */
class LoadBalancer extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::LoadBalancer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLoadBalancer = new slb_generated_1.RosLoadBalancer(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            resourceGroupId: props.resourceGroupId,
            pricingCycle: props.pricingCycle,
            addressIpVersion: props.addressIpVersion,
            vSwitchId: props.vSwitchId,
            autoRenew: props.autoRenew,
            duration: props.duration,
            deletionProtection: props.deletionProtection === undefined || props.deletionProtection === null ? false : props.deletionProtection,
            payType: props.payType,
            autoPay: props.autoPay === undefined || props.autoPay === null ? false : props.autoPay,
            slaveZoneId: props.slaveZoneId,
            modificationProtectionStatus: props.modificationProtectionStatus,
            internetChargeType: props.internetChargeType === undefined || props.internetChargeType === null ? 'paybytraffic' : props.internetChargeType,
            loadBalancerSpec: props.loadBalancerSpec,
            loadBalancerName: props.loadBalancerName,
            vpcId: props.vpcId,
            bandwidth: props.bandwidth === undefined || props.bandwidth === null ? 1 : props.bandwidth,
            modificationProtectionReason: props.modificationProtectionReason,
            addressType: props.addressType === undefined || props.addressType === null ? 'internet' : props.addressType,
            tags: props.tags,
            masterZoneId: props.masterZoneId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLoadBalancer;
        this.attrAddressIpVersion = rosLoadBalancer.attrAddressIpVersion;
        this.attrAddressType = rosLoadBalancer.attrAddressType;
        this.attrBandwidth = rosLoadBalancer.attrBandwidth;
        this.attrIpAddress = rosLoadBalancer.attrIpAddress;
        this.attrLoadBalancerId = rosLoadBalancer.attrLoadBalancerId;
        this.attrLoadBalancerName = rosLoadBalancer.attrLoadBalancerName;
        this.attrLoadBalancerSpec = rosLoadBalancer.attrLoadBalancerSpec;
        this.attrMasterZoneId = rosLoadBalancer.attrMasterZoneId;
        this.attrNetworkType = rosLoadBalancer.attrNetworkType;
        this.attrOrderId = rosLoadBalancer.attrOrderId;
        this.attrPayType = rosLoadBalancer.attrPayType;
        this.attrResourceGroupId = rosLoadBalancer.attrResourceGroupId;
        this.attrSlaveZoneId = rosLoadBalancer.attrSlaveZoneId;
        this.attrVSwitchId = rosLoadBalancer.attrVSwitchId;
        this.attrVpcId = rosLoadBalancer.attrVpcId;
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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