from cratedb_mcp.knowledge import DocumentationIndex, Queries


def test_documentation_index():
    documentation_index = DocumentationIndex()
    titles = [item["title"] for item in documentation_index.items()]
    assert len(titles) >= 50
    assert "CrateDB database" in titles
    assert "CrateDB features" in titles
    assert "CrateDB SQL reference: Scalar functions" in titles
    assert "Guide: CrateDB query optimization" in titles


def test_queries():
    # Verify basic parts of the query.
    assert "information_schema.tables" in Queries.TABLES_METADATA

    # Verify other critical parts of the query.
    assert "sys.health" in Queries.TABLES_METADATA
    assert "WITH partitions_health" in Queries.TABLES_METADATA
    assert "LEFT JOIN" in Queries.TABLES_METADATA
