"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const route53_generated_1 = require("../route53.generated");
const _util_1 = require("./_util");
/**
 * A record to delegate further lookups to a different set of name servers
 */
class ZoneDelegationRecord extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const ttl = props.ttl === undefined ? 172800 : props.ttl;
        const resourceRecords = cdk.unresolved(props.nameServers)
            ? props.nameServers // Can't map a string-array token!
            : props.nameServers.map(ns => (cdk.unresolved(ns) || ns.endsWith('.')) ? ns : `${ns}.`);
        new route53_generated_1.CfnRecordSet(this, 'Resource', {
            hostedZoneId: props.zone.hostedZoneId,
            name: _util_1.determineFullyQualifiedDomainName(props.delegatedZoneName, props.zone),
            type: 'NS',
            ttl: ttl.toString(),
            comment: props.comment,
            resourceRecords,
        });
    }
}
exports.ZoneDelegationRecord = ZoneDelegationRecord;
//# sourceMappingURL=data:application/json;base64,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