"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-route53-integ');
const vpc = new ec2.VpcNetwork(stack, 'VPC');
const privateZone = new lib_1.PrivateHostedZone(stack, 'PrivateZone', {
    zoneName: 'cdk.local', vpc
});
const publicZone = new lib_1.PublicHostedZone(stack, 'PublicZone', {
    zoneName: 'cdk.test'
});
const publicSubZone = new lib_1.PublicHostedZone(stack, 'PublicSubZone', {
    zoneName: 'sub.cdk.test'
});
publicZone.addDelegation(publicSubZone);
new lib_1.TxtRecord(privateZone, 'TXT', {
    zone: privateZone,
    recordName: '_foo',
    recordValue: 'Bar!',
    ttl: 60
});
new lib_1.CnameRecord(stack, 'CNAME', {
    zone: privateZone,
    recordName: 'www',
    recordValue: 'server'
});
new cdk.CfnOutput(stack, 'PrivateZoneId', { value: privateZone.hostedZoneId });
new cdk.CfnOutput(stack, 'PublicZoneId', { value: publicZone.hostedZoneId });
app.run();
//# sourceMappingURL=data:application/json;base64,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