"use strict";
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'Hosted Zone Provider': {
        'HostedZoneProvider will return context values if availble'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', { env: { account: '12345', region: 'us-east-1' } });
            const filter = { domainName: 'test.com' };
            new lib_1.HostedZoneProvider(stack, filter).findHostedZone();
            const key = Object.keys(stack.missingContext)[0];
            const fakeZone = {
                Id: "/hostedzone/11111111111111",
                Name: "example.com.",
                CallerReference: "TestLates-PublicZo-OESZPDFV7G6A",
                Config: {
                    Comment: "CDK created",
                    PrivateZone: false
                },
                ResourceRecordSetCount: 3
            };
            stack.node.setContext(key, fakeZone);
            const cdkZoneProps = {
                hostedZoneId: fakeZone.Id,
                zoneName: 'example.com',
            };
            const cdkZone = lib_1.HostedZone.import(stack, 'MyZone', cdkZoneProps);
            // WHEN
            const provider = new lib_1.HostedZoneProvider(stack, filter);
            const zoneProps = stack.node.resolve(provider.findHostedZone());
            const zoneRef = provider.findAndImport(stack, 'MyZoneProvider');
            // THEN
            test.deepEqual(zoneProps, cdkZoneProps);
            test.deepEqual(zoneRef.hostedZoneId, cdkZone.hostedZoneId);
            test.done();
        },
    }
};
//# sourceMappingURL=data:application/json;base64,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