"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class TestApp {
    constructor() {
        this.app = new cdk_1.App();
        const account = '123456789012';
        const region = 'bermuda-triangle';
        this.app.node.setContext(`availability-zones:${account}:${region}`, [`${region}-1a`]);
        this.stack = new cdk_1.Stack(this.app, 'MyStack', { env: { account, region } });
    }
    synthesizeTemplate() {
        return this.app.synthesizeStack(this.stack.name);
    }
}
module.exports = {
    'TXT records': {
        TXT(test) {
            const app = new TestApp();
            const zone = new lib_1.PublicHostedZone(app.stack, 'HostedZone', { zoneName: 'test.public' });
            new lib_1.TxtRecord(zone, 'TXT', { zone, recordName: '_foo', recordValue: 'Bar!' });
            assert_1.expect(app.synthesizeTemplate()).to(assert_1.exactlyMatchTemplate({
                Resources: {
                    HostedZoneDB99F866: {
                        Type: 'AWS::Route53::HostedZone',
                        Properties: {
                            Name: 'test.public.'
                        }
                    },
                    HostedZoneTXT69C29760: {
                        Type: 'AWS::Route53::RecordSet',
                        Properties: {
                            HostedZoneId: {
                                Ref: 'HostedZoneDB99F866'
                            },
                            Name: '_foo.test.public.',
                            ResourceRecords: ['"Bar!"'],
                            Type: 'TXT',
                            TTL: '1800'
                        }
                    }
                }
            }));
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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