"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPolicy = exports.CfnNotificationChannel = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-12-23T19:03:32.616Z","fingerprint":"22VUdf/p33hwKVMiRgrV1j2R1PIOYn2a8EO2KvZU6lM="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnNotificationChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnNotificationChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.requiredValidator)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.validateString)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnNotificationChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource.
 */
// @ts-ignore TS6133
function cfnNotificationChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotificationChannelPropsValidator(properties).assertSuccess();
    return {
        SnsRoleName: cdk.stringToCloudFormation(properties.snsRoleName),
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnNotificationChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsRoleName', 'SnsRoleName', cfn_parse.FromCloudFormation.getString(properties.SnsRoleName));
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`
 *
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic to use to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *AWS Firewall Manager Developer Guide* .
 *
 * @cloudformationResource AWS::FMS::NotificationChannel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 */
class CfnNotificationChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fms_CfnNotificationChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotificationChannel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsRoleName', this);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsRoleName = props.snsRoleName;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotificationChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotificationChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsRoleName: this.snsRoleName,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnNotificationChannelPropsToCloudFormation(props);
    }
}
exports.CfnNotificationChannel = CfnNotificationChannel;
_a = JSII_RTTI_SYMBOL_1;
CfnNotificationChannel[_a] = { fqn: "@aws-cdk/aws-fms.CfnNotificationChannel", version: "1.184.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteAllPolicyResources', cdk.validateBoolean)(properties.deleteAllPolicyResources));
    errors.collect(cdk.propertyValidator('excludeMap', CfnPolicy_IEMapPropertyValidator)(properties.excludeMap));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.requiredValidator)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.validateBoolean)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('includeMap', CfnPolicy_IEMapPropertyValidator)(properties.includeMap));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.requiredValidator)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.validateBoolean)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnPolicy_ResourceTagPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.requiredValidator)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourcesCleanUp', cdk.validateBoolean)(properties.resourcesCleanUp));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.requiredValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', CfnPolicy_SecurityServicePolicyDataPropertyValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnPolicy_PolicyTagPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        ExcludeResourceTags: cdk.booleanToCloudFormation(properties.excludeResourceTags),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        RemediationEnabled: cdk.booleanToCloudFormation(properties.remediationEnabled),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        SecurityServicePolicyData: cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties.securityServicePolicyData),
        DeleteAllPolicyResources: cdk.booleanToCloudFormation(properties.deleteAllPolicyResources),
        ExcludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.excludeMap),
        IncludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.includeMap),
        ResourcesCleanUp: cdk.booleanToCloudFormation(properties.resourcesCleanUp),
        ResourceTags: cdk.listMapper(cfnPolicyResourceTagPropertyToCloudFormation)(properties.resourceTags),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Tags: cdk.listMapper(cfnPolicyPolicyTagPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('excludeResourceTags', 'ExcludeResourceTags', cfn_parse.FromCloudFormation.getBoolean(properties.ExcludeResourceTags));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('remediationEnabled', 'RemediationEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.RemediationEnabled));
    ret.addPropertyResult('resourceType', 'ResourceType', cfn_parse.FromCloudFormation.getString(properties.ResourceType));
    ret.addPropertyResult('securityServicePolicyData', 'SecurityServicePolicyData', CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties.SecurityServicePolicyData));
    ret.addPropertyResult('deleteAllPolicyResources', 'DeleteAllPolicyResources', properties.DeleteAllPolicyResources != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAllPolicyResources) : undefined);
    ret.addPropertyResult('excludeMap', 'ExcludeMap', properties.ExcludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.ExcludeMap) : undefined);
    ret.addPropertyResult('includeMap', 'IncludeMap', properties.IncludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.IncludeMap) : undefined);
    ret.addPropertyResult('resourcesCleanUp', 'ResourcesCleanUp', properties.ResourcesCleanUp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ResourcesCleanUp) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyResourceTagPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', properties.ResourceTypeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyPolicyTagPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::Policy`
 *
 * An AWS Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 *
 * - An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * - An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.
 * - An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .
 * - A security group policy, which manages VPC security groups across your AWS organization.
 * - An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * - A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under [AWS Firewall Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html) .
 *
 * @cloudformationResource AWS::FMS::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fms_CfnPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'excludeResourceTags', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'remediationEnabled', this);
        cdk.requireProperty(props, 'resourceType', this);
        cdk.requireProperty(props, 'securityServicePolicyData', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.excludeResourceTags = props.excludeResourceTags;
        this.policyName = props.policyName;
        this.remediationEnabled = props.remediationEnabled;
        this.resourceType = props.resourceType;
        this.securityServicePolicyData = props.securityServicePolicyData;
        this.deleteAllPolicyResources = props.deleteAllPolicyResources;
        this.excludeMap = props.excludeMap;
        this.includeMap = props.includeMap;
        this.resourcesCleanUp = props.resourcesCleanUp;
        this.resourceTags = props.resourceTags;
        this.resourceTypeList = props.resourceTypeList;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            excludeResourceTags: this.excludeResourceTags,
            policyName: this.policyName,
            remediationEnabled: this.remediationEnabled,
            resourceType: this.resourceType,
            securityServicePolicyData: this.securityServicePolicyData,
            deleteAllPolicyResources: this.deleteAllPolicyResources,
            excludeMap: this.excludeMap,
            includeMap: this.includeMap,
            resourcesCleanUp: this.resourcesCleanUp,
            resourceTags: this.resourceTags,
            resourceTypeList: this.resourceTypeList,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
exports.CfnPolicy = CfnPolicy;
_b = JSII_RTTI_SYMBOL_1;
CfnPolicy[_b] = { fqn: "@aws-cdk/aws-fms.CfnPolicy", version: "1.184.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
/**
 * Determine whether the given properties match those of a `IEMapProperty`
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_IEMapPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('account', cdk.listValidator(cdk.validateString))(properties.account));
    errors.collect(cdk.propertyValidator('orgunit', cdk.listValidator(cdk.validateString))(properties.orgunit));
    return errors.wrap('supplied properties not correct for "IEMapProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource.
 */
// @ts-ignore TS6133
function cfnPolicyIEMapPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_IEMapPropertyValidator(properties).assertSuccess();
    return {
        ACCOUNT: cdk.listMapper(cdk.stringToCloudFormation)(properties.account),
        ORGUNIT: cdk.listMapper(cdk.stringToCloudFormation)(properties.orgunit),
    };
}
// @ts-ignore TS6133
function CfnPolicyIEMapPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('account', 'ACCOUNT', properties.ACCOUNT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ACCOUNT) : undefined);
    ret.addPropertyResult('orgunit', 'ORGUNIT', properties.ORGUNIT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ORGUNIT) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "NetworkFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('networkFirewallPolicy', CfnPolicy_NetworkFirewallPolicyPropertyValidator)(properties.networkFirewallPolicy));
    errors.collect(cdk.propertyValidator('thirdPartyFirewallPolicy', CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator)(properties.thirdPartyFirewallPolicy));
    return errors.wrap('supplied properties not correct for "PolicyOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyOptionPropertyValidator(properties).assertSuccess();
    return {
        NetworkFirewallPolicy: cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties.networkFirewallPolicy),
        ThirdPartyFirewallPolicy: cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties.thirdPartyFirewallPolicy),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('networkFirewallPolicy', 'NetworkFirewallPolicy', properties.NetworkFirewallPolicy != null ? CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties.NetworkFirewallPolicy) : undefined);
    ret.addPropertyResult('thirdPartyFirewallPolicy', 'ThirdPartyFirewallPolicy', properties.ThirdPartyFirewallPolicy != null ? CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties.ThirdPartyFirewallPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyTagProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "PolicyTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceTagProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ResourceTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyResourceTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ResourceTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyResourceTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SecurityServicePolicyDataProperty`
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('managedServiceData', cdk.validateString)(properties.managedServiceData));
    errors.collect(cdk.propertyValidator('policyOption', CfnPolicy_PolicyOptionPropertyValidator)(properties.policyOption));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "SecurityServicePolicyDataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource.
 */
// @ts-ignore TS6133
function cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties).assertSuccess();
    return {
        ManagedServiceData: cdk.stringToCloudFormation(properties.managedServiceData),
        PolicyOption: cfnPolicyPolicyOptionPropertyToCloudFormation(properties.policyOption),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('managedServiceData', 'ManagedServiceData', properties.ManagedServiceData != null ? cfn_parse.FromCloudFormation.getString(properties.ManagedServiceData) : undefined);
    ret.addPropertyResult('policyOption', 'PolicyOption', properties.PolicyOption != null ? CfnPolicyPolicyOptionPropertyFromCloudFormation(properties.PolicyOption) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ThirdPartyFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "ThirdPartyFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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