"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const core_1 = require("@aws-cdk/core");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
const util_1 = require("./util");
/**
 * Base class for listeners
 */
class BaseListener extends core_1.Resource {
    constructor(scope, id, additionalProps) {
        super(scope, id);
        const resource = new elasticloadbalancingv2_generated_1.CfnListener(this, 'Resource', {
            ...additionalProps,
            defaultActions: core_1.Lazy.any({ produce: () => { var _b, _c; return (_c = (_b = this.defaultAction) === null || _b === void 0 ? void 0 : _b.renderActions()) !== null && _c !== void 0 ? _c : []; } }),
        });
        this.listenerArn = resource.ref;
    }
    /**
     * Queries the load balancer listener context provider for load balancer
     * listener info.
     * @internal
     */
    static _queryContextProvider(scope, options) {
        var _b;
        if (core_1.Token.isUnresolved(options.userOptions.loadBalancerArn)
            || Object.values((_b = options.userOptions.loadBalancerTags) !== null && _b !== void 0 ? _b : {}).some(core_1.Token.isUnresolved)
            || core_1.Token.isUnresolved(options.userOptions.listenerPort)) {
            throw new Error('All arguments to look up a load balancer listener must be concrete (no Tokens)');
        }
        let cxschemaTags;
        if (options.userOptions.loadBalancerTags) {
            cxschemaTags = util_1.mapTagMapToCxschema(options.userOptions.loadBalancerTags);
        }
        const props = core_1.ContextProvider.getValue(scope, {
            provider: cxschema.ContextProvider.LOAD_BALANCER_LISTENER_PROVIDER,
            props: {
                listenerArn: options.listenerArn,
                listenerPort: options.userOptions.listenerPort,
                listenerProtocol: options.listenerProtocol,
                loadBalancerArn: options.userOptions.loadBalancerArn,
                loadBalancerTags: cxschemaTags,
                loadBalancerType: options.loadBalancerType,
            },
            dummyValue: {
                listenerArn: `arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/${options.loadBalancerType}/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2`,
                listenerPort: 80,
                securityGroupIds: ['sg-123456789012'],
            },
        }).value;
        return props;
    }
    /**
     * Validate this listener
     */
    validate() {
        if (!this.defaultAction) {
            return ['Listener needs at least one default action or target group (call addTargetGroups or addAction)'];
        }
        return [];
    }
    /**
     * Configure the default action
     *
     * @internal
     */
    _setDefaultAction(action) {
        // It might make sense to 'throw' here.
        //
        // However, programs may already exist out there which configured an action twice,
        // in which case the second action accidentally overwrite the initial action, and in some
        // way ended up with a program that did what the author intended. If we were to add throw now,
        // the previously working program would be broken.
        //
        // Instead, signal this through a warning.
        // @deprecate: upon the next major version bump, replace this with a `throw`
        if (this.defaultAction) {
            core_1.Annotations.of(this).addWarning('A default Action already existed on this Listener and was replaced. Configure exactly one default Action.');
        }
        this.defaultAction = action;
    }
}
exports.BaseListener = BaseListener;
_a = JSII_RTTI_SYMBOL_1;
BaseListener[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2.BaseListener", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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