from setuptools import find_packages, setup

setup(
    name='brewblox-history',
    use_scm_version={'local_scheme': lambda v: ''},
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    url='https://github.com/BrewBlox/brewblox-history',
    author='BrewPi',
    author_email='development@brewpi.com',
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 3.8',
        'Intended Audience :: End Users/Desktop',
        'Topic :: System :: Hardware',
    ],
    keywords='brewing brewpi brewblox embedded plugin service',
    packages=find_packages(exclude=['test']),
    install_requires=[
        'brewblox-service',
        'aioinflux',
        'dpath',
        'aiohttp-sse',
        'python-dateutil',
    ],
    python_requires='>=3.8',
    setup_requires=['setuptools_scm'],
)
