from abc import ABCMeta, abstractmethod


class Strategy(object):
    '''
    Abstract base class providing interface for all subsequent strategy handling objects.

    Goal of Strategy object is to generate Signal objects for particular tickers/symbols based on inputs of data/bars generated by a DataHandler object

    This is designed to work with both historic and live data as Strategy is agnostic to where the data come from, since it obtains the bar tuples from a queue object
    '''
    __metaclass__ = ABCMeta

    @abstractmethod
    def calculate_signals(self):
        raise NotImplementedError('Should implement calculate_signals()')