# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.5
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.algorithm import Algorithm  # noqa: F401,E501
from akeyless_uam_api.models.azure_ad_access_role import AzureADAccessRole  # noqa: F401,E501
from akeyless_uam_api.models.okta_access_role import OktaAccessRole  # noqa: F401,E501


class PolicyRules(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alg': 'Algorithm',
        'azure_ad_access_role': 'AzureADAccessRole',
        'cidr_whitelist': 'str',
        'key': 'str',
        'okta_access_role': 'OktaAccessRole'
    }

    attribute_map = {
        'alg': 'alg',
        'azure_ad_access_role': 'azure_ad_access_role',
        'cidr_whitelist': 'cidr_whitelist',
        'key': 'key',
        'okta_access_role': 'okta_access_role'
    }

    def __init__(self, alg=None, azure_ad_access_role=None, cidr_whitelist=None, key=None, okta_access_role=None):  # noqa: E501
        """PolicyRules - a model defined in Swagger"""  # noqa: E501

        self._alg = None
        self._azure_ad_access_role = None
        self._cidr_whitelist = None
        self._key = None
        self._okta_access_role = None
        self.discriminator = None

        if alg is not None:
            self.alg = alg
        if azure_ad_access_role is not None:
            self.azure_ad_access_role = azure_ad_access_role
        if cidr_whitelist is not None:
            self.cidr_whitelist = cidr_whitelist
        if key is not None:
            self.key = key
        if okta_access_role is not None:
            self.okta_access_role = okta_access_role

    @property
    def alg(self):
        """Gets the alg of this PolicyRules.  # noqa: E501


        :return: The alg of this PolicyRules.  # noqa: E501
        :rtype: Algorithm
        """
        return self._alg

    @alg.setter
    def alg(self, alg):
        """Sets the alg of this PolicyRules.


        :param alg: The alg of this PolicyRules.  # noqa: E501
        :type: Algorithm
        """

        self._alg = alg

    @property
    def azure_ad_access_role(self):
        """Gets the azure_ad_access_role of this PolicyRules.  # noqa: E501


        :return: The azure_ad_access_role of this PolicyRules.  # noqa: E501
        :rtype: AzureADAccessRole
        """
        return self._azure_ad_access_role

    @azure_ad_access_role.setter
    def azure_ad_access_role(self, azure_ad_access_role):
        """Sets the azure_ad_access_role of this PolicyRules.


        :param azure_ad_access_role: The azure_ad_access_role of this PolicyRules.  # noqa: E501
        :type: AzureADAccessRole
        """

        self._azure_ad_access_role = azure_ad_access_role

    @property
    def cidr_whitelist(self):
        """Gets the cidr_whitelist of this PolicyRules.  # noqa: E501

        CIDR Whitelisting. Only requests from the ip addresses that match the CIDR list will be able to obtain temporary access credentials. The format of the CIDR list is a comma-separated list of valid CIDRs.The list length is limited to 10 CIDRs. In the case of an empty string there will be no restriction of IP addresses.  # noqa: E501

        :return: The cidr_whitelist of this PolicyRules.  # noqa: E501
        :rtype: str
        """
        return self._cidr_whitelist

    @cidr_whitelist.setter
    def cidr_whitelist(self, cidr_whitelist):
        """Sets the cidr_whitelist of this PolicyRules.

        CIDR Whitelisting. Only requests from the ip addresses that match the CIDR list will be able to obtain temporary access credentials. The format of the CIDR list is a comma-separated list of valid CIDRs.The list length is limited to 10 CIDRs. In the case of an empty string there will be no restriction of IP addresses.  # noqa: E501

        :param cidr_whitelist: The cidr_whitelist of this PolicyRules.  # noqa: E501
        :type: str
        """

        self._cidr_whitelist = cidr_whitelist

    @property
    def key(self):
        """Gets the key of this PolicyRules.  # noqa: E501

        The public key value of the API-key. This is a mandatory parameter for API key policy.  # noqa: E501

        :return: The key of this PolicyRules.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this PolicyRules.

        The public key value of the API-key. This is a mandatory parameter for API key policy.  # noqa: E501

        :param key: The key of this PolicyRules.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def okta_access_role(self):
        """Gets the okta_access_role of this PolicyRules.  # noqa: E501


        :return: The okta_access_role of this PolicyRules.  # noqa: E501
        :rtype: OktaAccessRole
        """
        return self._okta_access_role

    @okta_access_role.setter
    def okta_access_role(self, okta_access_role):
        """Sets the okta_access_role of this PolicyRules.


        :param okta_access_role: The okta_access_role of this PolicyRules.  # noqa: E501
        :type: OktaAccessRole
        """

        self._okta_access_role = okta_access_role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PolicyRules):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
