# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 1.0.5
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.algorithm import Algorithm  # noqa: F401,E501
from akeyless_uam_api.models.azure_ad_access_role import AzureADAccessRole  # noqa: F401,E501


class UserAccessPolicyInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_expires': 'int',
        'api_key_alg': 'Algorithm',
        'azure_ad_access_role': 'AzureADAccessRole',
        'cidr_whitelist': 'str',
        'rules_type': 'str'
    }

    attribute_map = {
        'access_expires': 'access_expires',
        'api_key_alg': 'api_key_alg',
        'azure_ad_access_role': 'azure_ad_access_role',
        'cidr_whitelist': 'cidr_whitelist',
        'rules_type': 'rules_type'
    }

    def __init__(self, access_expires=None, api_key_alg=None, azure_ad_access_role=None, cidr_whitelist=None, rules_type=None):  # noqa: E501
        """UserAccessPolicyInfo - a model defined in Swagger"""  # noqa: E501

        self._access_expires = None
        self._api_key_alg = None
        self._azure_ad_access_role = None
        self._cidr_whitelist = None
        self._rules_type = None
        self.discriminator = None

        if access_expires is not None:
            self.access_expires = access_expires
        if api_key_alg is not None:
            self.api_key_alg = api_key_alg
        if azure_ad_access_role is not None:
            self.azure_ad_access_role = azure_ad_access_role
        if cidr_whitelist is not None:
            self.cidr_whitelist = cidr_whitelist
        if rules_type is not None:
            self.rules_type = rules_type

    @property
    def access_expires(self):
        """Gets the access_expires of this UserAccessPolicyInfo.  # noqa: E501


        :return: The access_expires of this UserAccessPolicyInfo.  # noqa: E501
        :rtype: int
        """
        return self._access_expires

    @access_expires.setter
    def access_expires(self, access_expires):
        """Sets the access_expires of this UserAccessPolicyInfo.


        :param access_expires: The access_expires of this UserAccessPolicyInfo.  # noqa: E501
        :type: int
        """

        self._access_expires = access_expires

    @property
    def api_key_alg(self):
        """Gets the api_key_alg of this UserAccessPolicyInfo.  # noqa: E501


        :return: The api_key_alg of this UserAccessPolicyInfo.  # noqa: E501
        :rtype: Algorithm
        """
        return self._api_key_alg

    @api_key_alg.setter
    def api_key_alg(self, api_key_alg):
        """Sets the api_key_alg of this UserAccessPolicyInfo.


        :param api_key_alg: The api_key_alg of this UserAccessPolicyInfo.  # noqa: E501
        :type: Algorithm
        """

        self._api_key_alg = api_key_alg

    @property
    def azure_ad_access_role(self):
        """Gets the azure_ad_access_role of this UserAccessPolicyInfo.  # noqa: E501


        :return: The azure_ad_access_role of this UserAccessPolicyInfo.  # noqa: E501
        :rtype: AzureADAccessRole
        """
        return self._azure_ad_access_role

    @azure_ad_access_role.setter
    def azure_ad_access_role(self, azure_ad_access_role):
        """Sets the azure_ad_access_role of this UserAccessPolicyInfo.


        :param azure_ad_access_role: The azure_ad_access_role of this UserAccessPolicyInfo.  # noqa: E501
        :type: AzureADAccessRole
        """

        self._azure_ad_access_role = azure_ad_access_role

    @property
    def cidr_whitelist(self):
        """Gets the cidr_whitelist of this UserAccessPolicyInfo.  # noqa: E501


        :return: The cidr_whitelist of this UserAccessPolicyInfo.  # noqa: E501
        :rtype: str
        """
        return self._cidr_whitelist

    @cidr_whitelist.setter
    def cidr_whitelist(self, cidr_whitelist):
        """Sets the cidr_whitelist of this UserAccessPolicyInfo.


        :param cidr_whitelist: The cidr_whitelist of this UserAccessPolicyInfo.  # noqa: E501
        :type: str
        """

        self._cidr_whitelist = cidr_whitelist

    @property
    def rules_type(self):
        """Gets the rules_type of this UserAccessPolicyInfo.  # noqa: E501


        :return: The rules_type of this UserAccessPolicyInfo.  # noqa: E501
        :rtype: str
        """
        return self._rules_type

    @rules_type.setter
    def rules_type(self, rules_type):
        """Sets the rules_type of this UserAccessPolicyInfo.


        :param rules_type: The rules_type of this UserAccessPolicyInfo.  # noqa: E501
        :type: str
        """

        self._rules_type = rules_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserAccessPolicyInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
