"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneAssociation = exports.ChimeResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const cr = require("aws-cdk-lib/custom-resources");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class ChimeResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const ChimeResourceProvider = new cr.Provider(this, 'ChimeResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.chimeCustomResource = new aws_cdk_lib_1.CustomResource(this, 'ChimeCustomResource', {
            serviceToken: ChimeResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = cdk.Stack.of(this);
        const constructName = 'ChimeResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const chimeCustomResourceRole = new iam.Role(this, 'ChimeResourcesRole', {
            description: 'Chime Resources',
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateSipRule',
                                'chime:DeleteSipRule',
                                'chime:UpdateSipRule',
                                'chime:GetSipRule',
                                'chime:CreateSipMediaApplication',
                                'chime:DeleteSipMediaApplication',
                                'chime:GetPhoneNumberOrder',
                                'chime:SearchAvailablePhoneNumbers',
                                'chime:CreatePhoneNumberOrder',
                                'chime:DeletePhoneNumber',
                                'chime:GetPhoneNumber',
                                'chime:CreateVoiceConnector',
                                'chime:PutVoiceConnectorStreamingConfiguration',
                                'chime:PutVoiceConnectorTermination',
                                'chime:PutVoiceConnectorOrigination',
                                'chime:ListPhoneNumbers',
                                'chime:AssociatePhoneNumbersWithVoiceConnector',
                                'chime:DisassociatePhoneNumbersFromVoiceConnector',
                                'chime:DeleteVoiceConnector',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new lambda.Function(stack, constructName, {
            runtime: lambda.Runtime.PYTHON_3_9,
            code: lambda.Code.fromAsset(path.join(__dirname, '../resources')),
            handler: 'index.handler',
            architecture: lambda.Architecture.ARM_64,
            role: chimeCustomResourceRole,
            timeout: cdk.Duration.minutes(1),
        });
        return fn;
    }
}
exports.ChimeResources = ChimeResources;
_a = JSII_RTTI_SYMBOL_1;
ChimeResources[_a] = { fqn: "cdk-amazon-chime-resources.ChimeResources", version: "0.0.24" };
class PhoneAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.phoneAssociationResource = new custom_resources_1.AwsCustomResource(this, 'phoneAssociation', {
            onCreate: {
                service: 'Chime',
                action: 'associatePhoneNumbersWithVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                    ForceAssociate: true,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(cdk.Names.uniqueId(this)),
            },
            onDelete: {
                service: 'Chime',
                action: 'disassociatePhoneNumbersFromVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(cdk.Names.uniqueId(this)),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PhoneAssociation = PhoneAssociation;
_b = JSII_RTTI_SYMBOL_1;
PhoneAssociation[_b] = { fqn: "cdk-amazon-chime-resources.PhoneAssociation", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3VzdG9tUmVzb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvY3VzdG9tUmVzb3VyY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw4Q0FBOEM7QUFDOUMsNkJBQTZCO0FBQzdCLG1DQUFtQztBQUNuQyw2Q0FBNkM7QUFDN0MsMkNBQTJDO0FBQzNDLGlEQUFpRDtBQUNqRCxtREFBbUQ7QUFDbkQsbUVBSXNDO0FBQ3RDLDJDQUF1QztBQWF2QyxNQUFhLGNBQWUsU0FBUSxzQkFBUztJQUkzQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7UUFFbEMsTUFBTSxxQkFBcUIsR0FBRyxJQUFJLEVBQUUsQ0FBQyxRQUFRLENBQzNDLElBQUksRUFDSix1QkFBdUIsRUFDdkI7WUFDRSxjQUFjLEVBQUUsSUFBSSxDQUFDLE1BQU07U0FDNUIsQ0FDRixDQUFDO1FBRUYsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksNEJBQWMsQ0FBQyxJQUFJLEVBQUUscUJBQXFCLEVBQUU7WUFDekUsWUFBWSxFQUFFLHFCQUFxQixDQUFDLFlBQVk7WUFDaEQsVUFBVSxFQUFFLEVBQUUsR0FBRyxLQUFLLEVBQUU7U0FDekIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLFlBQVk7UUFDbEIsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDakMsTUFBTSxhQUFhLEdBQUcsZ0JBQWdCLENBQUM7UUFDdkMsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDeEQsSUFBSSxRQUFRLEVBQUU7WUFDWixPQUFPLFFBQTJCLENBQUM7U0FDcEM7UUFFRCxNQUFNLHVCQUF1QixHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLEVBQUU7WUFDdkUsV0FBVyxFQUFFLGlCQUFpQjtZQUM5QixTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsc0JBQXNCLENBQUM7WUFDM0QsY0FBYyxFQUFFO2dCQUNkLENBQUMsYUFBYSxDQUFDLEVBQUUsSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDO29CQUN0QyxVQUFVLEVBQUU7d0JBQ1YsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDOzRCQUN0QixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7NEJBQ2hCLE9BQU8sRUFBRTtnQ0FDUCxxQkFBcUI7Z0NBQ3JCLHFCQUFxQjtnQ0FDckIscUJBQXFCO2dDQUNyQixrQkFBa0I7Z0NBQ2xCLGlDQUFpQztnQ0FDakMsaUNBQWlDO2dDQUNqQywyQkFBMkI7Z0NBQzNCLG1DQUFtQztnQ0FDbkMsOEJBQThCO2dDQUM5Qix5QkFBeUI7Z0NBQ3pCLHNCQUFzQjtnQ0FDdEIsNEJBQTRCO2dDQUM1QiwrQ0FBK0M7Z0NBQy9DLG9DQUFvQztnQ0FDcEMsb0NBQW9DO2dDQUNwQyx3QkFBd0I7Z0NBQ3hCLCtDQUErQztnQ0FDL0Msa0RBQWtEO2dDQUNsRCw0QkFBNEI7Z0NBQzVCLGtCQUFrQjtnQ0FDbEIsc0JBQXNCO2dDQUN0QixtQkFBbUI7Z0NBQ25CLDZCQUE2Qjs2QkFDOUI7eUJBQ0YsQ0FBQzt3QkFDRixJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7NEJBQ3RCLFNBQVMsRUFBRTtnQ0FDVCxlQUFlLEtBQUssQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDLE9BQU8sb0JBQW9COzZCQUNqRTs0QkFDRCxPQUFPLEVBQUU7Z0NBQ1Asa0JBQWtCO2dDQUNsQixrQkFBa0I7Z0NBQ2xCLHFCQUFxQjs2QkFDdEI7eUJBQ0YsQ0FBQztxQkFDSDtpQkFDRixDQUFDO2FBQ0g7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsR0FBRyxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FDeEMsMENBQTBDLENBQzNDO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFDSCxNQUFNLEVBQUUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtZQUNuRCxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO1lBQ2xDLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxjQUFjLENBQUMsQ0FBQztZQUNqRSxPQUFPLEVBQUUsZUFBZTtZQUN4QixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNO1lBQ3hDLElBQUksRUFBRSx1QkFBdUI7WUFDN0IsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztTQUNqQyxDQUFDLENBQUM7UUFFSCxPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7O0FBN0ZILHdDQThGQzs7O0FBTUQsTUFBYSxnQkFBaUIsU0FBUSxzQkFBUztJQUc3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLHdCQUF3QixHQUFHLElBQUksb0NBQWlCLENBQ25ELElBQUksRUFDSixrQkFBa0IsRUFDbEI7WUFDRSxRQUFRLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLE9BQU87Z0JBQ2hCLE1BQU0sRUFBRSx5Q0FBeUM7Z0JBQ2pELE1BQU0sRUFBRSxXQUFXO2dCQUNuQixVQUFVLEVBQUU7b0JBQ1YsZ0JBQWdCLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDO29CQUN6QyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO29CQUN4QyxjQUFjLEVBQUUsSUFBSTtpQkFDckI7Z0JBQ0Qsa0JBQWtCLEVBQUUscUNBQWtCLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ3BFO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLE9BQU8sRUFBRSxPQUFPO2dCQUNoQixNQUFNLEVBQUUsNENBQTRDO2dCQUNwRCxNQUFNLEVBQUUsV0FBVztnQkFDbkIsVUFBVSxFQUFFO29CQUNWLGdCQUFnQixFQUFFLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQztvQkFDekMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtpQkFDekM7Z0JBQ0Qsa0JBQWtCLEVBQUUscUNBQWtCLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ3BFO1lBQ0QsTUFBTSxFQUFFLDBDQUF1QixDQUFDLFlBQVksQ0FBQztnQkFDM0MsU0FBUyxFQUFFLDBDQUF1QixDQUFDLFlBQVk7YUFDaEQsQ0FBQztTQUNILENBQ0YsQ0FBQztJQUNKLENBQUM7O0FBcENILDRDQXFDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIEB0eXBlc2NyaXB0LWVzbGludC9pbmRlbnQgKi9cbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ3VzdG9tUmVzb3VyY2UgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBjciBmcm9tICdhd3MtY2RrLWxpYi9jdXN0b20tcmVzb3VyY2VzJztcbmltcG9ydCB7XG4gIEF3c0N1c3RvbVJlc291cmNlLFxuICBBd3NDdXN0b21SZXNvdXJjZVBvbGljeSxcbiAgUGh5c2ljYWxSZXNvdXJjZUlkLFxufSBmcm9tICdhd3MtY2RrLWxpYi9jdXN0b20tcmVzb3VyY2VzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIENoaW1lUmVzb3VyY2VQcm9wcyBleHRlbmRzIGNkay5SZXNvdXJjZVByb3BzIHtcbiAgcmVhZG9ubHkgcHJvcGVydGllczogeyBbcHJvcG5hbWU6IHN0cmluZ106IGFueSB9O1xuICByZWFkb25seSByZXNvdXJjZVR5cGU6XG4gICAgfCAnUGhvbmVOdW1iZXInXG4gICAgfCAnVm9pY2VDb25uZWN0b3InXG4gICAgfCAnU01BJ1xuICAgIHwgJ1NNQVJ1bGUnXG4gICAgfCAnUGhvbmVBc3NvY2lhdGlvbic7XG4gIHJlYWRvbmx5IHVpZDogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQ2hpbWVSZXNvdXJjZXMgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgbGFtYmRhOiBsYW1iZGEuSUZ1bmN0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgY2hpbWVDdXN0b21SZXNvdXJjZTogQ3VzdG9tUmVzb3VyY2U7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENoaW1lUmVzb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgdGhpcy5sYW1iZGEgPSB0aGlzLmVuc3VyZUxhbWJkYSgpO1xuXG4gICAgY29uc3QgQ2hpbWVSZXNvdXJjZVByb3ZpZGVyID0gbmV3IGNyLlByb3ZpZGVyKFxuICAgICAgdGhpcyxcbiAgICAgICdDaGltZVJlc291cmNlUHJvdmlkZXInLFxuICAgICAge1xuICAgICAgICBvbkV2ZW50SGFuZGxlcjogdGhpcy5sYW1iZGEsXG4gICAgICB9LFxuICAgICk7XG5cbiAgICB0aGlzLmNoaW1lQ3VzdG9tUmVzb3VyY2UgPSBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0NoaW1lQ3VzdG9tUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IENoaW1lUmVzb3VyY2VQcm92aWRlci5zZXJ2aWNlVG9rZW4sXG4gICAgICBwcm9wZXJ0aWVzOiB7IC4uLnByb3BzIH0sXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIGVuc3VyZUxhbWJkYSgpOiBsYW1iZGEuRnVuY3Rpb24ge1xuICAgIGNvbnN0IHN0YWNrID0gY2RrLlN0YWNrLm9mKHRoaXMpO1xuICAgIGNvbnN0IGNvbnN0cnVjdE5hbWUgPSAnQ2hpbWVSZXNvdXJjZXMnO1xuICAgIGNvbnN0IGV4aXN0aW5nID0gc3RhY2subm9kZS50cnlGaW5kQ2hpbGQoY29uc3RydWN0TmFtZSk7XG4gICAgaWYgKGV4aXN0aW5nKSB7XG4gICAgICByZXR1cm4gZXhpc3RpbmcgYXMgbGFtYmRhLkZ1bmN0aW9uO1xuICAgIH1cblxuICAgIGNvbnN0IGNoaW1lQ3VzdG9tUmVzb3VyY2VSb2xlID0gbmV3IGlhbS5Sb2xlKHRoaXMsICdDaGltZVJlc291cmNlc1JvbGUnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ0NoaW1lIFJlc291cmNlcycsXG4gICAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnbGFtYmRhLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIGlubGluZVBvbGljaWVzOiB7XG4gICAgICAgIFsnY2hpbWVQb2xpY3knXTogbmV3IGlhbS5Qb2xpY3lEb2N1bWVudCh7XG4gICAgICAgICAgc3RhdGVtZW50czogW1xuICAgICAgICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgICAgICAgICBhY3Rpb25zOiBbXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkNyZWF0ZVNpcFJ1bGUnLFxuICAgICAgICAgICAgICAgICdjaGltZTpEZWxldGVTaXBSdWxlJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6VXBkYXRlU2lwUnVsZScsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkdldFNpcFJ1bGUnLFxuICAgICAgICAgICAgICAgICdjaGltZTpDcmVhdGVTaXBNZWRpYUFwcGxpY2F0aW9uJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6RGVsZXRlU2lwTWVkaWFBcHBsaWNhdGlvbicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkdldFBob25lTnVtYmVyT3JkZXInLFxuICAgICAgICAgICAgICAgICdjaGltZTpTZWFyY2hBdmFpbGFibGVQaG9uZU51bWJlcnMnLFxuICAgICAgICAgICAgICAgICdjaGltZTpDcmVhdGVQaG9uZU51bWJlck9yZGVyJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6RGVsZXRlUGhvbmVOdW1iZXInLFxuICAgICAgICAgICAgICAgICdjaGltZTpHZXRQaG9uZU51bWJlcicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkNyZWF0ZVZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6UHV0Vm9pY2VDb25uZWN0b3JTdHJlYW1pbmdDb25maWd1cmF0aW9uJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6UHV0Vm9pY2VDb25uZWN0b3JUZXJtaW5hdGlvbicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOlB1dFZvaWNlQ29ubmVjdG9yT3JpZ2luYXRpb24nLFxuICAgICAgICAgICAgICAgICdjaGltZTpMaXN0UGhvbmVOdW1iZXJzJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6QXNzb2NpYXRlUGhvbmVOdW1iZXJzV2l0aFZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6RGlzYXNzb2NpYXRlUGhvbmVOdW1iZXJzRnJvbVZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6RGVsZXRlVm9pY2VDb25uZWN0b3InLFxuICAgICAgICAgICAgICAgICdsYW1iZGE6R2V0UG9saWN5JyxcbiAgICAgICAgICAgICAgICAnbGFtYmRhOkFkZFBlcm1pc3Npb24nLFxuICAgICAgICAgICAgICAgICdpYW06UHV0Um9sZVBvbGljeScsXG4gICAgICAgICAgICAgICAgJ2lhbTpDcmVhdGVTZXJ2aWNlTGlua2VkUm9sZScsXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICAgICAgYGFybjphd3M6c3NtOiR7c3RhY2sucmVnaW9ufToke3N0YWNrLmFjY291bnR9OnBhcmFtZXRlci9jaGltZS8qYCxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICAgICAgICdzc206UHV0UGFyYW1ldGVyJyxcbiAgICAgICAgICAgICAgICAnc3NtOkdldFBhcmFtZXRlcicsXG4gICAgICAgICAgICAgICAgJ3NzbTpEZWxldGVQYXJhbWV0ZXInLFxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgXSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgICAgbWFuYWdlZFBvbGljaWVzOiBbXG4gICAgICAgIGlhbS5NYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZShcbiAgICAgICAgICAnc2VydmljZS1yb2xlL0FXU0xhbWJkYUJhc2ljRXhlY3V0aW9uUm9sZScsXG4gICAgICAgICksXG4gICAgICBdLFxuICAgIH0pO1xuICAgIGNvbnN0IGZuID0gbmV3IGxhbWJkYS5GdW5jdGlvbihzdGFjaywgY29uc3RydWN0TmFtZSwge1xuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOSxcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vcmVzb3VyY2VzJykpLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgYXJjaGl0ZWN0dXJlOiBsYW1iZGEuQXJjaGl0ZWN0dXJlLkFSTV82NCxcbiAgICAgIHJvbGU6IGNoaW1lQ3VzdG9tUmVzb3VyY2VSb2xlLFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLm1pbnV0ZXMoMSksXG4gICAgfSk7XG5cbiAgICByZXR1cm4gZm47XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBQaG9uZUFzc29jaWF0aW9uUHJvcHMgZXh0ZW5kcyBjZGsuUmVzb3VyY2VQcm9wcyB7XG4gIHJlYWRvbmx5IHZvaWNlQ29ubmVjdG9ySWQ6IHN0cmluZztcbiAgcmVhZG9ubHkgZTE2NFBob25lTnVtYmVyOiBzdHJpbmc7XG59XG5leHBvcnQgY2xhc3MgUGhvbmVBc3NvY2lhdGlvbiBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBwaG9uZUFzc29jaWF0aW9uUmVzb3VyY2U6IEF3c0N1c3RvbVJlc291cmNlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBQaG9uZUFzc29jaWF0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5waG9uZUFzc29jaWF0aW9uUmVzb3VyY2UgPSBuZXcgQXdzQ3VzdG9tUmVzb3VyY2UoXG4gICAgICB0aGlzLFxuICAgICAgJ3Bob25lQXNzb2NpYXRpb24nLFxuICAgICAge1xuICAgICAgICBvbkNyZWF0ZToge1xuICAgICAgICAgIHNlcnZpY2U6ICdDaGltZScsXG4gICAgICAgICAgYWN0aW9uOiAnYXNzb2NpYXRlUGhvbmVOdW1iZXJzV2l0aFZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgICByZWdpb246ICd1cy1lYXN0LTEnLFxuICAgICAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgICAgIEUxNjRQaG9uZU51bWJlcnM6IFtwcm9wcy5lMTY0UGhvbmVOdW1iZXJdLFxuICAgICAgICAgICAgVm9pY2VDb25uZWN0b3JJZDogcHJvcHMudm9pY2VDb25uZWN0b3JJZCxcbiAgICAgICAgICAgIEZvcmNlQXNzb2NpYXRlOiB0cnVlLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgcGh5c2ljYWxSZXNvdXJjZUlkOiBQaHlzaWNhbFJlc291cmNlSWQub2YoY2RrLk5hbWVzLnVuaXF1ZUlkKHRoaXMpKSxcbiAgICAgICAgfSxcbiAgICAgICAgb25EZWxldGU6IHtcbiAgICAgICAgICBzZXJ2aWNlOiAnQ2hpbWUnLFxuICAgICAgICAgIGFjdGlvbjogJ2Rpc2Fzc29jaWF0ZVBob25lTnVtYmVyc0Zyb21Wb2ljZUNvbm5lY3RvcicsXG4gICAgICAgICAgcmVnaW9uOiAndXMtZWFzdC0xJyxcbiAgICAgICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgICAgICBFMTY0UGhvbmVOdW1iZXJzOiBbcHJvcHMuZTE2NFBob25lTnVtYmVyXSxcbiAgICAgICAgICAgIFZvaWNlQ29ubmVjdG9ySWQ6IHByb3BzLnZvaWNlQ29ubmVjdG9ySWQsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IFBoeXNpY2FsUmVzb3VyY2VJZC5vZihjZGsuTmFtZXMudW5pcXVlSWQodGhpcykpLFxuICAgICAgICB9LFxuICAgICAgICBwb2xpY3k6IEF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgICAgcmVzb3VyY2VzOiBBd3NDdXN0b21SZXNvdXJjZVBvbGljeS5BTllfUkVTT1VSQ0UsXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICApO1xuICB9XG59XG4iXX0=