import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The DN of the container used to hold the computer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/computer#container Computer#container}
    */
    readonly container?: string;
    /**
    * Specifies a description of the object. This parameter sets the value of the Description property for the computer object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/computer#description Computer#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/computer#id Computer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for the computer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/computer#name Computer#name}
    */
    readonly name: string;
    /**
    * The pre-win2k name for the computer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/computer#pre2kname Computer#pre2kname}
    */
    readonly pre2Kname?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/computer ad_computer}
*/
export declare class Computer extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_computer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/computer ad_computer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputerConfig
    */
    constructor(scope: Construct, id: string, config: ComputerConfig);
    private _container?;
    get container(): string;
    set container(value: string);
    resetContainer(): void;
    get containerInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get dn(): string;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pre2Kname?;
    get pre2Kname(): string;
    set pre2Kname(value: string);
    resetPre2Kname(): void;
    get pre2KnameInput(): string | undefined;
    get sid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
