import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAdComputerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The OU's identifier. It can be the OU's GUID, SID, Distinguished Name, or SAM Account Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/computer#computer_id DataAdComputer#computer_id}
    */
    readonly computerId?: string;
    /**
    * The Distinguished Name of the computer object. This field is deprecated in favour of `computer_id`. In the future this field will be read-only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/computer#dn DataAdComputer#dn}
    */
    readonly dn?: string;
    /**
    * The GUID of the computer object. This field is deprecated in favour of `computer_id`. In the future this field will be read-only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/computer#guid DataAdComputer#guid}
    */
    readonly guid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/computer#id DataAdComputer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/d/computer ad_computer}
*/
export declare class DataAdComputer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ad_computer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/d/computer ad_computer} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAdComputerConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAdComputerConfig);
    private _computerId?;
    get computerId(): string;
    set computerId(value: string);
    resetComputerId(): void;
    get computerIdInput(): string | undefined;
    private _dn?;
    get dn(): string;
    set dn(value: string);
    resetDn(): void;
    get dnInput(): string | undefined;
    private _guid?;
    get guid(): string;
    set guid(value: string);
    resetGuid(): void;
    get guidInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get sid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
