import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAdGpoConfig extends cdktf.TerraformMetaArguments {
    /**
    * GUID of the GPO.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/gpo#guid DataAdGpo#guid}
    */
    readonly guid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/gpo#id DataAdGpo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the GPO.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/gpo#name DataAdGpo#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/d/gpo ad_gpo}
*/
export declare class DataAdGpo extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ad_gpo";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/d/gpo ad_gpo} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAdGpoConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAdGpoConfig);
    get domain(): string;
    private _guid?;
    get guid(): string;
    set guid(value: string);
    resetGuid(): void;
    get guidInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
