import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdProviderConfig {
    /**
    * Use a specific domain controller. (default: none, environment variable: AD_DC)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#domain_controller AdProvider#domain_controller}
    */
    readonly domainController?: string;
    /**
    * Path to kerberos configuration file. (default: none, environment variable: AD_KRB_CONF)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#krb_conf AdProvider#krb_conf}
    */
    readonly krbConf?: string;
    /**
    * Path to a keytab file to be used instead of a password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#krb_keytab AdProvider#krb_keytab}
    */
    readonly krbKeytab?: string;
    /**
    * The name of the kerberos realm (domain) we will use for authentication. (default: "", environment variable: AD_KRB_REALM)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#krb_realm AdProvider#krb_realm}
    */
    readonly krbRealm?: string;
    /**
    * Alternative Service Principal Name. (default: none, environment variable: AD_KRB_SPN)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#krb_spn AdProvider#krb_spn}
    */
    readonly krbSpn?: string;
    /**
    * The hostname of the server we will use to run powershell scripts over WinRM. (Environment variable: AD_HOSTNAME)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_hostname AdProvider#winrm_hostname}
    */
    readonly winrmHostname: string;
    /**
    * Trust unknown certificates. (default: false, environment variable: AD_WINRM_INSECURE)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_insecure AdProvider#winrm_insecure}
    */
    readonly winrmInsecure?: boolean | cdktf.IResolvable;
    /**
    * Pass credentials in WinRM session to create a System.Management.Automation.PSCredential. (default: false, environment variable: AD_WINRM_PASS_CREDENTIALS)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_pass_credentials AdProvider#winrm_pass_credentials}
    */
    readonly winrmPassCredentials?: boolean | cdktf.IResolvable;
    /**
    * The password used to authenticate to the server's WinRM service. (Environment variable: AD_PASSWORD)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_password AdProvider#winrm_password}
    */
    readonly winrmPassword: string;
    /**
    * The port WinRM is listening for connections. (default: 5985, environment variable: AD_PORT)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_port AdProvider#winrm_port}
    */
    readonly winrmPort?: number;
    /**
    * The WinRM protocol we will use. (default: http, environment variable: AD_PROTO)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_proto AdProvider#winrm_proto}
    */
    readonly winrmProto?: string;
    /**
    * Use NTLM authentication. (default: false, environment variable: AD_WINRM_USE_NTLM)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_use_ntlm AdProvider#winrm_use_ntlm}
    */
    readonly winrmUseNtlm?: boolean | cdktf.IResolvable;
    /**
    * The username used to authenticate to the server's WinRM service. (Environment variable: AD_USER)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#winrm_username AdProvider#winrm_username}
    */
    readonly winrmUsername: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad#alias AdProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad ad}
*/
export declare class AdProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "ad";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad ad} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdProviderConfig
    */
    constructor(scope: Construct, id: string, config: AdProviderConfig);
    private _domainController?;
    get domainController(): string | undefined;
    set domainController(value: string | undefined);
    resetDomainController(): void;
    get domainControllerInput(): string | undefined;
    private _krbConf?;
    get krbConf(): string | undefined;
    set krbConf(value: string | undefined);
    resetKrbConf(): void;
    get krbConfInput(): string | undefined;
    private _krbKeytab?;
    get krbKeytab(): string | undefined;
    set krbKeytab(value: string | undefined);
    resetKrbKeytab(): void;
    get krbKeytabInput(): string | undefined;
    private _krbRealm?;
    get krbRealm(): string | undefined;
    set krbRealm(value: string | undefined);
    resetKrbRealm(): void;
    get krbRealmInput(): string | undefined;
    private _krbSpn?;
    get krbSpn(): string | undefined;
    set krbSpn(value: string | undefined);
    resetKrbSpn(): void;
    get krbSpnInput(): string | undefined;
    private _winrmHostname?;
    get winrmHostname(): string | undefined;
    set winrmHostname(value: string | undefined);
    get winrmHostnameInput(): string | undefined;
    private _winrmInsecure?;
    get winrmInsecure(): boolean | cdktf.IResolvable | undefined;
    set winrmInsecure(value: boolean | cdktf.IResolvable | undefined);
    resetWinrmInsecure(): void;
    get winrmInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _winrmPassCredentials?;
    get winrmPassCredentials(): boolean | cdktf.IResolvable | undefined;
    set winrmPassCredentials(value: boolean | cdktf.IResolvable | undefined);
    resetWinrmPassCredentials(): void;
    get winrmPassCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _winrmPassword?;
    get winrmPassword(): string | undefined;
    set winrmPassword(value: string | undefined);
    get winrmPasswordInput(): string | undefined;
    private _winrmPort?;
    get winrmPort(): number | undefined;
    set winrmPort(value: number | undefined);
    resetWinrmPort(): void;
    get winrmPortInput(): number | undefined;
    private _winrmProto?;
    get winrmProto(): string | undefined;
    set winrmProto(value: string | undefined);
    resetWinrmProto(): void;
    get winrmProtoInput(): string | undefined;
    private _winrmUseNtlm?;
    get winrmUseNtlm(): boolean | cdktf.IResolvable | undefined;
    set winrmUseNtlm(value: boolean | cdktf.IResolvable | undefined);
    resetWinrmUseNtlm(): void;
    get winrmUseNtlmInput(): boolean | cdktf.IResolvable | undefined;
    private _winrmUsername?;
    get winrmUsername(): string | undefined;
    set winrmUsername(value: string | undefined);
    get winrmUsernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
