from . import SimSyscallLibrary
from .. import SIM_PROCEDURES as P

lib = SimSyscallLibrary()
lib.set_library_names('linux')
lib.add_all_from_dict(P['linux_kernel'])

lib.add('open', P['posix']['open'])
lib.add('read', P['posix']['read'])
lib.add('write', P['posix']['write'])
lib.add('close', P['posix']['close'])
lib.add('exit', P['libc']['exit'])
lib.add('sigaction', P['posix']['sigaction'])
lib.add('dup', P['posix']['dup'])
lib.add('pread64', P['posix']['pread64'])
lib.add('pwrite64', P['posix']['pwrite64'])

lib.add_alias('exit', 'exit_group')
lib.add_alias('getuid', 'geteuid')
lib.add_alias('getgid', 'getegid')


# python parse_syscalls_from_local_system.py >> linux_kernel.py

lib.add_number_mapping_from_dict("aarch64", {
    0: "io_setup",
    1: "io_destroy",
    2: "io_submit",
    3: "io_cancel",
    4: "io_getevents",
    5: "setxattr",
    6: "lsetxattr",
    7: "fsetxattr",
    8: "getxattr",
    9: "lgetxattr",
    10: "fgetxattr",
    11: "listxattr",
    12: "llistxattr",
    13: "flistxattr",
    14: "removexattr",
    15: "lremovexattr",
    16: "fremovexattr",
    17: "getcwd",
    18: "lookup_dcookie",
    19: "eventfd2",
    20: "epoll_create1",
    21: "epoll_ctl",
    22: "epoll_pwait",
    23: "dup",
    24: "dup3",
    25: "fcntl",
    26: "inotify_init1",
    27: "inotify_add_watch",
    28: "inotify_rm_watch",
    29: "ioctl",
    30: "ioprio_set",
    31: "ioprio_get",
    32: "flock",
    33: "mknodat",
    34: "mkdirat",
    35: "unlinkat",
    36: "symlinkat",
    37: "linkat",
    38: "renameat",
    39: "umount2",
    40: "mount",
    41: "pivot_root",
    42: "nfsservctl",
    43: "statfs",
    44: "fstatfs",
    45: "truncate",
    46: "ftruncate",
    47: "fallocate",
    48: "faccessat",
    49: "chdir",
    50: "fchdir",
    51: "chroot",
    52: "fchmod",
    53: "fchmodat",
    54: "fchownat",
    55: "fchown",
    56: "openat",
    57: "close",
    58: "vhangup",
    59: "pipe2",
    60: "quotactl",
    61: "getdents64",
    62: "lseek",
    63: "read",
    64: "write",
    65: "readv",
    66: "writev",
    67: "pread64",
    68: "pwrite64",
    69: "preadv",
    70: "pwritev",
    71: "sendfile",
    72: "pselect6",
    73: "ppoll",
    74: "signalfd4",
    75: "vmsplice",
    76: "splice",
    77: "tee",
    78: "readlinkat",
    79: "newfstatat",
    80: "fstat",
    81: "sync",
    82: "fsync",
    83: "fdatasync",
    84: "sync_file_range",
    85: "timerfd_create",
    86: "timerfd_settime",
    87: "timerfd_gettime",
    88: "utimensat",
    89: "acct",
    90: "capget",
    91: "capset",
    92: "personality",
    93: "exit",
    94: "exit_group",
    95: "waitid",
    96: "set_tid_address",
    97: "unshare",
    98: "futex",
    99: "set_robust_list",
    100: "get_robust_list",
    101: "nanosleep",
    102: "getitimer",
    103: "setitimer",
    104: "kexec_load",
    105: "init_module",
    106: "delete_module",
    107: "timer_create",
    108: "timer_gettime",
    109: "timer_getoverrun",
    110: "timer_settime",
    111: "timer_delete",
    112: "clock_settime",
    113: "clock_gettime",
    114: "clock_getres",
    115: "clock_nanosleep",
    116: "syslog",
    117: "ptrace",
    118: "sched_setparam",
    119: "sched_setscheduler",
    120: "sched_getscheduler",
    121: "sched_getparam",
    122: "sched_setaffinity",
    123: "sched_getaffinity",
    124: "sched_yield",
    125: "sched_get_priority_max",
    126: "sched_get_priority_min",
    127: "sched_rr_get_interval",
    128: "restart_syscall",
    129: "kill",
    130: "tkill",
    131: "tgkill",
    132: "sigaltstack",
    133: "rt_sigsuspend",
    134: "rt_sigaction",
    135: "rt_sigprocmask",
    136: "rt_sigpending",
    137: "rt_sigtimedwait",
    138: "rt_sigqueueinfo",
    139: "rt_sigreturn",
    140: "setpriority",
    141: "getpriority",
    142: "reboot",
    143: "setregid",
    144: "setgid",
    145: "setreuid",
    146: "setuid",
    147: "setresuid",
    148: "getresuid",
    149: "setresgid",
    150: "getresgid",
    151: "setfsuid",
    152: "setfsgid",
    153: "times",
    154: "setpgid",
    155: "getpgid",
    156: "getsid",
    157: "setsid",
    158: "getgroups",
    159: "setgroups",
    160: "uname",
    161: "sethostname",
    162: "setdomainname",
    163: "getrlimit",
    164: "setrlimit",
    165: "getrusage",
    166: "umask",
    167: "prctl",
    168: "getcpu",
    169: "gettimeofday",
    170: "settimeofday",
    171: "adjtimex",
    172: "getpid",
    173: "getppid",
    174: "getuid",
    175: "geteuid",
    176: "getgid",
    177: "getegid",
    178: "gettid",
    179: "sysinfo",
    180: "mq_open",
    181: "mq_unlink",
    182: "mq_timedsend",
    183: "mq_timedreceive",
    184: "mq_notify",
    185: "mq_getsetattr",
    186: "msgget",
    187: "msgctl",
    188: "msgrcv",
    189: "msgsnd",
    190: "semget",
    191: "semctl",
    192: "semtimedop",
    193: "semop",
    194: "shmget",
    195: "shmctl",
    196: "shmat",
    197: "shmdt",
    198: "socket",
    199: "socketpair",
    200: "bind",
    201: "listen",
    202: "accept",
    203: "connect",
    204: "getsockname",
    205: "getpeername",
    206: "sendto",
    207: "recvfrom",
    208: "setsockopt",
    209: "getsockopt",
    210: "shutdown",
    211: "sendmsg",
    212: "recvmsg",
    213: "readahead",
    214: "brk",
    215: "munmap",
    216: "mremap",
    217: "add_key",
    218: "request_key",
    219: "keyctl",
    220: "clone",
    221: "execve",
    222: "mmap",
    223: "fadvise64",
    224: "swapon",
    225: "swapoff",
    226: "mprotect",
    227: "msync",
    228: "mlock",
    229: "munlock",
    230: "mlockall",
    231: "munlockall",
    232: "mincore",
    233: "madvise",
    234: "remap_file_pages",
    235: "mbind",
    236: "get_mempolicy",
    237: "set_mempolicy",
    238: "migrate_pages",
    239: "move_pages",
    240: "rt_tgsigqueueinfo",
    241: "perf_event_open",
    242: "accept4",
    243: "recvmmsg",
    244: "arch_specific_syscall",
    260: "wait4",
    261: "prlimit64",
    262: "fanotify_init",
    263: "fanotify_mark",
    264: "name_to_handle_at",
    265: "open_by_handle_at",
    266: "clock_adjtime",
    267: "syncfs",
    268: "setns",
    269: "sendmmsg",
    270: "process_vm_readv",
    271: "process_vm_writev",
    272: "kcmp",
    273: "syscalls",
})

lib.add_number_mapping_from_dict("amd64", {
    0: "read",
    1: "write",
    2: "open",
    3: "close",
    4: "stat",
    5: "fstat",
    6: "lstat",
    7: "poll",
    8: "lseek",
    9: "mmap",
    10: "mprotect",
    11: "munmap",
    12: "brk",
    13: "rt_sigaction",
    14: "rt_sigprocmask",
    15: "rt_sigreturn",
    16: "ioctl",
    17: "pread64",
    18: "pwrite64",
    19: "readv",
    20: "writev",
    21: "access",
    22: "pipe",
    23: "select",
    24: "sched_yield",
    25: "mremap",
    26: "msync",
    27: "mincore",
    28: "madvise",
    29: "shmget",
    30: "shmat",
    31: "shmctl",
    32: "dup",
    33: "dup2",
    34: "pause",
    35: "nanosleep",
    36: "getitimer",
    37: "alarm",
    38: "setitimer",
    39: "getpid",
    40: "sendfile",
    41: "socket",
    42: "connect",
    43: "accept",
    44: "sendto",
    45: "recvfrom",
    46: "sendmsg",
    47: "recvmsg",
    48: "shutdown",
    49: "bind",
    50: "listen",
    51: "getsockname",
    52: "getpeername",
    53: "socketpair",
    54: "setsockopt",
    55: "getsockopt",
    56: "clone",
    57: "fork",
    58: "vfork",
    59: "execve",
    60: "exit",
    61: "wait4",
    62: "kill",
    63: "uname",
    64: "semget",
    65: "semop",
    66: "semctl",
    67: "shmdt",
    68: "msgget",
    69: "msgsnd",
    70: "msgrcv",
    71: "msgctl",
    72: "fcntl",
    73: "flock",
    74: "fsync",
    75: "fdatasync",
    76: "truncate",
    77: "ftruncate",
    78: "getdents",
    79: "getcwd",
    80: "chdir",
    81: "fchdir",
    82: "rename",
    83: "mkdir",
    84: "rmdir",
    85: "creat",
    86: "link",
    87: "unlink",
    88: "symlink",
    89: "readlink",
    90: "chmod",
    91: "fchmod",
    92: "chown",
    93: "fchown",
    94: "lchown",
    95: "umask",
    96: "gettimeofday",
    97: "getrlimit",
    98: "getrusage",
    99: "sysinfo",
    100: "times",
    101: "ptrace",
    102: "getuid",
    103: "syslog",
    104: "getgid",
    105: "setuid",
    106: "setgid",
    107: "geteuid",
    108: "getegid",
    109: "setpgid",
    110: "getppid",
    111: "getpgrp",
    112: "setsid",
    113: "setreuid",
    114: "setregid",
    115: "getgroups",
    116: "setgroups",
    117: "setresuid",
    118: "getresuid",
    119: "setresgid",
    120: "getresgid",
    121: "getpgid",
    122: "setfsuid",
    123: "setfsgid",
    124: "getsid",
    125: "capget",
    126: "capset",
    127: "rt_sigpending",
    128: "rt_sigtimedwait",
    129: "rt_sigqueueinfo",
    130: "rt_sigsuspend",
    131: "sigaltstack",
    132: "utime",
    133: "mknod",
    134: "uselib",
    135: "personality",
    136: "ustat",
    137: "statfs",
    138: "fstatfs",
    139: "sysfs",
    140: "getpriority",
    141: "setpriority",
    142: "sched_setparam",
    143: "sched_getparam",
    144: "sched_setscheduler",
    145: "sched_getscheduler",
    146: "sched_get_priority_max",
    147: "sched_get_priority_min",
    148: "sched_rr_get_interval",
    149: "mlock",
    150: "munlock",
    151: "mlockall",
    152: "munlockall",
    153: "vhangup",
    154: "modify_ldt",
    155: "pivot_root",
    156: "_sysctl",
    157: "prctl",
    158: "arch_prctl",
    159: "adjtimex",
    160: "setrlimit",
    161: "chroot",
    162: "sync",
    163: "acct",
    164: "settimeofday",
    165: "mount",
    166: "umount2",
    167: "swapon",
    168: "swapoff",
    169: "reboot",
    170: "sethostname",
    171: "setdomainname",
    172: "iopl",
    173: "ioperm",
    174: "create_module",
    175: "init_module",
    176: "delete_module",
    177: "get_kernel_syms",
    178: "query_module",
    179: "quotactl",
    180: "nfsservctl",
    181: "getpmsg",
    182: "putpmsg",
    183: "afs_syscall",
    184: "tuxcall",
    185: "security",
    186: "gettid",
    187: "readahead",
    188: "setxattr",
    189: "lsetxattr",
    190: "fsetxattr",
    191: "getxattr",
    192: "lgetxattr",
    193: "fgetxattr",
    194: "listxattr",
    195: "llistxattr",
    196: "flistxattr",
    197: "removexattr",
    198: "lremovexattr",
    199: "fremovexattr",
    200: "tkill",
    201: "time",
    202: "futex",
    203: "sched_setaffinity",
    204: "sched_getaffinity",
    205: "set_thread_area",
    206: "io_setup",
    207: "io_destroy",
    208: "io_getevents",
    209: "io_submit",
    210: "io_cancel",
    211: "get_thread_area",
    212: "lookup_dcookie",
    213: "epoll_create",
    214: "epoll_ctl_old",
    215: "epoll_wait_old",
    216: "remap_file_pages",
    217: "getdents64",
    218: "set_tid_address",
    219: "restart_syscall",
    220: "semtimedop",
    221: "fadvise64",
    222: "timer_create",
    223: "timer_settime",
    224: "timer_gettime",
    225: "timer_getoverrun",
    226: "timer_delete",
    227: "clock_settime",
    228: "clock_gettime",
    229: "clock_getres",
    230: "clock_nanosleep",
    231: "exit_group",
    232: "epoll_wait",
    233: "epoll_ctl",
    234: "tgkill",
    235: "utimes",
    236: "vserver",
    237: "mbind",
    238: "set_mempolicy",
    239: "get_mempolicy",
    240: "mq_open",
    241: "mq_unlink",
    242: "mq_timedsend",
    243: "mq_timedreceive",
    244: "mq_notify",
    245: "mq_getsetattr",
    246: "kexec_load",
    247: "waitid",
    248: "add_key",
    249: "request_key",
    250: "keyctl",
    251: "ioprio_set",
    252: "ioprio_get",
    253: "inotify_init",
    254: "inotify_add_watch",
    255: "inotify_rm_watch",
    256: "migrate_pages",
    257: "openat",
    258: "mkdirat",
    259: "mknodat",
    260: "fchownat",
    261: "futimesat",
    262: "newfstatat",
    263: "unlinkat",
    264: "renameat",
    265: "linkat",
    266: "symlinkat",
    267: "readlinkat",
    268: "fchmodat",
    269: "faccessat",
    270: "pselect6",
    271: "ppoll",
    272: "unshare",
    273: "set_robust_list",
    274: "get_robust_list",
    275: "splice",
    276: "tee",
    277: "sync_file_range",
    278: "vmsplice",
    279: "move_pages",
    280: "utimensat",
    281: "epoll_pwait",
    282: "signalfd",
    283: "timerfd_create",
    284: "eventfd",
    285: "fallocate",
    286: "timerfd_settime",
    287: "timerfd_gettime",
    288: "accept4",
    289: "signalfd4",
    290: "eventfd2",
    291: "epoll_create1",
    292: "dup3",
    293: "pipe2",
    294: "inotify_init1",
    295: "preadv",
    296: "pwritev",
    297: "rt_tgsigqueueinfo",
    298: "perf_event_open",
    299: "recvmmsg",
    300: "fanotify_init",
    301: "fanotify_mark",
    302: "prlimit64",
    303: "name_to_handle_at",
    304: "open_by_handle_at",
    305: "clock_adjtime",
    306: "syncfs",
    307: "sendmmsg",
    308: "setns",
    309: "getcpu",
    310: "process_vm_readv",
    311: "process_vm_writev",
    312: "kcmp",
    313: "finit_module",
    314: "sched_setattr",
    315: "sched_getattr",
    316: "renameat2",
    317: "seccomp",
    318: "getrandom",
    319: "memfd_create",
    320: "kexec_file_load",
    321: "bpf",
    322: "execveat",
    323: "userfaultfd",
    324: "membarrier",
    325: "mlock2",
    326: "copy_file_range",
    327: "preadv2",
    328: "pwritev2",
    329: "pkey_mprotect",
    330: "pkey_alloc",
    331: "pkey_free",
    332: "statx",
})

lib.add_number_mapping_from_dict("arm", {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "waitpid",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    13: "time",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "break",
    18: "oldstat",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    23: "setuid",
    24: "getuid",
    25: "stime",
    26: "ptrace",
    27: "alarm",
    28: "oldfstat",
    29: "pause",
    30: "utime",
    31: "stty",
    32: "gtty",
    33: "access",
    34: "nice",
    35: "ftime",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    44: "prof",
    45: "brk",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "umount2",
    53: "lock",
    54: "ioctl",
    55: "fcntl",
    56: "mpx",
    57: "setpgid",
    58: "ulimit",
    59: "oldolduname",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    68: "sgetmask",
    69: "ssetmask",
    70: "setreuid",
    71: "setregid",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    76: "getrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    80: "getgroups",
    81: "setgroups",
    82: "select",
    83: "symlink",
    84: "oldlstat",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    95: "fchown",
    96: "getpriority",
    97: "setpriority",
    98: "profil",
    99: "statfs",
    100: "fstatfs",
    101: "ioperm",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    109: "olduname",
    110: "iopl",
    111: "vhangup",
    112: "idle",
    113: "syscall",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    123: "modify_ldt",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    138: "setfsuid",
    139: "setfsgid",
    140: "_llseek",
    141: "getdents",
    142: "_newselect",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    164: "setresuid",
    165: "getresuid",
    166: "vm86",
    167: "query_module",
    168: "poll",
    169: "nfsservctl",
    170: "setresgid",
    171: "getresgid",
    172: "prctl",
    173: "rt_sigreturn",
    174: "rt_sigaction",
    175: "rt_sigprocmask",
    176: "rt_sigpending",
    177: "rt_sigtimedwait",
    178: "rt_sigqueueinfo",
    179: "rt_sigsuspend",
    180: "pread64",
    181: "pwrite64",
    182: "chown",
    183: "getcwd",
    184: "capget",
    185: "capset",
    186: "sigaltstack",
    187: "sendfile",
    190: "vfork",
    191: "ugetrlimit",
    192: "mmap2",
    193: "truncate64",
    194: "ftruncate64",
    195: "stat64",
    196: "lstat64",
    197: "fstat64",
    198: "lchown32",
    199: "getuid32",
    200: "getgid32",
    201: "geteuid32",
    202: "getegid32",
    203: "setreuid32",
    204: "setregid32",
    205: "getgroups32",
    206: "setgroups32",
    207: "fchown32",
    208: "setresuid32",
    209: "getresuid32",
    210: "setresgid32",
    211: "getresgid32",
    212: "chown32",
    213: "setuid32",
    214: "setgid32",
    215: "setfsuid32",
    216: "setfsgid32",
    217: "getdents64",
    218: "pivot_root",
    219: "mincore",
    220: "madvise",
    221: "fcntl64",
    224: "gettid",
    225: "readahead",
    226: "setxattr",
    227: "lsetxattr",
    228: "fsetxattr",
    229: "getxattr",
    230: "lgetxattr",
    231: "fgetxattr",
    232: "listxattr",
    233: "llistxattr",
    234: "flistxattr",
    235: "removexattr",
    236: "lremovexattr",
    237: "fremovexattr",
    238: "tkill",
    239: "sendfile64",
    240: "futex",
    241: "sched_setaffinity",
    242: "sched_getaffinity",
    243: "io_setup",
    244: "io_destroy",
    245: "io_getevents",
    246: "io_submit",
    247: "io_cancel",
    248: "exit_group",
    249: "lookup_dcookie",
    250: "epoll_create",
    251: "epoll_ctl",
    252: "epoll_wait",
    253: "remap_file_pages",
    256: "set_tid_address",
    257: "timer_create",
    258: "timer_settime",
    259: "timer_gettime",
    260: "timer_getoverrun",
    261: "timer_delete",
    262: "clock_settime",
    263: "clock_gettime",
    264: "clock_getres",
    265: "clock_nanosleep",
    266: "statfs64",
    267: "fstatfs64",
    268: "tgkill",
    269: "utimes",
    270: "arm_fadvise64_64",
    271: "pciconfig_iobase",
    272: "pciconfig_read",
    273: "pciconfig_write",
    274: "mq_open",
    275: "mq_unlink",
    276: "mq_timedsend",
    277: "mq_timedreceive",
    278: "mq_notify",
    279: "mq_getsetattr",
    280: "waitid",
    281: "socket",
    282: "bind",
    283: "connect",
    284: "listen",
    285: "accept",
    286: "getsockname",
    287: "getpeername",
    288: "socketpair",
    289: "send",
    290: "sendto",
    291: "recv",
    292: "recvfrom",
    293: "shutdown",
    294: "setsockopt",
    295: "getsockopt",
    296: "sendmsg",
    297: "recvmsg",
    298: "semop",
    299: "semget",
    300: "semctl",
    301: "msgsnd",
    302: "msgrcv",
    303: "msgget",
    304: "msgctl",
    305: "shmat",
    306: "shmdt",
    307: "shmget",
    308: "shmctl",
    309: "add_key",
    310: "request_key",
    311: "keyctl",
    312: "semtimedop",
    313: "vserver",
    314: "ioprio_set",
    315: "ioprio_get",
    316: "inotify_init",
    317: "inotify_add_watch",
    318: "inotify_rm_watch",
    319: "mbind",
    320: "get_mempolicy",
    321: "set_mempolicy",
    322: "openat",
    323: "mkdirat",
    324: "mknodat",
    325: "fchownat",
    326: "futimesat",
    327: "fstatat64",
    328: "unlinkat",
    329: "renameat",
    330: "linkat",
    331: "symlinkat",
    332: "readlinkat",
    333: "fchmodat",
    334: "faccessat",
    335: "pselect6",
    336: "ppoll",
    337: "unshare",
    338: "set_robust_list",
    339: "get_robust_list",
    340: "splice",
    341: "arm_sync_file_range",
    342: "tee",
    343: "vmsplice",
    344: "move_pages",
    345: "getcpu",
    346: "epoll_pwait",
    347: "kexec_load",
    348: "utimensat",
    349: "signalfd",
    350: "timerfd_create",
    351: "eventfd",
    352: "fallocate",
    353: "timerfd_settime",
    354: "timerfd_gettime",
    355: "signalfd4",
    356: "eventfd2",
    357: "epoll_create1",
    358: "dup3",
    359: "pipe2",
    360: "inotify_init1",
    361: "preadv",
    362: "pwritev",
    363: "rt_tgsigqueueinfo",
    364: "perf_event_open",
    365: "recvmmsg",
    366: "accept4",
    367: "fanotify_init",
    368: "fanotify_mark",
    369: "prlimit64",
    370: "name_to_handle_at",
    371: "open_by_handle_at",
    372: "clock_adjtime",
    373: "syncfs",
    374: "sendmmsg",
    375: "setns",
    376: "process_vm_readv",
    377: "process_vm_writev",
    378: "kcmp",
    379: "finit_module",
})

lib.add_number_mapping_from_dict("armhf", {
    9437184: "restart_syscall",
    9437185: "exit",
    9437186: "fork",
    9437187: "read",
    9437188: "write",
    9437189: "open",
    9437190: "close",
    9437191: "waitpid",
    9437192: "creat",
    9437193: "link",
    9437194: "unlink",
    9437195: "execve",
    9437196: "chdir",
    9437197: "time",
    9437198: "mknod",
    9437199: "chmod",
    9437200: "lchown",
    9437201: "break",
    9437202: "oldstat",
    9437203: "lseek",
    9437204: "getpid",
    9437205: "mount",
    9437206: "umount",
    9437207: "setuid",
    9437208: "getuid",
    9437209: "stime",
    9437210: "ptrace",
    9437211: "alarm",
    9437212: "oldfstat",
    9437213: "pause",
    9437214: "utime",
    9437215: "stty",
    9437216: "gtty",
    9437217: "access",
    9437218: "nice",
    9437219: "ftime",
    9437220: "sync",
    9437221: "kill",
    9437222: "rename",
    9437223: "mkdir",
    9437224: "rmdir",
    9437225: "dup",
    9437226: "pipe",
    9437227: "times",
    9437228: "prof",
    9437229: "brk",
    9437230: "setgid",
    9437231: "getgid",
    9437232: "signal",
    9437233: "geteuid",
    9437234: "getegid",
    9437235: "acct",
    9437236: "umount2",
    9437237: "lock",
    9437238: "ioctl",
    9437239: "fcntl",
    9437240: "mpx",
    9437241: "setpgid",
    9437242: "ulimit",
    9437243: "oldolduname",
    9437244: "umask",
    9437245: "chroot",
    9437246: "ustat",
    9437247: "dup2",
    9437248: "getppid",
    9437249: "getpgrp",
    9437250: "setsid",
    9437251: "sigaction",
    9437252: "sgetmask",
    9437253: "ssetmask",
    9437254: "setreuid",
    9437255: "setregid",
    9437256: "sigsuspend",
    9437257: "sigpending",
    9437258: "sethostname",
    9437259: "setrlimit",
    9437260: "getrlimit",
    9437261: "getrusage",
    9437262: "gettimeofday",
    9437263: "settimeofday",
    9437264: "getgroups",
    9437265: "setgroups",
    9437266: "select",
    9437267: "symlink",
    9437268: "oldlstat",
    9437269: "readlink",
    9437270: "uselib",
    9437271: "swapon",
    9437272: "reboot",
    9437273: "readdir",
    9437274: "mmap",
    9437275: "munmap",
    9437276: "truncate",
    9437277: "ftruncate",
    9437278: "fchmod",
    9437279: "fchown",
    9437280: "getpriority",
    9437281: "setpriority",
    9437282: "profil",
    9437283: "statfs",
    9437284: "fstatfs",
    9437285: "ioperm",
    9437286: "socketcall",
    9437287: "syslog",
    9437288: "setitimer",
    9437289: "getitimer",
    9437290: "stat",
    9437291: "lstat",
    9437292: "fstat",
    9437293: "olduname",
    9437294: "iopl",
    9437295: "vhangup",
    9437296: "idle",
    9437297: "syscall",
    9437298: "wait4",
    9437299: "swapoff",
    9437300: "sysinfo",
    9437301: "ipc",
    9437302: "fsync",
    9437303: "sigreturn",
    9437304: "clone",
    9437305: "setdomainname",
    9437306: "uname",
    9437307: "modify_ldt",
    9437308: "adjtimex",
    9437309: "mprotect",
    9437310: "sigprocmask",
    9437311: "create_module",
    9437312: "init_module",
    9437313: "delete_module",
    9437314: "get_kernel_syms",
    9437315: "quotactl",
    9437316: "getpgid",
    9437317: "fchdir",
    9437318: "bdflush",
    9437319: "sysfs",
    9437320: "personality",
    9437321: "afs_syscall",
    9437322: "setfsuid",
    9437323: "setfsgid",
    9437324: "_llseek",
    9437325: "getdents",
    9437326: "_newselect",
    9437327: "flock",
    9437328: "msync",
    9437329: "readv",
    9437330: "writev",
    9437331: "getsid",
    9437332: "fdatasync",
    9437333: "_sysctl",
    9437334: "mlock",
    9437335: "munlock",
    9437336: "mlockall",
    9437337: "munlockall",
    9437338: "sched_setparam",
    9437339: "sched_getparam",
    9437340: "sched_setscheduler",
    9437341: "sched_getscheduler",
    9437342: "sched_yield",
    9437343: "sched_get_priority_max",
    9437344: "sched_get_priority_min",
    9437345: "sched_rr_get_interval",
    9437346: "nanosleep",
    9437347: "mremap",
    9437348: "setresuid",
    9437349: "getresuid",
    9437350: "vm86",
    9437351: "query_module",
    9437352: "poll",
    9437353: "nfsservctl",
    9437354: "setresgid",
    9437355: "getresgid",
    9437356: "prctl",
    9437357: "rt_sigreturn",
    9437358: "rt_sigaction",
    9437359: "rt_sigprocmask",
    9437360: "rt_sigpending",
    9437361: "rt_sigtimedwait",
    9437362: "rt_sigqueueinfo",
    9437363: "rt_sigsuspend",
    9437364: "pread64",
    9437365: "pwrite64",
    9437366: "chown",
    9437367: "getcwd",
    9437368: "capget",
    9437369: "capset",
    9437370: "sigaltstack",
    9437371: "sendfile",
    9437374: "vfork",
    9437375: "ugetrlimit",
    9437376: "mmap2",
    9437377: "truncate64",
    9437378: "ftruncate64",
    9437379: "stat64",
    9437380: "lstat64",
    9437381: "fstat64",
    9437382: "lchown32",
    9437383: "getuid32",
    9437384: "getgid32",
    9437385: "geteuid32",
    9437386: "getegid32",
    9437387: "setreuid32",
    9437388: "setregid32",
    9437389: "getgroups32",
    9437390: "setgroups32",
    9437391: "fchown32",
    9437392: "setresuid32",
    9437393: "getresuid32",
    9437394: "setresgid32",
    9437395: "getresgid32",
    9437396: "chown32",
    9437397: "setuid32",
    9437398: "setgid32",
    9437399: "setfsuid32",
    9437400: "setfsgid32",
    9437401: "getdents64",
    9437402: "pivot_root",
    9437403: "mincore",
    9437404: "madvise",
    9437405: "fcntl64",
    9437408: "gettid",
    9437409: "readahead",
    9437410: "setxattr",
    9437411: "lsetxattr",
    9437412: "fsetxattr",
    9437413: "getxattr",
    9437414: "lgetxattr",
    9437415: "fgetxattr",
    9437416: "listxattr",
    9437417: "llistxattr",
    9437418: "flistxattr",
    9437419: "removexattr",
    9437420: "lremovexattr",
    9437421: "fremovexattr",
    9437422: "tkill",
    9437423: "sendfile64",
    9437424: "futex",
    9437425: "sched_setaffinity",
    9437426: "sched_getaffinity",
    9437427: "io_setup",
    9437428: "io_destroy",
    9437429: "io_getevents",
    9437430: "io_submit",
    9437431: "io_cancel",
    9437432: "exit_group",
    9437433: "lookup_dcookie",
    9437434: "epoll_create",
    9437435: "epoll_ctl",
    9437436: "epoll_wait",
    9437437: "remap_file_pages",
    9437440: "set_tid_address",
    9437441: "timer_create",
    9437442: "timer_settime",
    9437443: "timer_gettime",
    9437444: "timer_getoverrun",
    9437445: "timer_delete",
    9437446: "clock_settime",
    9437447: "clock_gettime",
    9437448: "clock_getres",
    9437449: "clock_nanosleep",
    9437450: "statfs64",
    9437451: "fstatfs64",
    9437452: "tgkill",
    9437453: "utimes",
    9437454: "arm_fadvise64_64",
    9437455: "pciconfig_iobase",
    9437456: "pciconfig_read",
    9437457: "pciconfig_write",
    9437458: "mq_open",
    9437459: "mq_unlink",
    9437460: "mq_timedsend",
    9437461: "mq_timedreceive",
    9437462: "mq_notify",
    9437463: "mq_getsetattr",
    9437464: "waitid",
    9437465: "socket",
    9437466: "bind",
    9437467: "connect",
    9437468: "listen",
    9437469: "accept",
    9437470: "getsockname",
    9437471: "getpeername",
    9437472: "socketpair",
    9437473: "send",
    9437474: "sendto",
    9437475: "recv",
    9437476: "recvfrom",
    9437477: "shutdown",
    9437478: "setsockopt",
    9437479: "getsockopt",
    9437480: "sendmsg",
    9437481: "recvmsg",
    9437482: "semop",
    9437483: "semget",
    9437484: "semctl",
    9437485: "msgsnd",
    9437486: "msgrcv",
    9437487: "msgget",
    9437488: "msgctl",
    9437489: "shmat",
    9437490: "shmdt",
    9437491: "shmget",
    9437492: "shmctl",
    9437493: "add_key",
    9437494: "request_key",
    9437495: "keyctl",
    9437496: "semtimedop",
    9437497: "vserver",
    9437498: "ioprio_set",
    9437499: "ioprio_get",
    9437500: "inotify_init",
    9437501: "inotify_add_watch",
    9437502: "inotify_rm_watch",
    9437503: "mbind",
    9437504: "get_mempolicy",
    9437505: "set_mempolicy",
    9437506: "openat",
    9437507: "mkdirat",
    9437508: "mknodat",
    9437509: "fchownat",
    9437510: "futimesat",
    9437511: "fstatat64",
    9437512: "unlinkat",
    9437513: "renameat",
    9437514: "linkat",
    9437515: "symlinkat",
    9437516: "readlinkat",
    9437517: "fchmodat",
    9437518: "faccessat",
    9437519: "pselect6",
    9437520: "ppoll",
    9437521: "unshare",
    9437522: "set_robust_list",
    9437523: "get_robust_list",
    9437524: "splice",
    9437525: "arm_sync_file_range",
    9437526: "tee",
    9437527: "vmsplice",
    9437528: "move_pages",
    9437529: "getcpu",
    9437530: "epoll_pwait",
    9437531: "kexec_load",
    9437532: "utimensat",
    9437533: "signalfd",
    9437534: "timerfd_create",
    9437535: "eventfd",
    9437536: "fallocate",
    9437537: "timerfd_settime",
    9437538: "timerfd_gettime",
    9437539: "signalfd4",
    9437540: "eventfd2",
    9437541: "epoll_create1",
    9437542: "dup3",
    9437543: "pipe2",
    9437544: "inotify_init1",
    9437545: "preadv",
    9437546: "pwritev",
    9437547: "rt_tgsigqueueinfo",
    9437548: "perf_event_open",
    9437549: "recvmmsg",
    9437550: "accept4",
    9437551: "fanotify_init",
    9437552: "fanotify_mark",
    9437553: "prlimit64",
    9437554: "name_to_handle_at",
    9437555: "open_by_handle_at",
    9437556: "clock_adjtime",
    9437557: "syncfs",
    9437558: "sendmmsg",
    9437559: "setns",
    9437560: "process_vm_readv",
    9437561: "process_vm_writev",
    9437562: "kcmp",
    9437563: "finit_module",
})

lib.add_number_mapping_from_dict("i386", {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "waitpid",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    13: "time",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "break",
    18: "oldstat",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    23: "setuid",
    24: "getuid",
    25: "stime",
    26: "ptrace",
    27: "alarm",
    28: "oldfstat",
    29: "pause",
    30: "utime",
    31: "stty",
    32: "gtty",
    33: "access",
    34: "nice",
    35: "ftime",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    44: "prof",
    45: "brk",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "umount2",
    53: "lock",
    54: "ioctl",
    55: "fcntl",
    56: "mpx",
    57: "setpgid",
    58: "ulimit",
    59: "oldolduname",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    68: "sgetmask",
    69: "ssetmask",
    70: "setreuid",
    71: "setregid",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    76: "getrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    80: "getgroups",
    81: "setgroups",
    82: "select",
    83: "symlink",
    84: "oldlstat",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "old_mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    95: "fchown",
    96: "getpriority",
    97: "setpriority",
    98: "profil",
    99: "statfs",
    100: "fstatfs",
    101: "ioperm",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    109: "olduname",
    110: "iopl",
    111: "vhangup",
    112: "idle",
    113: "vm86old",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    123: "modify_ldt",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    138: "setfsuid",
    139: "setfsgid",
    140: "_llseek",
    141: "getdents",
    142: "_newselect",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    164: "setresuid",
    165: "getresuid",
    166: "vm86",
    167: "query_module",
    168: "poll",
    169: "nfsservctl",
    170: "setresgid",
    171: "getresgid",
    172: "prctl",
    173: "rt_sigreturn",
    174: "rt_sigaction",
    175: "rt_sigprocmask",
    176: "rt_sigpending",
    177: "rt_sigtimedwait",
    178: "rt_sigqueueinfo",
    179: "rt_sigsuspend",
    180: "pread64",
    181: "pwrite64",
    182: "chown",
    183: "getcwd",
    184: "capget",
    185: "capset",
    186: "sigaltstack",
    187: "sendfile",
    188: "getpmsg",
    189: "putpmsg",
    190: "vfork",
    191: "ugetrlimit",
    192: "mmap2",
    193: "truncate64",
    194: "ftruncate64",
    195: "stat64",
    196: "lstat64",
    197: "fstat64",
    198: "lchown32",
    199: "getuid32",
    200: "getgid32",
    201: "geteuid32",
    202: "getegid32",
    203: "setreuid32",
    204: "setregid32",
    205: "getgroups32",
    206: "setgroups32",
    207: "fchown32",
    208: "setresuid32",
    209: "getresuid32",
    210: "setresgid32",
    211: "getresgid32",
    212: "chown32",
    213: "setuid32",
    214: "setgid32",
    215: "setfsuid32",
    216: "setfsgid32",
    217: "pivot_root",
    218: "mincore",
    219: "madvise",
    220: "getdents64",
    221: "fcntl64",
    224: "gettid",
    225: "readahead",
    226: "setxattr",
    227: "lsetxattr",
    228: "fsetxattr",
    229: "getxattr",
    230: "lgetxattr",
    231: "fgetxattr",
    232: "listxattr",
    233: "llistxattr",
    234: "flistxattr",
    235: "removexattr",
    236: "lremovexattr",
    237: "fremovexattr",
    238: "tkill",
    239: "sendfile64",
    240: "futex",
    241: "sched_setaffinity",
    242: "sched_getaffinity",
    243: "set_thread_area",
    244: "get_thread_area",
    245: "io_setup",
    246: "io_destroy",
    247: "io_getevents",
    248: "io_submit",
    249: "io_cancel",
    250: "fadvise64",
    252: "exit_group",
    253: "lookup_dcookie",
    254: "epoll_create",
    255: "epoll_ctl",
    256: "epoll_wait",
    257: "remap_file_pages",
    258: "set_tid_address",
    259: "timer_create",
    260: "timer_settime",
    261: "timer_gettime",
    262: "timer_getoverrun",
    263: "timer_delete",
    264: "clock_settime",
    265: "clock_gettime",
    266: "clock_getres",
    267: "clock_nanosleep",
    268: "statfs64",
    269: "fstatfs64",
    270: "tgkill",
    271: "utimes",
    272: "fadvise64_64",
    273: "vserver",
    274: "mbind",
    275: "get_mempolicy",
    276: "set_mempolicy",
    277: "mq_open",
    278: "mq_unlink",
    279: "mq_timedsend",
    280: "mq_timedreceive",
    281: "mq_notify",
    282: "mq_getsetattr",
    283: "kexec_load",
    284: "waitid",
    286: "add_key",
    287: "request_key",
    288: "keyctl",
    289: "ioprio_set",
    290: "ioprio_get",
    291: "inotify_init",
    292: "inotify_add_watch",
    293: "inotify_rm_watch",
    294: "migrate_pages",
    295: "openat",
    296: "mkdirat",
    297: "mknodat",
    298: "fchownat",
    299: "futimesat",
    300: "fstatat64",
    301: "unlinkat",
    302: "renameat",
    303: "linkat",
    304: "symlinkat",
    305: "readlinkat",
    306: "fchmodat",
    307: "faccessat",
    308: "pselect6",
    309: "ppoll",
    310: "unshare",
    311: "set_robust_list",
    312: "get_robust_list",
    313: "splice",
    314: "sync_file_range",
    315: "tee",
    316: "vmsplice",
    317: "move_pages",
    318: "getcpu",
    319: "epoll_pwait",
    320: "utimensat",
    321: "signalfd",
    322: "timerfd_create",
    323: "eventfd",
    324: "fallocate",
    325: "timerfd_settime",
    326: "timerfd_gettime",
    327: "signalfd4",
    328: "eventfd2",
    329: "epoll_create1",
    330: "dup3",
    331: "pipe2",
    332: "inotify_init1",
    333: "preadv",
    334: "pwritev",
    335: "rt_tgsigqueueinfo",
    336: "perf_event_open",
    337: "recvmmsg",
    338: "fanotify_init",
    339: "fanotify_mark",
    340: "prlimit64",
    341: "name_to_handle_at",
    342: "open_by_handle_at",
    343: "clock_adjtime",
    344: "syncfs",
    345: "sendmmsg",
    346: "setns",
    347: "process_vm_readv",
    348: "process_vm_writev",
    349: "kcmp",
    350: "finit_module",
    351: "sched_setattr",
    352: "sched_getattr",
    353: "renameat2",
    354: "seccomp",
    355: "getrandom",
    356: "memfd_create",
    357: "bpf",
    358: "execveat",
    359: "socket",
    360: "socketpair",
    361: "bind",
    362: "connect",
    363: "listen",
    364: "accept4",
    365: "getsockopt",
    366: "setsockopt",
    367: "getsockname",
    368: "getpeername",
    369: "sendto",
    370: "sendmsg",
    371: "recvfrom",
    372: "recvmsg",
    373: "shutdown",
    374: "userfaultfd",
    375: "membarrier",
    376: "mlock2",
    377: "copy_file_range",
    378: "preadv2",
    379: "pwritev2",
    380: "pkey_mprotect",
    381: "pkey_alloc",
    382: "pkey_free",
    383: "statx",
    384: "arch_prctl",
})

lib.add_number_mapping_from_dict("mips-n32", {
    6000: "read",
    6001: "write",
    6002: "open",
    6003: "close",
    6004: "stat",
    6005: "fstat",
    6006: "lstat",
    6007: "poll",
    6008: "lseek",
    6009: "mmap",
    6010: "mprotect",
    6011: "munmap",
    6012: "brk",
    6013: "rt_sigaction",
    6014: "rt_sigprocmask",
    6015: "ioctl",
    6016: "pread64",
    6017: "pwrite64",
    6018: "readv",
    6019: "writev",
    6020: "access",
    6021: "pipe",
    6022: "_newselect",
    6023: "sched_yield",
    6024: "mremap",
    6025: "msync",
    6026: "mincore",
    6027: "madvise",
    6028: "shmget",
    6029: "shmat",
    6030: "shmctl",
    6031: "dup",
    6032: "dup2",
    6033: "pause",
    6034: "nanosleep",
    6035: "getitimer",
    6036: "setitimer",
    6037: "alarm",
    6038: "getpid",
    6039: "sendfile",
    6040: "socket",
    6041: "connect",
    6042: "accept",
    6043: "sendto",
    6044: "recvfrom",
    6045: "sendmsg",
    6046: "recvmsg",
    6047: "shutdown",
    6048: "bind",
    6049: "listen",
    6050: "getsockname",
    6051: "getpeername",
    6052: "socketpair",
    6053: "setsockopt",
    6054: "getsockopt",
    6055: "clone",
    6056: "fork",
    6057: "execve",
    6058: "exit",
    6059: "wait4",
    6060: "kill",
    6061: "uname",
    6062: "semget",
    6063: "semop",
    6064: "semctl",
    6065: "shmdt",
    6066: "msgget",
    6067: "msgsnd",
    6068: "msgrcv",
    6069: "msgctl",
    6070: "fcntl",
    6071: "flock",
    6072: "fsync",
    6073: "fdatasync",
    6074: "truncate",
    6075: "ftruncate",
    6076: "getdents",
    6077: "getcwd",
    6078: "chdir",
    6079: "fchdir",
    6080: "rename",
    6081: "mkdir",
    6082: "rmdir",
    6083: "creat",
    6084: "link",
    6085: "unlink",
    6086: "symlink",
    6087: "readlink",
    6088: "chmod",
    6089: "fchmod",
    6090: "chown",
    6091: "fchown",
    6092: "lchown",
    6093: "umask",
    6094: "gettimeofday",
    6095: "getrlimit",
    6096: "getrusage",
    6097: "sysinfo",
    6098: "times",
    6099: "ptrace",
    6100: "getuid",
    6101: "syslog",
    6102: "getgid",
    6103: "setuid",
    6104: "setgid",
    6105: "geteuid",
    6106: "getegid",
    6107: "setpgid",
    6108: "getppid",
    6109: "getpgrp",
    6110: "setsid",
    6111: "setreuid",
    6112: "setregid",
    6113: "getgroups",
    6114: "setgroups",
    6115: "setresuid",
    6116: "getresuid",
    6117: "setresgid",
    6118: "getresgid",
    6119: "getpgid",
    6120: "setfsuid",
    6121: "setfsgid",
    6122: "getsid",
    6123: "capget",
    6124: "capset",
    6125: "rt_sigpending",
    6126: "rt_sigtimedwait",
    6127: "rt_sigqueueinfo",
    6128: "rt_sigsuspend",
    6129: "sigaltstack",
    6130: "utime",
    6131: "mknod",
    6132: "personality",
    6133: "ustat",
    6134: "statfs",
    6135: "fstatfs",
    6136: "sysfs",
    6137: "getpriority",
    6138: "setpriority",
    6139: "sched_setparam",
    6140: "sched_getparam",
    6141: "sched_setscheduler",
    6142: "sched_getscheduler",
    6143: "sched_get_priority_max",
    6144: "sched_get_priority_min",
    6145: "sched_rr_get_interval",
    6146: "mlock",
    6147: "munlock",
    6148: "mlockall",
    6149: "munlockall",
    6150: "vhangup",
    6151: "pivot_root",
    6152: "_sysctl",
    6153: "prctl",
    6154: "adjtimex",
    6155: "setrlimit",
    6156: "chroot",
    6157: "sync",
    6158: "acct",
    6159: "settimeofday",
    6160: "mount",
    6161: "umount2",
    6162: "swapon",
    6163: "swapoff",
    6164: "reboot",
    6165: "sethostname",
    6166: "setdomainname",
    6167: "create_module",
    6168: "init_module",
    6169: "delete_module",
    6170: "get_kernel_syms",
    6171: "query_module",
    6172: "quotactl",
    6173: "nfsservctl",
    6174: "getpmsg",
    6175: "putpmsg",
    6176: "afs_syscall",
    6177: "reserved177",
    6178: "gettid",
    6179: "readahead",
    6180: "setxattr",
    6181: "lsetxattr",
    6182: "fsetxattr",
    6183: "getxattr",
    6184: "lgetxattr",
    6185: "fgetxattr",
    6186: "listxattr",
    6187: "llistxattr",
    6188: "flistxattr",
    6189: "removexattr",
    6190: "lremovexattr",
    6191: "fremovexattr",
    6192: "tkill",
    6193: "reserved193",
    6194: "futex",
    6195: "sched_setaffinity",
    6196: "sched_getaffinity",
    6197: "cacheflush",
    6198: "cachectl",
    6199: "sysmips",
    6200: "io_setup",
    6201: "io_destroy",
    6202: "io_getevents",
    6203: "io_submit",
    6204: "io_cancel",
    6205: "exit_group",
    6206: "lookup_dcookie",
    6207: "epoll_create",
    6208: "epoll_ctl",
    6209: "epoll_wait",
    6210: "remap_file_pages",
    6211: "rt_sigreturn",
    6212: "fcntl64",
    6213: "set_tid_address",
    6214: "restart_syscall",
    6215: "semtimedop",
    6216: "fadvise64",
    6217: "statfs64",
    6218: "fstatfs64",
    6219: "sendfile64",
    6220: "timer_create",
    6221: "timer_settime",
    6222: "timer_gettime",
    6223: "timer_getoverrun",
    6224: "timer_delete",
    6225: "clock_settime",
    6226: "clock_gettime",
    6227: "clock_getres",
    6228: "clock_nanosleep",
    6229: "tgkill",
    6230: "utimes",
    6231: "mbind",
    6232: "get_mempolicy",
    6233: "set_mempolicy",
    6234: "mq_open",
    6235: "mq_unlink",
    6236: "mq_timedsend",
    6237: "mq_timedreceive",
    6238: "mq_notify",
    6239: "mq_getsetattr",
    6240: "vserver",
    6241: "waitid",
    6243: "add_key",
    6244: "request_key",
    6245: "keyctl",
    6246: "set_thread_area",
    6247: "inotify_init",
    6248: "inotify_add_watch",
    6249: "inotify_rm_watch",
    6250: "migrate_pages",
    6251: "openat",
    6252: "mkdirat",
    6253: "mknodat",
    6254: "fchownat",
    6255: "futimesat",
    6256: "newfstatat",
    6257: "unlinkat",
    6258: "renameat",
    6259: "linkat",
    6260: "symlinkat",
    6261: "readlinkat",
    6262: "fchmodat",
    6263: "faccessat",
    6264: "pselect6",
    6265: "ppoll",
    6266: "unshare",
    6267: "splice",
    6268: "sync_file_range",
    6269: "tee",
    6270: "vmsplice",
    6271: "move_pages",
    6272: "set_robust_list",
    6273: "get_robust_list",
    6274: "kexec_load",
    6275: "getcpu",
    6276: "epoll_pwait",
    6277: "ioprio_set",
    6278: "ioprio_get",
    6279: "utimensat",
    6280: "signalfd",
    6281: "timerfd",
    6282: "eventfd",
    6283: "fallocate",
    6284: "timerfd_create",
    6285: "timerfd_gettime",
    6286: "timerfd_settime",
    6287: "signalfd4",
    6288: "eventfd2",
    6289: "epoll_create1",
    6290: "dup3",
    6291: "pipe2",
    6292: "inotify_init1",
    6293: "preadv",
    6294: "pwritev",
    6295: "rt_tgsigqueueinfo",
    6296: "perf_event_open",
    6297: "accept4",
    6298: "recvmmsg",
    6299: "getdents64",
    6300: "fanotify_init",
    6301: "fanotify_mark",
    6302: "prlimit64",
})

lib.add_number_mapping_from_dict("mips-n64", {
    5000: "read",
    5001: "write",
    5002: "open",
    5003: "close",
    5004: "stat",
    5005: "fstat",
    5006: "lstat",
    5007: "poll",
    5008: "lseek",
    5009: "mmap",
    5010: "mprotect",
    5011: "munmap",
    5012: "brk",
    5013: "rt_sigaction",
    5014: "rt_sigprocmask",
    5015: "ioctl",
    5016: "pread64",
    5017: "pwrite64",
    5018: "readv",
    5019: "writev",
    5020: "access",
    5021: "pipe",
    5022: "_newselect",
    5023: "sched_yield",
    5024: "mremap",
    5025: "msync",
    5026: "mincore",
    5027: "madvise",
    5028: "shmget",
    5029: "shmat",
    5030: "shmctl",
    5031: "dup",
    5032: "dup2",
    5033: "pause",
    5034: "nanosleep",
    5035: "getitimer",
    5036: "setitimer",
    5037: "alarm",
    5038: "getpid",
    5039: "sendfile",
    5040: "socket",
    5041: "connect",
    5042: "accept",
    5043: "sendto",
    5044: "recvfrom",
    5045: "sendmsg",
    5046: "recvmsg",
    5047: "shutdown",
    5048: "bind",
    5049: "listen",
    5050: "getsockname",
    5051: "getpeername",
    5052: "socketpair",
    5053: "setsockopt",
    5054: "getsockopt",
    5055: "clone",
    5056: "fork",
    5057: "execve",
    5058: "exit",
    5059: "wait4",
    5060: "kill",
    5061: "uname",
    5062: "semget",
    5063: "semop",
    5064: "semctl",
    5065: "shmdt",
    5066: "msgget",
    5067: "msgsnd",
    5068: "msgrcv",
    5069: "msgctl",
    5070: "fcntl",
    5071: "flock",
    5072: "fsync",
    5073: "fdatasync",
    5074: "truncate",
    5075: "ftruncate",
    5076: "getdents",
    5077: "getcwd",
    5078: "chdir",
    5079: "fchdir",
    5080: "rename",
    5081: "mkdir",
    5082: "rmdir",
    5083: "creat",
    5084: "link",
    5085: "unlink",
    5086: "symlink",
    5087: "readlink",
    5088: "chmod",
    5089: "fchmod",
    5090: "chown",
    5091: "fchown",
    5092: "lchown",
    5093: "umask",
    5094: "gettimeofday",
    5095: "getrlimit",
    5096: "getrusage",
    5097: "sysinfo",
    5098: "times",
    5099: "ptrace",
    5100: "getuid",
    5101: "syslog",
    5102: "getgid",
    5103: "setuid",
    5104: "setgid",
    5105: "geteuid",
    5106: "getegid",
    5107: "setpgid",
    5108: "getppid",
    5109: "getpgrp",
    5110: "setsid",
    5111: "setreuid",
    5112: "setregid",
    5113: "getgroups",
    5114: "setgroups",
    5115: "setresuid",
    5116: "getresuid",
    5117: "setresgid",
    5118: "getresgid",
    5119: "getpgid",
    5120: "setfsuid",
    5121: "setfsgid",
    5122: "getsid",
    5123: "capget",
    5124: "capset",
    5125: "rt_sigpending",
    5126: "rt_sigtimedwait",
    5127: "rt_sigqueueinfo",
    5128: "rt_sigsuspend",
    5129: "sigaltstack",
    5130: "utime",
    5131: "mknod",
    5132: "personality",
    5133: "ustat",
    5134: "statfs",
    5135: "fstatfs",
    5136: "sysfs",
    5137: "getpriority",
    5138: "setpriority",
    5139: "sched_setparam",
    5140: "sched_getparam",
    5141: "sched_setscheduler",
    5142: "sched_getscheduler",
    5143: "sched_get_priority_max",
    5144: "sched_get_priority_min",
    5145: "sched_rr_get_interval",
    5146: "mlock",
    5147: "munlock",
    5148: "mlockall",
    5149: "munlockall",
    5150: "vhangup",
    5151: "pivot_root",
    5152: "_sysctl",
    5153: "prctl",
    5154: "adjtimex",
    5155: "setrlimit",
    5156: "chroot",
    5157: "sync",
    5158: "acct",
    5159: "settimeofday",
    5160: "mount",
    5161: "umount2",
    5162: "swapon",
    5163: "swapoff",
    5164: "reboot",
    5165: "sethostname",
    5166: "setdomainname",
    5167: "create_module",
    5168: "init_module",
    5169: "delete_module",
    5170: "get_kernel_syms",
    5171: "query_module",
    5172: "quotactl",
    5173: "nfsservctl",
    5174: "getpmsg",
    5175: "putpmsg",
    5176: "afs_syscall",
    5178: "gettid",
    5179: "readahead",
    5180: "setxattr",
    5181: "lsetxattr",
    5182: "fsetxattr",
    5183: "getxattr",
    5184: "lgetxattr",
    5185: "fgetxattr",
    5186: "listxattr",
    5187: "llistxattr",
    5188: "flistxattr",
    5189: "removexattr",
    5190: "lremovexattr",
    5191: "fremovexattr",
    5192: "tkill",
    5194: "futex",
    5195: "sched_setaffinity",
    5196: "sched_getaffinity",
    5197: "cacheflush",
    5198: "cachectl",
    5199: "sysmips",
    5200: "io_setup",
    5201: "io_destroy",
    5202: "io_getevents",
    5203: "io_submit",
    5204: "io_cancel",
    5205: "exit_group",
    5206: "lookup_dcookie",
    5207: "epoll_create",
    5208: "epoll_ctl",
    5209: "epoll_wait",
    5210: "remap_file_pages",
    5211: "rt_sigreturn",
    5212: "set_tid_address",
    5213: "restart_syscall",
    5214: "semtimedop",
    5215: "fadvise64",
    5216: "timer_create",
    5217: "timer_settime",
    5218: "timer_gettime",
    5219: "timer_getoverrun",
    5220: "timer_delete",
    5221: "clock_settime",
    5222: "clock_gettime",
    5223: "clock_getres",
    5224: "clock_nanosleep",
    5225: "tgkill",
    5226: "utimes",
    5227: "mbind",
    5228: "get_mempolicy",
    5229: "set_mempolicy",
    5230: "mq_open",
    5231: "mq_unlink",
    5232: "mq_timedsend",
    5233: "mq_timedreceive",
    5234: "mq_notify",
    5235: "mq_getsetattr",
    5236: "vserver",
    5237: "waitid",
    5239: "add_key",
    5240: "request_key",
    5241: "keyctl",
    5242: "set_thread_area",
    5243: "inotify_init",
    5244: "inotify_add_watch",
    5245: "inotify_rm_watch",
    5246: "migrate_pages",
    5247: "openat",
    5248: "mkdirat",
    5249: "mknodat",
    5250: "fchownat",
    5251: "futimesat",
    5252: "newfstatat",
    5253: "unlinkat",
    5254: "renameat",
    5255: "linkat",
    5256: "symlinkat",
    5257: "readlinkat",
    5258: "fchmodat",
    5259: "faccessat",
    5260: "pselect6",
    5261: "ppoll",
    5262: "unshare",
    5263: "splice",
    5264: "sync_file_range",
    5265: "tee",
    5266: "vmsplice",
    5267: "move_pages",
    5268: "set_robust_list",
    5269: "get_robust_list",
    5270: "kexec_load",
    5271: "getcpu",
    5272: "epoll_pwait",
    5273: "ioprio_set",
    5274: "ioprio_get",
    5275: "utimensat",
    5276: "signalfd",
    5277: "timerfd",
    5278: "eventfd",
    5279: "fallocate",
    5280: "timerfd_create",
    5281: "timerfd_gettime",
    5282: "timerfd_settime",
    5283: "signalfd4",
    5284: "eventfd2",
    5285: "epoll_create1",
    5286: "dup3",
    5287: "pipe2",
    5288: "inotify_init1",
    5289: "preadv",
    5290: "pwritev",
    5291: "rt_tgsigqueueinfo",
    5292: "perf_event_open",
    5293: "accept4",
    5294: "recvmmsg",
    5295: "fanotify_init",
    5296: "fanotify_mark",
    5297: "prlimit64",
})

lib.add_number_mapping_from_dict("mips-o32", {
    4000: "syscall",
    4001: "exit",
    4002: "fork",
    4003: "read",
    4004: "write",
    4005: "open",
    4006: "close",
    4007: "waitpid",
    4008: "creat",
    4009: "link",
    4010: "unlink",
    4011: "execve",
    4012: "chdir",
    4013: "time",
    4014: "mknod",
    4015: "chmod",
    4016: "lchown",
    4017: "break",
    4019: "lseek",
    4020: "getpid",
    4021: "mount",
    4022: "umount",
    4023: "setuid",
    4024: "getuid",
    4025: "stime",
    4026: "ptrace",
    4027: "alarm",
    4029: "pause",
    4030: "utime",
    4031: "stty",
    4032: "gtty",
    4033: "access",
    4034: "nice",
    4035: "ftime",
    4036: "sync",
    4037: "kill",
    4038: "rename",
    4039: "mkdir",
    4040: "rmdir",
    4041: "dup",
    4042: "pipe",
    4043: "times",
    4044: "prof",
    4045: "brk",
    4046: "setgid",
    4047: "getgid",
    4048: "signal",
    4049: "geteuid",
    4050: "getegid",
    4051: "acct",
    4052: "umount2",
    4053: "lock",
    4054: "ioctl",
    4055: "fcntl",
    4056: "mpx",
    4057: "setpgid",
    4058: "ulimit",
    4060: "umask",
    4061: "chroot",
    4062: "ustat",
    4063: "dup2",
    4064: "getppid",
    4065: "getpgrp",
    4066: "setsid",
    4067: "sigaction",
    4068: "sgetmask",
    4069: "ssetmask",
    4070: "setreuid",
    4071: "setregid",
    4072: "sigsuspend",
    4073: "sigpending",
    4074: "sethostname",
    4075: "setrlimit",
    4076: "getrlimit",
    4077: "getrusage",
    4078: "gettimeofday",
    4079: "settimeofday",
    4080: "getgroups",
    4081: "setgroups",
    4083: "symlink",
    4085: "readlink",
    4086: "uselib",
    4087: "swapon",
    4088: "reboot",
    4089: "readdir",
    4090: "mmap",
    4091: "munmap",
    4092: "truncate",
    4093: "ftruncate",
    4094: "fchmod",
    4095: "fchown",
    4096: "getpriority",
    4097: "setpriority",
    4098: "profil",
    4099: "statfs",
    4100: "fstatfs",
    4101: "ioperm",
    4102: "socketcall",
    4103: "syslog",
    4104: "setitimer",
    4105: "getitimer",
    4106: "stat",
    4107: "lstat",
    4108: "fstat",
    4110: "iopl",
    4111: "vhangup",
    4112: "idle",
    4113: "vm86",
    4114: "wait4",
    4115: "swapoff",
    4116: "sysinfo",
    4117: "ipc",
    4118: "fsync",
    4119: "sigreturn",
    4120: "clone",
    4121: "setdomainname",
    4122: "uname",
    4123: "modify_ldt",
    4124: "adjtimex",
    4125: "mprotect",
    4126: "sigprocmask",
    4127: "create_module",
    4128: "init_module",
    4129: "delete_module",
    4130: "get_kernel_syms",
    4131: "quotactl",
    4132: "getpgid",
    4133: "fchdir",
    4134: "bdflush",
    4135: "sysfs",
    4136: "personality",
    4137: "afs_syscall",
    4138: "setfsuid",
    4139: "setfsgid",
    4140: "_llseek",
    4141: "getdents",
    4142: "_newselect",
    4143: "flock",
    4144: "msync",
    4145: "readv",
    4146: "writev",
    4147: "cacheflush",
    4148: "cachectl",
    4149: "sysmips",
    4151: "getsid",
    4152: "fdatasync",
    4153: "_sysctl",
    4154: "mlock",
    4155: "munlock",
    4156: "mlockall",
    4157: "munlockall",
    4158: "sched_setparam",
    4159: "sched_getparam",
    4160: "sched_setscheduler",
    4161: "sched_getscheduler",
    4162: "sched_yield",
    4163: "sched_get_priority_max",
    4164: "sched_get_priority_min",
    4165: "sched_rr_get_interval",
    4166: "nanosleep",
    4167: "mremap",
    4168: "accept",
    4169: "bind",
    4170: "connect",
    4171: "getpeername",
    4172: "getsockname",
    4173: "getsockopt",
    4174: "listen",
    4175: "recv",
    4176: "recvfrom",
    4177: "recvmsg",
    4178: "send",
    4179: "sendmsg",
    4180: "sendto",
    4181: "setsockopt",
    4182: "shutdown",
    4183: "socket",
    4184: "socketpair",
    4185: "setresuid",
    4186: "getresuid",
    4187: "query_module",
    4188: "poll",
    4189: "nfsservctl",
    4190: "setresgid",
    4191: "getresgid",
    4192: "prctl",
    4193: "rt_sigreturn",
    4194: "rt_sigaction",
    4195: "rt_sigprocmask",
    4196: "rt_sigpending",
    4197: "rt_sigtimedwait",
    4198: "rt_sigqueueinfo",
    4199: "rt_sigsuspend",
    4200: "pread64",
    4201: "pwrite64",
    4202: "chown",
    4203: "getcwd",
    4204: "capget",
    4205: "capset",
    4206: "sigaltstack",
    4207: "sendfile",
    4208: "getpmsg",
    4209: "putpmsg",
    4210: "mmap2",
    4211: "truncate64",
    4212: "ftruncate64",
    4213: "stat64",
    4214: "lstat64",
    4215: "fstat64",
    4216: "pivot_root",
    4217: "mincore",
    4218: "madvise",
    4219: "getdents64",
    4220: "fcntl64",
    4222: "gettid",
    4223: "readahead",
    4224: "setxattr",
    4225: "lsetxattr",
    4226: "fsetxattr",
    4227: "getxattr",
    4228: "lgetxattr",
    4229: "fgetxattr",
    4230: "listxattr",
    4231: "llistxattr",
    4232: "flistxattr",
    4233: "removexattr",
    4234: "lremovexattr",
    4235: "fremovexattr",
    4236: "tkill",
    4237: "sendfile64",
    4238: "futex",
    4239: "sched_setaffinity",
    4240: "sched_getaffinity",
    4241: "io_setup",
    4242: "io_destroy",
    4243: "io_getevents",
    4244: "io_submit",
    4245: "io_cancel",
    4246: "exit_group",
    4247: "lookup_dcookie",
    4248: "epoll_create",
    4249: "epoll_ctl",
    4250: "epoll_wait",
    4251: "remap_file_pages",
    4252: "set_tid_address",
    4253: "restart_syscall",
    4254: "fadvise64",
    4255: "statfs64",
    4256: "fstatfs64",
    4257: "timer_create",
    4258: "timer_settime",
    4259: "timer_gettime",
    4260: "timer_getoverrun",
    4261: "timer_delete",
    4262: "clock_settime",
    4263: "clock_gettime",
    4264: "clock_getres",
    4265: "clock_nanosleep",
    4266: "tgkill",
    4267: "utimes",
    4268: "mbind",
    4269: "get_mempolicy",
    4270: "set_mempolicy",
    4271: "mq_open",
    4272: "mq_unlink",
    4273: "mq_timedsend",
    4274: "mq_timedreceive",
    4275: "mq_notify",
    4276: "mq_getsetattr",
    4277: "vserver",
    4278: "waitid",
    4280: "add_key",
    4281: "request_key",
    4282: "keyctl",
    4283: "set_thread_area",
    4284: "inotify_init",
    4285: "inotify_add_watch",
    4286: "inotify_rm_watch",
    4287: "migrate_pages",
    4288: "openat",
    4289: "mkdirat",
    4290: "mknodat",
    4291: "fchownat",
    4292: "futimesat",
    4293: "fstatat64",
    4294: "unlinkat",
    4295: "renameat",
    4296: "linkat",
    4297: "symlinkat",
    4298: "readlinkat",
    4299: "fchmodat",
    4300: "faccessat",
    4301: "pselect6",
    4302: "ppoll",
    4303: "unshare",
    4304: "splice",
    4305: "sync_file_range",
    4306: "tee",
    4307: "vmsplice",
    4308: "move_pages",
    4309: "set_robust_list",
    4310: "get_robust_list",
    4311: "kexec_load",
    4312: "getcpu",
    4313: "epoll_pwait",
    4314: "ioprio_set",
    4315: "ioprio_get",
    4316: "utimensat",
    4317: "signalfd",
    4318: "timerfd",
    4319: "eventfd",
    4320: "fallocate",
    4321: "timerfd_create",
    4322: "timerfd_gettime",
    4323: "timerfd_settime",
    4324: "signalfd4",
    4325: "eventfd2",
    4326: "epoll_create1",
    4327: "dup3",
    4328: "pipe2",
    4329: "inotify_init1",
    4330: "preadv",
    4331: "pwritev",
    4332: "rt_tgsigqueueinfo",
    4333: "perf_event_open",
    4334: "accept4",
    4335: "recvmmsg",
    4336: "fanotify_init",
    4337: "fanotify_mark",
    4338: "prlimit64",
})

lib.add_number_mapping_from_dict("ppc", {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "waitpid",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    13: "time",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "break",
    18: "oldstat",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    23: "setuid",
    24: "getuid",
    25: "stime",
    26: "ptrace",
    27: "alarm",
    28: "oldfstat",
    29: "pause",
    30: "utime",
    31: "stty",
    32: "gtty",
    33: "access",
    34: "nice",
    35: "ftime",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    44: "prof",
    45: "brk",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "umount2",
    53: "lock",
    54: "ioctl",
    55: "fcntl",
    56: "mpx",
    57: "setpgid",
    58: "ulimit",
    59: "oldolduname",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    68: "sgetmask",
    69: "ssetmask",
    70: "setreuid",
    71: "setregid",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    76: "getrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    80: "getgroups",
    81: "setgroups",
    82: "select",
    83: "symlink",
    84: "oldlstat",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    95: "fchown",
    96: "getpriority",
    97: "setpriority",
    98: "profil",
    99: "statfs",
    100: "fstatfs",
    101: "ioperm",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    109: "olduname",
    110: "iopl",
    111: "vhangup",
    112: "idle",
    113: "vm86",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    123: "modify_ldt",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    138: "setfsuid",
    139: "setfsgid",
    140: "_llseek",
    141: "getdents",
    142: "_newselect",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    164: "setresuid",
    165: "getresuid",
    166: "query_module",
    167: "poll",
    168: "nfsservctl",
    169: "setresgid",
    170: "getresgid",
    171: "prctl",
    172: "rt_sigreturn",
    173: "rt_sigaction",
    174: "rt_sigprocmask",
    175: "rt_sigpending",
    176: "rt_sigtimedwait",
    177: "rt_sigqueueinfo",
    178: "rt_sigsuspend",
    179: "pread64",
    180: "pwrite64",
    181: "chown",
    182: "getcwd",
    183: "capget",
    184: "capset",
    185: "sigaltstack",
    186: "sendfile",
    187: "getpmsg",
    188: "putpmsg",
    189: "vfork",
    190: "ugetrlimit",
    191: "readahead",
    192: "mmap2",
    193: "truncate64",
    194: "ftruncate64",
    195: "stat64",
    196: "lstat64",
    197: "fstat64",
    198: "pciconfig_read",
    199: "pciconfig_write",
    200: "pciconfig_iobase",
    201: "multiplexer",
    202: "getdents64",
    203: "pivot_root",
    204: "fcntl64",
    205: "madvise",
    206: "mincore",
    207: "gettid",
    208: "tkill",
    209: "setxattr",
    210: "lsetxattr",
    211: "fsetxattr",
    212: "getxattr",
    213: "lgetxattr",
    214: "fgetxattr",
    215: "listxattr",
    216: "llistxattr",
    217: "flistxattr",
    218: "removexattr",
    219: "lremovexattr",
    220: "fremovexattr",
    221: "futex",
    222: "sched_setaffinity",
    223: "sched_getaffinity",
    225: "tuxcall",
    226: "sendfile64",
    227: "io_setup",
    228: "io_destroy",
    229: "io_getevents",
    230: "io_submit",
    231: "io_cancel",
    232: "set_tid_address",
    233: "fadvise64",
    234: "exit_group",
    235: "lookup_dcookie",
    236: "epoll_create",
    237: "epoll_ctl",
    238: "epoll_wait",
    239: "remap_file_pages",
    240: "timer_create",
    241: "timer_settime",
    242: "timer_gettime",
    243: "timer_getoverrun",
    244: "timer_delete",
    245: "clock_settime",
    246: "clock_gettime",
    247: "clock_getres",
    248: "clock_nanosleep",
    249: "swapcontext",
    250: "tgkill",
    251: "utimes",
    252: "statfs64",
    253: "fstatfs64",
    254: "fadvise64_64",
    255: "rtas",
    256: "sys_debug_setcontext",
    259: "mbind",
    260: "get_mempolicy",
    261: "set_mempolicy",
    262: "mq_open",
    263: "mq_unlink",
    264: "mq_timedsend",
    265: "mq_timedreceive",
    266: "mq_notify",
    267: "mq_getsetattr",
    268: "kexec_load",
    269: "add_key",
    270: "request_key",
    271: "keyctl",
    272: "waitid",
    273: "ioprio_set",
    274: "ioprio_get",
    275: "inotify_init",
    276: "inotify_add_watch",
    277: "inotify_rm_watch",
    278: "spu_run",
    279: "spu_create",
    280: "pselect6",
    281: "ppoll",
    282: "unshare",
    286: "openat",
    287: "mkdirat",
    288: "mknodat",
    289: "fchownat",
    290: "futimesat",
    291: "fstatat64",
    292: "unlinkat",
    293: "renameat",
    294: "linkat",
    295: "symlinkat",
    296: "readlinkat",
    297: "fchmodat",
    298: "faccessat",
})

lib.add_number_mapping_from_dict("ppc64", {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "waitpid",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    13: "time",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "break",
    18: "oldstat",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    23: "setuid",
    24: "getuid",
    25: "stime",
    26: "ptrace",
    27: "alarm",
    28: "oldfstat",
    29: "pause",
    30: "utime",
    31: "stty",
    32: "gtty",
    33: "access",
    34: "nice",
    35: "ftime",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    44: "prof",
    45: "brk",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "umount2",
    53: "lock",
    54: "ioctl",
    55: "fcntl",
    56: "mpx",
    57: "setpgid",
    58: "ulimit",
    59: "oldolduname",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    68: "sgetmask",
    69: "ssetmask",
    70: "setreuid",
    71: "setregid",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    76: "getrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    80: "getgroups",
    81: "setgroups",
    82: "select",
    83: "symlink",
    84: "oldlstat",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    95: "fchown",
    96: "getpriority",
    97: "setpriority",
    98: "profil",
    99: "statfs",
    100: "fstatfs",
    101: "ioperm",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    109: "olduname",
    110: "iopl",
    111: "vhangup",
    112: "idle",
    113: "vm86",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    123: "modify_ldt",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    138: "setfsuid",
    139: "setfsgid",
    140: "_llseek",
    141: "getdents",
    142: "_newselect",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    164: "setresuid",
    165: "getresuid",
    166: "query_module",
    167: "poll",
    168: "nfsservctl",
    169: "setresgid",
    170: "getresgid",
    171: "prctl",
    172: "rt_sigreturn",
    173: "rt_sigaction",
    174: "rt_sigprocmask",
    175: "rt_sigpending",
    176: "rt_sigtimedwait",
    177: "rt_sigqueueinfo",
    178: "rt_sigsuspend",
    179: "pread64",
    180: "pwrite64",
    181: "chown",
    182: "getcwd",
    183: "capget",
    184: "capset",
    185: "sigaltstack",
    186: "sendfile",
    187: "getpmsg",
    188: "putpmsg",
    189: "vfork",
    190: "ugetrlimit",
    191: "readahead",
    198: "pciconfig_read",
    199: "pciconfig_write",
    200: "pciconfig_iobase",
    201: "multiplexer",
    202: "getdents64",
    203: "pivot_root",
    205: "madvise",
    206: "mincore",
    207: "gettid",
    208: "tkill",
    209: "setxattr",
    210: "lsetxattr",
    211: "fsetxattr",
    212: "getxattr",
    213: "lgetxattr",
    214: "fgetxattr",
    215: "listxattr",
    216: "llistxattr",
    217: "flistxattr",
    218: "removexattr",
    219: "lremovexattr",
    220: "fremovexattr",
    221: "futex",
    222: "sched_setaffinity",
    223: "sched_getaffinity",
    225: "tuxcall",
    227: "io_setup",
    228: "io_destroy",
    229: "io_getevents",
    230: "io_submit",
    231: "io_cancel",
    232: "set_tid_address",
    233: "fadvise64",
    234: "exit_group",
    235: "lookup_dcookie",
    236: "epoll_create",
    237: "epoll_ctl",
    238: "epoll_wait",
    239: "remap_file_pages",
    240: "timer_create",
    241: "timer_settime",
    242: "timer_gettime",
    243: "timer_getoverrun",
    244: "timer_delete",
    245: "clock_settime",
    246: "clock_gettime",
    247: "clock_getres",
    248: "clock_nanosleep",
    249: "swapcontext",
    250: "tgkill",
    251: "utimes",
    252: "statfs64",
    253: "fstatfs64",
    255: "rtas",
    256: "sys_debug_setcontext",
    259: "mbind",
    260: "get_mempolicy",
    261: "set_mempolicy",
    262: "mq_open",
    263: "mq_unlink",
    264: "mq_timedsend",
    265: "mq_timedreceive",
    266: "mq_notify",
    267: "mq_getsetattr",
    268: "kexec_load",
    269: "add_key",
    270: "request_key",
    271: "keyctl",
    272: "waitid",
    273: "ioprio_set",
    274: "ioprio_get",
    275: "inotify_init",
    276: "inotify_add_watch",
    277: "inotify_rm_watch",
    278: "spu_run",
    279: "spu_create",
    280: "pselect6",
    281: "ppoll",
    282: "unshare",
    286: "unlinkat",
    287: "renameat",
    288: "linkat",
    289: "symlinkat",
    290: "readlinkat",
    291: "fchmodat",
    292: "faccessat",
})

lib.add_number_mapping_from_dict("s390", {
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "restart_syscall",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    13: "time",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    23: "setuid",
    24: "getuid",
    25: "stime",
    26: "ptrace",
    27: "alarm",
    29: "pause",
    30: "utime",
    33: "access",
    34: "nice",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    45: "brk",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "umount2",
    54: "ioctl",
    55: "fcntl",
    57: "setpgid",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    70: "setreuid",
    71: "setregid",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    76: "getrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    80: "getgroups",
    81: "setgroups",
    83: "symlink",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    95: "fchown",
    96: "getpriority",
    97: "setpriority",
    99: "statfs",
    100: "fstatfs",
    101: "ioperm",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    110: "lookup_dcookie",
    111: "vhangup",
    112: "idle",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    138: "setfsuid",
    139: "setfsgid",
    140: "_llseek",
    141: "getdents",
    142: "_newselect",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    164: "setresuid",
    165: "getresuid",
    167: "query_module",
    168: "poll",
    169: "nfsservctl",
    170: "setresgid",
    171: "getresgid",
    172: "prctl",
    173: "rt_sigreturn",
    174: "rt_sigaction",
    175: "rt_sigprocmask",
    176: "rt_sigpending",
    177: "rt_sigtimedwait",
    178: "rt_sigqueueinfo",
    179: "rt_sigsuspend",
    180: "pread64",
    181: "pwrite64",
    182: "chown",
    183: "getcwd",
    184: "capget",
    185: "capset",
    186: "sigaltstack",
    187: "sendfile",
    188: "getpmsg",
    189: "putpmsg",
    190: "vfork",
    191: "ugetrlimit",
    192: "mmap2",
    193: "truncate64",
    194: "ftruncate64",
    195: "stat64",
    196: "lstat64",
    197: "fstat64",
    198: "lchown32",
    199: "getuid32",
    200: "getgid32",
    201: "geteuid32",
    202: "getegid32",
    203: "setreuid32",
    204: "setregid32",
    205: "getgroups32",
    206: "setgroups32",
    207: "fchown32",
    208: "setresuid32",
    209: "getresuid32",
    210: "setresgid32",
    211: "getresgid32",
    212: "chown32",
    213: "setuid32",
    214: "setgid32",
    215: "setfsuid32",
    216: "setfsgid32",
    217: "pivot_root",
    218: "mincore",
    219: "madvise",
    220: "getdents64",
    221: "fcntl64",
    222: "readahead",
    223: "sendfile64",
    224: "setxattr",
    225: "lsetxattr",
    226: "fsetxattr",
    227: "getxattr",
    228: "lgetxattr",
    229: "fgetxattr",
    230: "listxattr",
    231: "llistxattr",
    232: "flistxattr",
    233: "removexattr",
    234: "lremovexattr",
    235: "fremovexattr",
    236: "gettid",
    237: "tkill",
    238: "futex",
    239: "sched_setaffinity",
    240: "sched_getaffinity",
    241: "tgkill",
    243: "io_setup",
    244: "io_destroy",
    245: "io_getevents",
    246: "io_submit",
    247: "io_cancel",
    248: "exit_group",
    249: "epoll_create",
    250: "epoll_ctl",
    251: "epoll_wait",
    252: "set_tid_address",
    253: "fadvise64",
    254: "timer_create",
    255: "timer_settime",
    256: "timer_gettime",
    257: "timer_getoverrun",
    258: "timer_delete",
    259: "clock_settime",
    260: "clock_gettime",
    261: "clock_getres",
    262: "clock_nanosleep",
    264: "fadvise64_64",
    265: "statfs64",
    266: "fstatfs64",
    267: "remap_file_pages",
    268: "mbind",
    269: "get_mempolicy",
    270: "set_mempolicy",
    271: "mq_open",
    272: "mq_unlink",
    273: "mq_timedsend",
    274: "mq_timedreceive",
    275: "mq_notify",
    276: "mq_getsetattr",
    277: "kexec_load",
    278: "add_key",
    279: "request_key",
    280: "keyctl",
    281: "waitid",
    282: "ioprio_set",
    283: "ioprio_get",
    284: "inotify_init",
    285: "inotify_add_watch",
    286: "inotify_rm_watch",
    287: "migrate_pages",
    288: "openat",
    289: "mkdirat",
    290: "mknodat",
    291: "fchownat",
    292: "futimesat",
    293: "fstatat64",
    294: "unlinkat",
    295: "renameat",
    296: "linkat",
    297: "symlinkat",
    298: "readlinkat",
    299: "fchmodat",
    300: "faccessat",
    301: "pselect6",
    302: "ppoll",
    303: "unshare",
    304: "set_robust_list",
    305: "get_robust_list",
    306: "splice",
    307: "sync_file_range",
    308: "tee",
    309: "vmsplice",
    310: "move_pages",
    311: "getcpu",
    312: "epoll_pwait",
    313: "utimes",
    314: "fallocate",
    315: "utimensat",
    316: "signalfd",
    317: "timerfd",
    318: "eventfd",
    319: "timerfd_create",
    320: "timerfd_settime",
    321: "timerfd_gettime",
    322: "signalfd4",
    323: "eventfd2",
    324: "inotify_init1",
    325: "pipe2",
    326: "dup3",
    327: "epoll_create1",
    330: "rt_tgsigqueueinfo",
    331: "perf_event_open",
    332: "fanotify_init",
    333: "fanotify_mark",
    334: "prlimit64",
    335: "name_to_handle_at",
    336: "open_by_handle_at",
    337: "clock_adjtime",
    338: "syncfs",
    339: "setns",
    340: "process_vm_readv",
    341: "process_vm_writev",
    342: "s390_runtime_instr",
    343: "kcmp",
    344: "finit_module",
    345: "sched_setattr",
    346: "sched_getattr",
    347: "renameat2",
    348: "seccomp",
    349: "getrandom",
    350: "memfd_create",
    351: "bpf",
    352: "s390_pci_mmio_write",
    353: "s390_pci_mmio_read",
    354: "execveat",
    355: "userfaultfd",
    356: "membarrier",
    357: "recvmmsg",
    358: "sendmmsg",
    359: "socket",
    360: "socketpair",
    361: "bind",
    362: "connect",
    363: "listen",
    364: "accept4",
    365: "getsockopt",
    366: "setsockopt",
    367: "getsockname",
    368: "getpeername",
    369: "sendto",
    370: "sendmsg",
    371: "recvfrom",
    372: "recvmsg",
    373: "shutdown",
    374: "mlock2",
})

lib.add_number_mapping_from_dict("s390x", {
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "restart_syscall",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    14: "mknod",
    15: "chmod",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    26: "ptrace",
    27: "alarm",
    29: "pause",
    30: "utime",
    33: "access",
    34: "nice",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    45: "brk",
    48: "signal",
    51: "acct",
    52: "umount2",
    54: "ioctl",
    55: "fcntl",
    57: "setpgid",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    83: "symlink",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    96: "getpriority",
    97: "setpriority",
    99: "statfs",
    100: "fstatfs",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    110: "lookup_dcookie",
    111: "vhangup",
    112: "idle",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    141: "getdents",
    142: "select",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    167: "query_module",
    168: "poll",
    169: "nfsservctl",
    172: "prctl",
    173: "rt_sigreturn",
    174: "rt_sigaction",
    175: "rt_sigprocmask",
    176: "rt_sigpending",
    177: "rt_sigtimedwait",
    178: "rt_sigqueueinfo",
    179: "rt_sigsuspend",
    180: "pread64",
    181: "pwrite64",
    183: "getcwd",
    184: "capget",
    185: "capset",
    186: "sigaltstack",
    187: "sendfile",
    188: "getpmsg",
    189: "putpmsg",
    190: "vfork",
    191: "getrlimit",
    198: "lchown",
    199: "getuid",
    200: "getgid",
    201: "geteuid",
    202: "getegid",
    203: "setreuid",
    204: "setregid",
    205: "getgroups",
    206: "setgroups",
    207: "fchown",
    208: "setresuid",
    209: "getresuid",
    210: "setresgid",
    211: "getresgid",
    212: "chown",
    213: "setuid",
    214: "setgid",
    215: "setfsuid",
    216: "setfsgid",
    217: "pivot_root",
    218: "mincore",
    219: "madvise",
    220: "getdents64",
    222: "readahead",
    224: "setxattr",
    225: "lsetxattr",
    226: "fsetxattr",
    227: "getxattr",
    228: "lgetxattr",
    229: "fgetxattr",
    230: "listxattr",
    231: "llistxattr",
    232: "flistxattr",
    233: "removexattr",
    234: "lremovexattr",
    235: "fremovexattr",
    236: "gettid",
    237: "tkill",
    238: "futex",
    239: "sched_setaffinity",
    240: "sched_getaffinity",
    241: "tgkill",
    243: "io_setup",
    244: "io_destroy",
    245: "io_getevents",
    246: "io_submit",
    247: "io_cancel",
    248: "exit_group",
    249: "epoll_create",
    250: "epoll_ctl",
    251: "epoll_wait",
    252: "set_tid_address",
    253: "fadvise64",
    254: "timer_create",
    255: "timer_settime",
    256: "timer_gettime",
    257: "timer_getoverrun",
    258: "timer_delete",
    259: "clock_settime",
    260: "clock_gettime",
    261: "clock_getres",
    262: "clock_nanosleep",
    265: "statfs64",
    266: "fstatfs64",
    267: "remap_file_pages",
    268: "mbind",
    269: "get_mempolicy",
    270: "set_mempolicy",
    271: "mq_open",
    272: "mq_unlink",
    273: "mq_timedsend",
    274: "mq_timedreceive",
    275: "mq_notify",
    276: "mq_getsetattr",
    277: "kexec_load",
    278: "add_key",
    279: "request_key",
    280: "keyctl",
    281: "waitid",
    282: "ioprio_set",
    283: "ioprio_get",
    284: "inotify_init",
    285: "inotify_add_watch",
    286: "inotify_rm_watch",
    287: "migrate_pages",
    288: "openat",
    289: "mkdirat",
    290: "mknodat",
    291: "fchownat",
    292: "futimesat",
    293: "newfstatat",
    294: "unlinkat",
    295: "renameat",
    296: "linkat",
    297: "symlinkat",
    298: "readlinkat",
    299: "fchmodat",
    300: "faccessat",
    301: "pselect6",
    302: "ppoll",
    303: "unshare",
    304: "set_robust_list",
    305: "get_robust_list",
    306: "splice",
    307: "sync_file_range",
    308: "tee",
    309: "vmsplice",
    310: "move_pages",
    311: "getcpu",
    312: "epoll_pwait",
    313: "utimes",
    314: "fallocate",
    315: "utimensat",
    316: "signalfd",
    317: "timerfd",
    318: "eventfd",
    319: "timerfd_create",
    320: "timerfd_settime",
    321: "timerfd_gettime",
    322: "signalfd4",
    323: "eventfd2",
    324: "inotify_init1",
    325: "pipe2",
    326: "dup3",
    327: "epoll_create1",
    330: "rt_tgsigqueueinfo",
    331: "perf_event_open",
    332: "fanotify_init",
    333: "fanotify_mark",
    334: "prlimit64",
    335: "name_to_handle_at",
    336: "open_by_handle_at",
    337: "clock_adjtime",
    338: "syncfs",
    339: "setns",
    340: "process_vm_readv",
    341: "process_vm_writev",
    342: "s390_runtime_instr",
    343: "kcmp",
    344: "finit_module",
    345: "sched_setattr",
    346: "sched_getattr",
    347: "renameat2",
    348: "seccomp",
    349: "getrandom",
    350: "memfd_create",
    351: "bpf",
    352: "s390_pci_mmio_write",
    353: "s390_pci_mmio_read",
    354: "execveat",
    355: "userfaultfd",
    356: "membarrier",
    357: "recvmmsg",
    358: "sendmmsg",
    359: "socket",
    360: "socketpair",
    361: "bind",
    362: "connect",
    363: "listen",
    364: "accept4",
    365: "getsockopt",
    366: "setsockopt",
    367: "getsockname",
    368: "getpeername",
    369: "sendto",
    370: "sendmsg",
    371: "recvfrom",
    372: "recvmsg",
    373: "shutdown",
    374: "mlock2",
})

lib.add_number_mapping_from_dict("sparc", {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "wait4",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execv",
    12: "chdir",
    13: "chown",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "brk",
    18: "perfctr",
    19: "lseek",
    20: "getpid",
    21: "capget",
    22: "capset",
    23: "setuid",
    24: "getuid",
    25: "vmsplice",
    26: "ptrace",
    27: "alarm",
    28: "sigaltstack",
    29: "pause",
    30: "utime",
    31: "lchown32",
    32: "fchown32",
    33: "access",
    34: "nice",
    35: "chown32",
    36: "sync",
    37: "kill",
    38: "stat",
    39: "sendfile",
    40: "lstat",
    41: "dup",
    42: "pipe",
    43: "times",
    44: "getuid32",
    45: "umount2",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    53: "getgid32",
    54: "ioctl",
    55: "reboot",
    56: "mmap2",
    57: "symlink",
    58: "readlink",
    59: "execve",
    60: "umask",
    61: "chroot",
    62: "fstat",
    63: "fstat64",
    64: "getpagesize",
    65: "msync",
    66: "vfork",
    67: "pread64",
    68: "pwrite64",
    69: "geteuid32",
    70: "getegid32",
    71: "mmap",
    72: "setreuid32",
    73: "munmap",
    74: "mprotect",
    75: "madvise",
    76: "vhangup",
    77: "truncate64",
    78: "mincore",
    79: "getgroups",
    80: "setgroups",
    81: "getpgrp",
    82: "setgroups32",
    83: "setitimer",
    84: "ftruncate64",
    85: "swapon",
    86: "getitimer",
    87: "setuid32",
    88: "sethostname",
    89: "setgid32",
    90: "dup2",
    91: "setfsuid32",
    92: "fcntl",
    93: "select",
    94: "setfsgid32",
    95: "fsync",
    96: "setpriority",
    97: "socket",
    98: "connect",
    99: "accept",
    100: "getpriority",
    101: "rt_sigreturn",
    102: "rt_sigaction",
    103: "rt_sigprocmask",
    104: "rt_sigpending",
    105: "rt_sigtimedwait",
    106: "rt_sigqueueinfo",
    107: "rt_sigsuspend",
    108: "setresuid32",
    109: "getresuid32",
    110: "setresgid32",
    111: "getresgid32",
    112: "setregid32",
    113: "recvmsg",
    114: "sendmsg",
    115: "getgroups32",
    116: "gettimeofday",
    117: "getrusage",
    118: "getsockopt",
    119: "getcwd",
    120: "readv",
    121: "writev",
    122: "settimeofday",
    123: "fchown",
    124: "fchmod",
    125: "recvfrom",
    126: "setreuid",
    127: "setregid",
    128: "rename",
    129: "truncate",
    130: "ftruncate",
    131: "flock",
    132: "lstat64",
    133: "sendto",
    134: "shutdown",
    135: "socketpair",
    136: "mkdir",
    137: "rmdir",
    138: "utimes",
    139: "stat64",
    140: "sendfile64",
    141: "getpeername",
    142: "futex",
    143: "gettid",
    144: "getrlimit",
    145: "setrlimit",
    146: "pivot_root",
    147: "prctl",
    148: "pciconfig_read",
    149: "pciconfig_write",
    150: "getsockname",
    151: "inotify_init",
    152: "inotify_add_watch",
    153: "poll",
    154: "getdents64",
    155: "fcntl64",
    156: "inotify_rm_watch",
    157: "statfs",
    158: "fstatfs",
    159: "umount",
    160: "sched_set_affinity",
    161: "sched_get_affinity",
    162: "getdomainname",
    163: "setdomainname",
    165: "quotactl",
    166: "set_tid_address",
    167: "mount",
    168: "ustat",
    169: "setxattr",
    170: "lsetxattr",
    171: "fsetxattr",
    172: "getxattr",
    173: "lgetxattr",
    174: "getdents",
    175: "setsid",
    176: "fchdir",
    177: "fgetxattr",
    178: "listxattr",
    179: "llistxattr",
    180: "flistxattr",
    181: "removexattr",
    182: "lremovexattr",
    183: "sigpending",
    184: "query_module",
    185: "setpgid",
    186: "fremovexattr",
    187: "tkill",
    188: "exit_group",
    189: "uname",
    190: "init_module",
    191: "personality",
    192: "remap_file_pages",
    193: "epoll_create",
    194: "epoll_ctl",
    195: "epoll_wait",
    196: "ioprio_set",
    197: "getppid",
    198: "sigaction",
    199: "sgetmask",
    200: "ssetmask",
    201: "sigsuspend",
    202: "oldlstat",
    203: "uselib",
    204: "readdir",
    205: "readahead",
    206: "socketcall",
    207: "syslog",
    208: "lookup_dcookie",
    209: "fadvise64",
    210: "fadvise64_64",
    211: "tgkill",
    212: "waitpid",
    213: "swapoff",
    214: "sysinfo",
    215: "ipc",
    216: "sigreturn",
    217: "clone",
    218: "ioprio_get",
    219: "adjtimex",
    220: "sigprocmask",
    221: "create_module",
    222: "delete_module",
    223: "get_kernel_syms",
    224: "getpgid",
    225: "bdflush",
    226: "sysfs",
    227: "afs_syscall",
    228: "setfsuid",
    229: "setfsgid",
    230: "_newselect",
    231: "time",
    232: "splice",
    233: "stime",
    234: "statfs64",
    235: "fstatfs64",
    236: "_llseek",
    237: "mlock",
    238: "munlock",
    239: "mlockall",
    240: "munlockall",
    241: "sched_setparam",
    242: "sched_getparam",
    243: "sched_setscheduler",
    244: "sched_getscheduler",
    245: "sched_yield",
    246: "sched_get_priority_max",
    247: "sched_get_priority_min",
    248: "sched_rr_get_interval",
    249: "nanosleep",
    250: "mremap",
    251: "_sysctl",
    252: "getsid",
    253: "fdatasync",
    254: "nfsservctl",
    255: "sync_file_range",
    256: "clock_settime",
    257: "clock_gettime",
    258: "clock_getres",
    259: "clock_nanosleep",
    260: "sched_getaffinity",
    261: "sched_setaffinity",
    262: "timer_settime",
    263: "timer_gettime",
    264: "timer_getoverrun",
    265: "timer_delete",
    266: "timer_create",
    267: "vserver",
    268: "io_setup",
    269: "io_destroy",
    270: "io_submit",
    271: "io_cancel",
    272: "io_getevents",
    273: "mq_open",
    274: "mq_unlink",
    275: "mq_timedsend",
    276: "mq_timedreceive",
    277: "mq_notify",
    278: "mq_getsetattr",
    279: "waitid",
    280: "tee",
    281: "add_key",
    282: "request_key",
    283: "keyctl",
    284: "openat",
    285: "mkdirat",
    286: "mknodat",
    287: "fchownat",
    288: "futimesat",
    289: "fstatat64",
    290: "unlinkat",
    291: "renameat",
    292: "linkat",
    293: "symlinkat",
    294: "readlinkat",
    295: "fchmodat",
    296: "faccessat",
    297: "pselect6",
    298: "ppoll",
    299: "unshare",
    300: "set_robust_list",
    301: "get_robust_list",
    302: "migrate_pages",
    303: "mbind",
    304: "get_mempolicy",
    305: "set_mempolicy",
    306: "kexec_load",
    307: "move_pages",
    308: "getcpu",
    309: "epoll_pwait",
    310: "utimensat",
    311: "signalfd",
    312: "timerfd_create",
    313: "eventfd",
    314: "fallocate",
    315: "timerfd_settime",
    316: "timerfd_gettime",
    317: "signalfd4",
    318: "eventfd2",
    319: "epoll_create1",
    320: "dup3",
    321: "pipe2",
    322: "inotify_init1",
    323: "accept4",
    324: "preadv",
    325: "pwritev",
    326: "rt_tgsigqueueinfo",
    327: "perf_event_open",
    328: "recvmmsg",
})

lib.add_number_mapping_from_dict("sparc64", {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "wait4",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execv",
    12: "chdir",
    13: "chown",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "brk",
    18: "perfctr",
    19: "lseek",
    20: "getpid",
    21: "capget",
    22: "capset",
    23: "setuid",
    24: "getuid",
    25: "vmsplice",
    26: "ptrace",
    27: "alarm",
    28: "sigaltstack",
    29: "pause",
    30: "utime",
    33: "access",
    34: "nice",
    36: "sync",
    37: "kill",
    38: "stat",
    39: "sendfile",
    40: "lstat",
    41: "dup",
    42: "pipe",
    43: "times",
    45: "umount2",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "memory_ordering",
    54: "ioctl",
    55: "reboot",
    57: "symlink",
    58: "readlink",
    59: "execve",
    60: "umask",
    61: "chroot",
    62: "fstat",
    63: "fstat64",
    64: "getpagesize",
    65: "msync",
    66: "vfork",
    67: "pread64",
    68: "pwrite64",
    71: "mmap",
    73: "munmap",
    74: "mprotect",
    75: "madvise",
    76: "vhangup",
    78: "mincore",
    79: "getgroups",
    80: "setgroups",
    81: "getpgrp",
    83: "setitimer",
    85: "swapon",
    86: "getitimer",
    88: "sethostname",
    90: "dup2",
    92: "fcntl",
    93: "select",
    95: "fsync",
    96: "setpriority",
    97: "socket",
    98: "connect",
    99: "accept",
    100: "getpriority",
    101: "rt_sigreturn",
    102: "rt_sigaction",
    103: "rt_sigprocmask",
    104: "rt_sigpending",
    105: "rt_sigtimedwait",
    106: "rt_sigqueueinfo",
    107: "rt_sigsuspend",
    108: "setresuid",
    109: "getresuid",
    110: "setresgid",
    111: "getresgid",
    113: "recvmsg",
    114: "sendmsg",
    116: "gettimeofday",
    117: "getrusage",
    118: "getsockopt",
    119: "getcwd",
    120: "readv",
    121: "writev",
    122: "settimeofday",
    123: "fchown",
    124: "fchmod",
    125: "recvfrom",
    126: "setreuid",
    127: "setregid",
    128: "rename",
    129: "truncate",
    130: "ftruncate",
    131: "flock",
    132: "lstat64",
    133: "sendto",
    134: "shutdown",
    135: "socketpair",
    136: "mkdir",
    137: "rmdir",
    138: "utimes",
    139: "stat64",
    140: "sendfile64",
    141: "getpeername",
    142: "futex",
    143: "gettid",
    144: "getrlimit",
    145: "setrlimit",
    146: "pivot_root",
    147: "prctl",
    148: "pciconfig_read",
    149: "pciconfig_write",
    150: "getsockname",
    151: "inotify_init",
    152: "inotify_add_watch",
    153: "poll",
    154: "getdents64",
    156: "inotify_rm_watch",
    157: "statfs",
    158: "fstatfs",
    159: "umount",
    160: "sched_set_affinity",
    161: "sched_get_affinity",
    162: "getdomainname",
    163: "setdomainname",
    164: "utrap_install",
    165: "quotactl",
    166: "set_tid_address",
    167: "mount",
    168: "ustat",
    169: "setxattr",
    170: "lsetxattr",
    171: "fsetxattr",
    172: "getxattr",
    173: "lgetxattr",
    174: "getdents",
    175: "setsid",
    176: "fchdir",
    177: "fgetxattr",
    178: "listxattr",
    179: "llistxattr",
    180: "flistxattr",
    181: "removexattr",
    182: "lremovexattr",
    183: "sigpending",
    184: "query_module",
    185: "setpgid",
    186: "fremovexattr",
    187: "tkill",
    188: "exit_group",
    189: "uname",
    190: "init_module",
    191: "personality",
    192: "remap_file_pages",
    193: "epoll_create",
    194: "epoll_ctl",
    195: "epoll_wait",
    196: "ioprio_set",
    197: "getppid",
    198: "sigaction",
    199: "sgetmask",
    200: "ssetmask",
    201: "sigsuspend",
    202: "oldlstat",
    203: "uselib",
    204: "readdir",
    205: "readahead",
    206: "socketcall",
    207: "syslog",
    208: "lookup_dcookie",
    209: "fadvise64",
    210: "fadvise64_64",
    211: "tgkill",
    212: "waitpid",
    213: "swapoff",
    214: "sysinfo",
    215: "ipc",
    216: "sigreturn",
    217: "clone",
    218: "ioprio_get",
    219: "adjtimex",
    220: "sigprocmask",
    221: "create_module",
    222: "delete_module",
    223: "get_kernel_syms",
    224: "getpgid",
    225: "bdflush",
    226: "sysfs",
    227: "afs_syscall",
    228: "setfsuid",
    229: "setfsgid",
    230: "_newselect",
    232: "splice",
    233: "stime",
    234: "statfs64",
    235: "fstatfs64",
    236: "_llseek",
    237: "mlock",
    238: "munlock",
    239: "mlockall",
    240: "munlockall",
    241: "sched_setparam",
    242: "sched_getparam",
    243: "sched_setscheduler",
    244: "sched_getscheduler",
    245: "sched_yield",
    246: "sched_get_priority_max",
    247: "sched_get_priority_min",
    248: "sched_rr_get_interval",
    249: "nanosleep",
    250: "mremap",
    251: "_sysctl",
    252: "getsid",
    253: "fdatasync",
    254: "nfsservctl",
    255: "sync_file_range",
    256: "clock_settime",
    257: "clock_gettime",
    258: "clock_getres",
    259: "clock_nanosleep",
    260: "sched_getaffinity",
    261: "sched_setaffinity",
    262: "timer_settime",
    263: "timer_gettime",
    264: "timer_getoverrun",
    265: "timer_delete",
    266: "timer_create",
    267: "vserver",
    268: "io_setup",
    269: "io_destroy",
    270: "io_submit",
    271: "io_cancel",
    272: "io_getevents",
    273: "mq_open",
    274: "mq_unlink",
    275: "mq_timedsend",
    276: "mq_timedreceive",
    277: "mq_notify",
    278: "mq_getsetattr",
    279: "waitid",
    280: "tee",
    281: "add_key",
    282: "request_key",
    283: "keyctl",
    284: "openat",
    285: "mkdirat",
    286: "mknodat",
    287: "fchownat",
    288: "futimesat",
    289: "fstatat64",
    290: "unlinkat",
    291: "renameat",
    292: "linkat",
    293: "symlinkat",
    294: "readlinkat",
    295: "fchmodat",
    296: "faccessat",
    297: "pselect6",
    298: "ppoll",
    299: "unshare",
    300: "set_robust_list",
    301: "get_robust_list",
    302: "migrate_pages",
    303: "mbind",
    304: "get_mempolicy",
    305: "set_mempolicy",
    306: "kexec_load",
    307: "move_pages",
    308: "getcpu",
    309: "epoll_pwait",
    310: "utimensat",
    311: "signalfd",
    312: "timerfd_create",
    313: "eventfd",
    314: "fallocate",
    315: "timerfd_settime",
    316: "timerfd_gettime",
    317: "signalfd4",
    318: "eventfd2",
    319: "epoll_create1",
    320: "dup3",
    321: "pipe2",
    322: "inotify_init1",
    323: "accept4",
    324: "preadv",
    325: "pwritev",
    326: "rt_tgsigqueueinfo",
    327: "perf_event_open",
    328: "recvmmsg",
})

lib.add_number_mapping_from_dict("riscv32", {
    0: "io_setup",
    1: "io_destroy",
    2: "io_submit",
    3: "io_cancel",
    4: "io_getevents",
    5: "setxattr",
    6: "lsetxattr",
    7: "fsopen",
    8: "getxattr",
    9: "lgetxattr",
    10: "fgetxattr",
    11: "listxattr",
    12: "llistxattr",
    13: "flistxattr",
    14: "removexattr",
    15: "lremovexattr",
    16: "fremovexattr",
    17: "getcwd",
    18: "lookup_dcookie",
    19: "eventfd2",
    20: "epoll_create1",
    21: "epoll_ctl",
    22: "epoll_pwait",
    23: "dup",
    24: "dup3",
    25: "fcntl",
    26: "inotify_init1",
    27: "inotify_add_watch",
    28: "inotify_rm_watch",
    29: "ioctl",
    30: "ioprio_set",
    31: "ioprio_get",
    32: "flock",
    33: "mknodat",
    34: "mkdirat",
    35: "unlinkat",
    36: "symlinkat",
    37: "linkat",
    39: "unmount2",
    40: "mount",
    41: "pivot_root",
    42: "nfsservctl",
    43: "statfs",
    44: "fstatfs",
    45: "truncate",
    46: "ftruncate",
    47: "fallocate",
    48: "faccessat",
    49: "chdir",
    50: "fchdir",
    51: "chroot",
    52: "fchmod",
    53: "fchmodat",
    54: "fchownat",
    55: "fchown",
    56: "openat",
    57: "close",
    58: "vhangup",
    59: "pipe2",
    60: "quotactl",
    61: "getdents64",
    62: "lseek",
    63: "read",
    64: "write",
    65: "readv",
    66: "writev",
    67: "pread64",
    68: "pwrite64",
    69: "preadv",
    70: "pwritev",
    71: "sendfile",
    72: "pselect6",
    73: "ppoll",
    74: "signalfd4",
    75: "vmsplice",
    76: "splice",
    77: "tee",
    78: "readlinkat",
    80: "fstat",
    81: "sync",
    82: "fsync",
    83: "fdatasync",
    84: "sync_file_range",
    85: "timer_fd_create",
    86: "timer_fd_settime",
    87: "timer_fd_gettime",
    88: "utimensat",
    89: "acct",
    90: "capget",
    91: "capset",
    92: "personality",
    93: "exit",
    94: "exit_group",
    95: "waitid",
    96: "set_tid_address",
    97: "unshare",
    98: "futex",
    99: "set_robust_list",
    100: "get_robust_list",
    101: "nanosleep",
    102: "getitimer",
    103: "setitimer",
    104: "kexec_load",
    105: "init_module",
    106: "delete_module",
    107: "timer_create",
    108: "timer_gettime",
    109: "timer_getoverrun",
    110: "timer_settime",
    111: "timer_delete",
    112: "clock_settime",
    113: "clock_gettime",
    114: "clock_getres",
    115: "clock_nanosleep",
    116: "syslog",
    117: "ptrace",
    118: "sched_setparam",
    119: "sched_setscheduler",
    120: "sched_getscheduler",
    121: "sched_getparam",
    122: "sched_setaffinity",
    123: "sched_getaffinity",
    124: "sched_yield",
    125: "sched_get_priority_max",
    126: "sched_get_priority_min",
    127: "sched_rr_get_interval",
    128: "restart_syscall",
    129: "kill",
    130: "tkill",
    131: "tgkill",
    132: "sigalstack",
    133: "rt_sigsuspend",
    134: "rt_sigaction",
    135: "rt_sigprocmask",
    136: "rt_sigpending",
    137: "rt_sigtimedwait",
    138: "rt_sigqueueinfo",
    139: "rt_sigreturn",
    140: "setpriority",
    141: "getpriority",
    142: "reboot",
    143: "setregid",
    144: "setgid",
    145: "setreuid",
    147: "setresuid",
    146: "setuid",
    148: "getresuid",
    149: "setresgid",
    150: "getresgid",
    151: "setfsuid",
    152: "setfsgid",
    153: "times",
    154: "setpgid",
    155: "getpgid",
    156: "getsid",
    157: "setsid",
    158: "get_groups",
    159: "set_groups",
    160: "uname",
    161: "sethostname",
    162: "setdomainname",
    165: "getrusage",
    166: "unmask",
    167: "prctl",
    168: "getcpu",
    169: "gettimeofday",
    170: "settimeofday",
    172: "getpid",
    173: "getppid",
    174: "getuid",
    175: "geteuid",
    176: "getgid",
    177: "getegid",
    178: "gettid",
    179: "sysinfo",
    180: "mq_open",
    181: "mq_unlink",
    182: "mq_timedsend",
    183: "mq_timedreceive",
    184: "mq_notify",
    185: "mq_getsetattr",
    186: "msgget",
    187: "msgctl",
    188: "msgrcv",
    189: "msgsnd",
    190: "semget",
    191: "semctl",
    192: "semtimedop",
    193: "semop",
    194: "shmget",
    195: "shmctl",
    196: "shmat",
    197: "shmdt",
    198: "socket",
    199: "socketpair",
    200: "bind",
    201: "listen",
    202: "accept",
    203: "connect",
    204: "getsockname",
    205: "getpeername",
    206: "sendto",
    207: "recvfrom",
    208: "setsockopt",
    209: "getsockopt",
    210: "shutdown",
    211: "sendmsg",
    212: "recvmsg",
    213: "readahead",
    214: "brk",
    215: "munmap",
    216: "mremap",
    217: "add_key",
    218: "request_key",
    219: "keyctl",
    220: "clone",
    221: "execve",
    222: "mmap",
    223: "fadvise_64",
    224: "swapon",
    225: "swapoff",
    226: "mprotect",
    227: "msync",
    228: "mlock",
    229: "munlock",
    230: "mlockall",
    231: "munlockall",
    232: "mincore",
    233: "madvise",
    234: "remap_file_pages",
    235: "mbind",
    236: "getmempolicy",
    237: "set_mempolicy",
    238: "migrate_pages",
    239: "move_pages",
    240: "rtas",
    241: "perf_event_open",
    242: "accept4",
    243: "recvmmsg",
    259: "riscv_flush_icache",
    260: "wait4",
    261: "prlimit64",
    262: "fanotify_init",
    263: "fanotify_mark",
    264: "name_to_handle_at",
    265: "open_by_handle_at",
    266: "clock_adjtime",
    267: "syncfs",
    268: "setns",
    269: "sendmmsg",
    270: "process_vm_readv",
    271: "process_vm_writev",
    272: "kcmp",
    273: "finit_module",
    274: "sched_setattr",
    275: "sched_getattr",
    276: "renameat2",
    277: "seccomp",
    278: "getrandom",
    279: "memfd_create",
    280: "bpf",
    281: "execveat",
    282: "userfaultfd",
    283: "membarrier",
    284: "mlock2",
    285: "copy_file_range",
    286: "preadv2",
    287: "pwritev2",
    288: "pkey_mprotect",
    289: "pkey_alloc",
    290: "pkey_free",
    291: "statx",
    292: "io_pgetevents",
    293: "rseq",
    294: "kexec_file_load",
    424: "pidfd_send_signal",
    425: "io_uring_setup",
    426: "io_uring_enter",
    427: "io_uring_register",
    428: "open_tree",
    429: "move_mount",
    430: "fstat",
    431: "fsconfig",
    432: "fsmount",
    433: "fspick",
    434: "pidfd_open",
    437: "openat2",
    438: "pidfd_getfd",
    439: "faccessat2",

})
