# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class Slo(pulumi.CustomResource):
    basic_sli: pulumi.Output[dict]
    """
    Basic Service-Level Indicator (SLI) on a well-known service type.
    Performance will be computed on the basis of pre-defined metrics.
    SLIs are used to measure and calculate the quality of the Service's
    performance with respect to a single aspect of service quality.
    Exactly one of the following must be set:
    `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.

      * `latency` (`dict`) - Parameters for a latency threshold SLI.  Structure is documented below.
        * `threshold` (`str`) - A duration string, e.g. 10s.
          Good service is defined to be the count of requests made to
          this service that return in no more than threshold.

      * `locations` (`list`) - An optional set of locations to which this SLI is relevant.
        Telemetry from other locations will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        locations in which the Service has activity. For service types
        that don't support breaking down by location, setting this
        field will result in an error.
      * `methods` (`list`) - An optional set of RPCs to which this SLI is relevant.
        Telemetry from other methods will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        the Service's methods. For service types that don't support
        breaking down by method, setting this field will result in an
        error.
      * `versions` (`list`) - The set of API versions to which this SLI is relevant.
        Telemetry from other API versions will not be used to
        calculate performance for this SLI. If omitted,
        this SLI applies to all API versions. For service types
        that don't support breaking down by version, setting this
        field will result in an error.
    """
    calendar_period: pulumi.Output[str]
    """
    A calendar period, semantically "since the start of the current
    <calendarPeriod>".
    """
    display_name: pulumi.Output[str]
    """
    Name used for UI elements listing this SLO.
    """
    goal: pulumi.Output[float]
    """
    The fraction of service that must be good in order for this objective
    to be met. 0 < goal <= 0.999
    """
    name: pulumi.Output[str]
    """
    The full resource name for this service. The syntax is:
    projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    request_based_sli: pulumi.Output[dict]
    """
    A request-based SLI defines a SLI for which atomic units of
    service are counted directly.
    A SLI describes a good service.
    It is used to measure and calculate the quality of the Service's
    performance with respect to a single aspect of service quality.
    Exactly one of the following must be set:
    `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.

      * `distributionCut` (`dict`) - Used when good_service is defined by a count of values aggregated in a
        Distribution that fall into a good range. The total_service is the
        total count of all values aggregated in the Distribution.
        Defines a distribution TimeSeries filter and thresholds used for
        measuring good service and total service.  Structure is documented below.
        * `distributionFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          aggregating values to quantify the good service provided.
          Must have ValueType = DISTRIBUTION and
          MetricKind = DELTA or MetricKind = CUMULATIVE.
        * `range` (`dict`) - Range of numerical values. The computed good_service
          will be the count of values x in the Distribution such
          that range.min <= x < range.max. inclusive of min and
          exclusive of max. Open ranges can be defined by setting
          just one of min or max. Summed value `X` should satisfy
          `range.min <= X < range.max` for a good window.  Structure is documented below.
          * `max` (`float`) - max value for the range (inclusive). If not given,
            will be set to "infinity", defining an open range
            ">= range.min"
          * `min` (`float`) - Min value for the range (inclusive). If not given,
            will be set to "-infinity", defining an open range
            "< range.max"

      * `goodTotalRatio` (`dict`) - A means to compute a ratio of `good_service` to `total_service`.
        Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
        Must specify exactly two of good, bad, and total service filters.
        The relationship good_service + bad_service = total_service
        will be assumed.  Structure is documented below.
        * `badServiceFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          quantifying bad service provided, either demanded service that
          was not provided or demanded service that was of inadequate
          quality. Exactly two of
          good, bad, or total service filter must be defined (where
          good + bad = total is assumed)
          Must have ValueType = DOUBLE or ValueType = INT64 and
          must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        * `goodServiceFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          quantifying good service provided. Exactly two of
          good, bad, or total service filter must be defined (where
          good + bad = total is assumed)
          Must have ValueType = DOUBLE or ValueType = INT64 and
          must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        * `totalServiceFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          quantifying total demanded service. Exactly two of
          good, bad, or total service filter must be defined (where
          good + bad = total is assumed)
          Must have ValueType = DOUBLE or ValueType = INT64 and
          must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    """
    rolling_period_days: pulumi.Output[float]
    """
    A rolling time period, semantically "in the past X days".
    Must be between 1 to 30 days, inclusive.
    """
    service: pulumi.Output[str]
    """
    ID of the service to which this SLO belongs.
    """
    slo_id: pulumi.Output[str]
    """
    The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
    """
    windows_based_sli: pulumi.Output[dict]
    """
    A windows-based SLI defines the criteria for time windows.
    good_service is defined based off the count of these time windows
    for which the provided service was of good quality.
    A SLI describes a good service. It is used to measure and calculate
    the quality of the Service's performance with respect to a single
    aspect of service quality.
    Exactly one of the following must be set:
    `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.

      * `goodBadMetricFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        with ValueType = BOOL. The window is good if any true values
        appear in the window. One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
      * `goodTotalRatioThreshold` (`dict`) - Criterion that describes a window as good if its performance is
        high enough. One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.  Structure is documented below.
        * `basicSliPerformance` (`dict`) - Basic SLI to evaluate to judge window quality.  Structure is documented below.
          * `latency` (`dict`) - Parameters for a latency threshold SLI.  Structure is documented below.
            * `threshold` (`str`) - A duration string, e.g. 10s.
              Good service is defined to be the count of requests made to
              this service that return in no more than threshold.

          * `locations` (`list`) - An optional set of locations to which this SLI is relevant.
            Telemetry from other locations will not be used to calculate
            performance for this SLI. If omitted, this SLI applies to all
            locations in which the Service has activity. For service types
            that don't support breaking down by location, setting this
            field will result in an error.
          * `methods` (`list`) - An optional set of RPCs to which this SLI is relevant.
            Telemetry from other methods will not be used to calculate
            performance for this SLI. If omitted, this SLI applies to all
            the Service's methods. For service types that don't support
            breaking down by method, setting this field will result in an
            error.
          * `versions` (`list`) - The set of API versions to which this SLI is relevant.
            Telemetry from other API versions will not be used to
            calculate performance for this SLI. If omitted,
            this SLI applies to all API versions. For service types
            that don't support breaking down by version, setting this
            field will result in an error.

        * `performance` (`dict`) - Request-based SLI to evaluate to judge window quality.  Structure is documented below.
          * `distributionCut` (`dict`) - Used when good_service is defined by a count of values aggregated in a
            Distribution that fall into a good range. The total_service is the
            total count of all values aggregated in the Distribution.
            Defines a distribution TimeSeries filter and thresholds used for
            measuring good service and total service.  Structure is documented below.
            * `distributionFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              aggregating values to quantify the good service provided.
              Must have ValueType = DISTRIBUTION and
              MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `range` (`dict`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`float`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`float`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

          * `goodTotalRatio` (`dict`) - A means to compute a ratio of `good_service` to `total_service`.
            Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
            Must specify exactly two of good, bad, and total service filters.
            The relationship good_service + bad_service = total_service
            will be assumed.  Structure is documented below.
            * `badServiceFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying bad service provided, either demanded service that
              was not provided or demanded service that was of inadequate
              quality. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `goodServiceFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying good service provided. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `totalServiceFilter` (`str`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying total demanded service. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.

        * `threshold` (`float`) - A duration string, e.g. 10s.
          Good service is defined to be the count of requests made to
          this service that return in no more than threshold.

      * `metricMeanInRange` (`dict`) - Criterion that describes a window as good if the metric's value
        is in a good range, *averaged* across returned streams.
        One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Average value X of `time_series` should satisfy
        `range.min <= X < range.max` for a good window.  Structure is documented below.
        * `range` (`dict`) - Range of numerical values. The computed good_service
          will be the count of values x in the Distribution such
          that range.min <= x < range.max. inclusive of min and
          exclusive of max. Open ranges can be defined by setting
          just one of min or max. Summed value `X` should satisfy
          `range.min <= X < range.max` for a good window.  Structure is documented below.
          * `max` (`float`) - max value for the range (inclusive). If not given,
            will be set to "infinity", defining an open range
            ">= range.min"
          * `min` (`float`) - Min value for the range (inclusive). If not given,
            will be set to "-infinity", defining an open range
            "< range.max"

        * `timeSeries` (`str`) - A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          specifying the TimeSeries to use for evaluating window
          quality. The provided TimeSeries must have
          ValueType = INT64 or ValueType = DOUBLE and
          MetricKind = GAUGE.
          Summed value `X` should satisfy
          `range.min <= X < range.max` for a good window.

      * `metricSumInRange` (`dict`) - Criterion that describes a window as good if the metric's value
        is in a good range, *summed* across returned streams.
        Summed value `X` of `time_series` should satisfy
        `range.min <= X < range.max` for a good window.
        One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.  Structure is documented below.
        * `range` (`dict`) - Range of numerical values. The computed good_service
          will be the count of values x in the Distribution such
          that range.min <= x < range.max. inclusive of min and
          exclusive of max. Open ranges can be defined by setting
          just one of min or max. Summed value `X` should satisfy
          `range.min <= X < range.max` for a good window.  Structure is documented below.
          * `max` (`float`) - max value for the range (inclusive). If not given,
            will be set to "infinity", defining an open range
            ">= range.min"
          * `min` (`float`) - Min value for the range (inclusive). If not given,
            will be set to "-infinity", defining an open range
            "< range.max"

        * `timeSeries` (`str`) - A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          specifying the TimeSeries to use for evaluating window
          quality. The provided TimeSeries must have
          ValueType = INT64 or ValueType = DOUBLE and
          MetricKind = GAUGE.
          Summed value `X` should satisfy
          `range.min <= X < range.max` for a good window.

      * `windowPeriod` (`str`) - Duration over which window quality is evaluated, given as a
        duration string "{X}s" representing X seconds. Must be an
        integer fraction of a day and at least 60s.
    """
    def __init__(__self__, resource_name, opts=None, basic_sli=None, calendar_period=None, display_name=None, goal=None, project=None, request_based_sli=None, rolling_period_days=None, service=None, slo_id=None, windows_based_sli=None, __props__=None, __name__=None, __opts__=None):
        """
        A Service-Level Objective (SLO) describes the level of desired good
        service. It consists of a service-level indicator (SLI), a performance
        goal, and a period over which the objective is to be evaluated against
        that goal. The SLO can use SLIs defined in a number of different manners.
        Typical SLOs might include "99% of requests in each rolling week have
        latency below 200 milliseconds" or "99.5% of requests in each calendar
        month return successfully."

        To get more information about Slo, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services.serviceLevelObjectives)
        * How-to Guides
            * [Service Monitoring](https://cloud.google.com/monitoring/service-monitoring)
            * [Monitoring API Documentation](https://cloud.google.com/monitoring/api/v3/)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] basic_sli: Basic Service-Level Indicator (SLI) on a well-known service type.
               Performance will be computed on the basis of pre-defined metrics.
               SLIs are used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.
        :param pulumi.Input[str] calendar_period: A calendar period, semantically "since the start of the current
               <calendarPeriod>".
        :param pulumi.Input[str] display_name: Name used for UI elements listing this SLO.
        :param pulumi.Input[float] goal: The fraction of service that must be good in order for this objective
               to be met. 0 < goal <= 0.999
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[dict] request_based_sli: A request-based SLI defines a SLI for which atomic units of
               service are counted directly.
               A SLI describes a good service.
               It is used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.
        :param pulumi.Input[float] rolling_period_days: A rolling time period, semantically "in the past X days".
               Must be between 1 to 30 days, inclusive.
        :param pulumi.Input[str] service: ID of the service to which this SLO belongs.
        :param pulumi.Input[str] slo_id: The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        :param pulumi.Input[dict] windows_based_sli: A windows-based SLI defines the criteria for time windows.
               good_service is defined based off the count of these time windows
               for which the provided service was of good quality.
               A SLI describes a good service. It is used to measure and calculate
               the quality of the Service's performance with respect to a single
               aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.

        The **basic_sli** object supports the following:

          * `latency` (`pulumi.Input[dict]`) - Parameters for a latency threshold SLI.  Structure is documented below.
            * `threshold` (`pulumi.Input[str]`) - A duration string, e.g. 10s.
              Good service is defined to be the count of requests made to
              this service that return in no more than threshold.

          * `locations` (`pulumi.Input[list]`) - An optional set of locations to which this SLI is relevant.
            Telemetry from other locations will not be used to calculate
            performance for this SLI. If omitted, this SLI applies to all
            locations in which the Service has activity. For service types
            that don't support breaking down by location, setting this
            field will result in an error.
          * `methods` (`pulumi.Input[list]`) - An optional set of RPCs to which this SLI is relevant.
            Telemetry from other methods will not be used to calculate
            performance for this SLI. If omitted, this SLI applies to all
            the Service's methods. For service types that don't support
            breaking down by method, setting this field will result in an
            error.
          * `versions` (`pulumi.Input[list]`) - The set of API versions to which this SLI is relevant.
            Telemetry from other API versions will not be used to
            calculate performance for this SLI. If omitted,
            this SLI applies to all API versions. For service types
            that don't support breaking down by version, setting this
            field will result in an error.

        The **request_based_sli** object supports the following:

          * `distributionCut` (`pulumi.Input[dict]`) - Used when good_service is defined by a count of values aggregated in a
            Distribution that fall into a good range. The total_service is the
            total count of all values aggregated in the Distribution.
            Defines a distribution TimeSeries filter and thresholds used for
            measuring good service and total service.  Structure is documented below.
            * `distributionFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              aggregating values to quantify the good service provided.
              Must have ValueType = DISTRIBUTION and
              MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

          * `goodTotalRatio` (`pulumi.Input[dict]`) - A means to compute a ratio of `good_service` to `total_service`.
            Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
            Must specify exactly two of good, bad, and total service filters.
            The relationship good_service + bad_service = total_service
            will be assumed.  Structure is documented below.
            * `badServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying bad service provided, either demanded service that
              was not provided or demanded service that was of inadequate
              quality. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `goodServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying good service provided. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `totalServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying total demanded service. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.

        The **windows_based_sli** object supports the following:

          * `goodBadMetricFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
            with ValueType = BOOL. The window is good if any true values
            appear in the window. One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.
          * `goodTotalRatioThreshold` (`pulumi.Input[dict]`) - Criterion that describes a window as good if its performance is
            high enough. One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.  Structure is documented below.
            * `basicSliPerformance` (`pulumi.Input[dict]`) - Basic SLI to evaluate to judge window quality.  Structure is documented below.
              * `latency` (`pulumi.Input[dict]`) - Parameters for a latency threshold SLI.  Structure is documented below.
                * `threshold` (`pulumi.Input[str]`) - A duration string, e.g. 10s.
                  Good service is defined to be the count of requests made to
                  this service that return in no more than threshold.

              * `locations` (`pulumi.Input[list]`) - An optional set of locations to which this SLI is relevant.
                Telemetry from other locations will not be used to calculate
                performance for this SLI. If omitted, this SLI applies to all
                locations in which the Service has activity. For service types
                that don't support breaking down by location, setting this
                field will result in an error.
              * `methods` (`pulumi.Input[list]`) - An optional set of RPCs to which this SLI is relevant.
                Telemetry from other methods will not be used to calculate
                performance for this SLI. If omitted, this SLI applies to all
                the Service's methods. For service types that don't support
                breaking down by method, setting this field will result in an
                error.
              * `versions` (`pulumi.Input[list]`) - The set of API versions to which this SLI is relevant.
                Telemetry from other API versions will not be used to
                calculate performance for this SLI. If omitted,
                this SLI applies to all API versions. For service types
                that don't support breaking down by version, setting this
                field will result in an error.

            * `performance` (`pulumi.Input[dict]`) - Request-based SLI to evaluate to judge window quality.  Structure is documented below.
              * `distributionCut` (`pulumi.Input[dict]`) - Used when good_service is defined by a count of values aggregated in a
                Distribution that fall into a good range. The total_service is the
                total count of all values aggregated in the Distribution.
                Defines a distribution TimeSeries filter and thresholds used for
                measuring good service and total service.  Structure is documented below.
                * `distributionFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  aggregating values to quantify the good service provided.
                  Must have ValueType = DISTRIBUTION and
                  MetricKind = DELTA or MetricKind = CUMULATIVE.
                * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
                  will be the count of values x in the Distribution such
                  that range.min <= x < range.max. inclusive of min and
                  exclusive of max. Open ranges can be defined by setting
                  just one of min or max. Summed value `X` should satisfy
                  `range.min <= X < range.max` for a good window.  Structure is documented below.
                  * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                    will be set to "infinity", defining an open range
                    ">= range.min"
                  * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                    will be set to "-infinity", defining an open range
                    "< range.max"

              * `goodTotalRatio` (`pulumi.Input[dict]`) - A means to compute a ratio of `good_service` to `total_service`.
                Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
                Must specify exactly two of good, bad, and total service filters.
                The relationship good_service + bad_service = total_service
                will be assumed.  Structure is documented below.
                * `badServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  quantifying bad service provided, either demanded service that
                  was not provided or demanded service that was of inadequate
                  quality. Exactly two of
                  good, bad, or total service filter must be defined (where
                  good + bad = total is assumed)
                  Must have ValueType = DOUBLE or ValueType = INT64 and
                  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
                * `goodServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  quantifying good service provided. Exactly two of
                  good, bad, or total service filter must be defined (where
                  good + bad = total is assumed)
                  Must have ValueType = DOUBLE or ValueType = INT64 and
                  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
                * `totalServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  quantifying total demanded service. Exactly two of
                  good, bad, or total service filter must be defined (where
                  good + bad = total is assumed)
                  Must have ValueType = DOUBLE or ValueType = INT64 and
                  must have MetricKind = DELTA or MetricKind = CUMULATIVE.

            * `threshold` (`pulumi.Input[float]`) - A duration string, e.g. 10s.
              Good service is defined to be the count of requests made to
              this service that return in no more than threshold.

          * `metricMeanInRange` (`pulumi.Input[dict]`) - Criterion that describes a window as good if the metric's value
            is in a good range, *averaged* across returned streams.
            One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.
            Average value X of `time_series` should satisfy
            `range.min <= X < range.max` for a good window.  Structure is documented below.
            * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

            * `timeSeries` (`pulumi.Input[str]`) - A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              specifying the TimeSeries to use for evaluating window
              quality. The provided TimeSeries must have
              ValueType = INT64 or ValueType = DOUBLE and
              MetricKind = GAUGE.
              Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.

          * `metricSumInRange` (`pulumi.Input[dict]`) - Criterion that describes a window as good if the metric's value
            is in a good range, *summed* across returned streams.
            Summed value `X` of `time_series` should satisfy
            `range.min <= X < range.max` for a good window.
            One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.  Structure is documented below.
            * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

            * `timeSeries` (`pulumi.Input[str]`) - A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              specifying the TimeSeries to use for evaluating window
              quality. The provided TimeSeries must have
              ValueType = INT64 or ValueType = DOUBLE and
              MetricKind = GAUGE.
              Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.

          * `windowPeriod` (`pulumi.Input[str]`) - Duration over which window quality is evaluated, given as a
            duration string "{X}s" representing X seconds. Must be an
            integer fraction of a day and at least 60s.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['basic_sli'] = basic_sli
            __props__['calendar_period'] = calendar_period
            __props__['display_name'] = display_name
            if goal is None:
                raise TypeError("Missing required property 'goal'")
            __props__['goal'] = goal
            __props__['project'] = project
            __props__['request_based_sli'] = request_based_sli
            __props__['rolling_period_days'] = rolling_period_days
            if service is None:
                raise TypeError("Missing required property 'service'")
            __props__['service'] = service
            __props__['slo_id'] = slo_id
            __props__['windows_based_sli'] = windows_based_sli
            __props__['name'] = None
        super(Slo, __self__).__init__(
            'gcp:monitoring/slo:Slo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, basic_sli=None, calendar_period=None, display_name=None, goal=None, name=None, project=None, request_based_sli=None, rolling_period_days=None, service=None, slo_id=None, windows_based_sli=None):
        """
        Get an existing Slo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] basic_sli: Basic Service-Level Indicator (SLI) on a well-known service type.
               Performance will be computed on the basis of pre-defined metrics.
               SLIs are used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.
        :param pulumi.Input[str] calendar_period: A calendar period, semantically "since the start of the current
               <calendarPeriod>".
        :param pulumi.Input[str] display_name: Name used for UI elements listing this SLO.
        :param pulumi.Input[float] goal: The fraction of service that must be good in order for this objective
               to be met. 0 < goal <= 0.999
        :param pulumi.Input[str] name: The full resource name for this service. The syntax is:
               projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[dict] request_based_sli: A request-based SLI defines a SLI for which atomic units of
               service are counted directly.
               A SLI describes a good service.
               It is used to measure and calculate the quality of the Service's
               performance with respect to a single aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.
        :param pulumi.Input[float] rolling_period_days: A rolling time period, semantically "in the past X days".
               Must be between 1 to 30 days, inclusive.
        :param pulumi.Input[str] service: ID of the service to which this SLO belongs.
        :param pulumi.Input[str] slo_id: The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
        :param pulumi.Input[dict] windows_based_sli: A windows-based SLI defines the criteria for time windows.
               good_service is defined based off the count of these time windows
               for which the provided service was of good quality.
               A SLI describes a good service. It is used to measure and calculate
               the quality of the Service's performance with respect to a single
               aspect of service quality.
               Exactly one of the following must be set:
               `basic_sli`, `request_based_sli`, `windows_based_sli`  Structure is documented below.

        The **basic_sli** object supports the following:

          * `latency` (`pulumi.Input[dict]`) - Parameters for a latency threshold SLI.  Structure is documented below.
            * `threshold` (`pulumi.Input[str]`) - A duration string, e.g. 10s.
              Good service is defined to be the count of requests made to
              this service that return in no more than threshold.

          * `locations` (`pulumi.Input[list]`) - An optional set of locations to which this SLI is relevant.
            Telemetry from other locations will not be used to calculate
            performance for this SLI. If omitted, this SLI applies to all
            locations in which the Service has activity. For service types
            that don't support breaking down by location, setting this
            field will result in an error.
          * `methods` (`pulumi.Input[list]`) - An optional set of RPCs to which this SLI is relevant.
            Telemetry from other methods will not be used to calculate
            performance for this SLI. If omitted, this SLI applies to all
            the Service's methods. For service types that don't support
            breaking down by method, setting this field will result in an
            error.
          * `versions` (`pulumi.Input[list]`) - The set of API versions to which this SLI is relevant.
            Telemetry from other API versions will not be used to
            calculate performance for this SLI. If omitted,
            this SLI applies to all API versions. For service types
            that don't support breaking down by version, setting this
            field will result in an error.

        The **request_based_sli** object supports the following:

          * `distributionCut` (`pulumi.Input[dict]`) - Used when good_service is defined by a count of values aggregated in a
            Distribution that fall into a good range. The total_service is the
            total count of all values aggregated in the Distribution.
            Defines a distribution TimeSeries filter and thresholds used for
            measuring good service and total service.  Structure is documented below.
            * `distributionFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              aggregating values to quantify the good service provided.
              Must have ValueType = DISTRIBUTION and
              MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

          * `goodTotalRatio` (`pulumi.Input[dict]`) - A means to compute a ratio of `good_service` to `total_service`.
            Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
            Must specify exactly two of good, bad, and total service filters.
            The relationship good_service + bad_service = total_service
            will be assumed.  Structure is documented below.
            * `badServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying bad service provided, either demanded service that
              was not provided or demanded service that was of inadequate
              quality. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `goodServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying good service provided. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.
            * `totalServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              quantifying total demanded service. Exactly two of
              good, bad, or total service filter must be defined (where
              good + bad = total is assumed)
              Must have ValueType = DOUBLE or ValueType = INT64 and
              must have MetricKind = DELTA or MetricKind = CUMULATIVE.

        The **windows_based_sli** object supports the following:

          * `goodBadMetricFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
            with ValueType = BOOL. The window is good if any true values
            appear in the window. One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.
          * `goodTotalRatioThreshold` (`pulumi.Input[dict]`) - Criterion that describes a window as good if its performance is
            high enough. One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.  Structure is documented below.
            * `basicSliPerformance` (`pulumi.Input[dict]`) - Basic SLI to evaluate to judge window quality.  Structure is documented below.
              * `latency` (`pulumi.Input[dict]`) - Parameters for a latency threshold SLI.  Structure is documented below.
                * `threshold` (`pulumi.Input[str]`) - A duration string, e.g. 10s.
                  Good service is defined to be the count of requests made to
                  this service that return in no more than threshold.

              * `locations` (`pulumi.Input[list]`) - An optional set of locations to which this SLI is relevant.
                Telemetry from other locations will not be used to calculate
                performance for this SLI. If omitted, this SLI applies to all
                locations in which the Service has activity. For service types
                that don't support breaking down by location, setting this
                field will result in an error.
              * `methods` (`pulumi.Input[list]`) - An optional set of RPCs to which this SLI is relevant.
                Telemetry from other methods will not be used to calculate
                performance for this SLI. If omitted, this SLI applies to all
                the Service's methods. For service types that don't support
                breaking down by method, setting this field will result in an
                error.
              * `versions` (`pulumi.Input[list]`) - The set of API versions to which this SLI is relevant.
                Telemetry from other API versions will not be used to
                calculate performance for this SLI. If omitted,
                this SLI applies to all API versions. For service types
                that don't support breaking down by version, setting this
                field will result in an error.

            * `performance` (`pulumi.Input[dict]`) - Request-based SLI to evaluate to judge window quality.  Structure is documented below.
              * `distributionCut` (`pulumi.Input[dict]`) - Used when good_service is defined by a count of values aggregated in a
                Distribution that fall into a good range. The total_service is the
                total count of all values aggregated in the Distribution.
                Defines a distribution TimeSeries filter and thresholds used for
                measuring good service and total service.  Structure is documented below.
                * `distributionFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  aggregating values to quantify the good service provided.
                  Must have ValueType = DISTRIBUTION and
                  MetricKind = DELTA or MetricKind = CUMULATIVE.
                * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
                  will be the count of values x in the Distribution such
                  that range.min <= x < range.max. inclusive of min and
                  exclusive of max. Open ranges can be defined by setting
                  just one of min or max. Summed value `X` should satisfy
                  `range.min <= X < range.max` for a good window.  Structure is documented below.
                  * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                    will be set to "infinity", defining an open range
                    ">= range.min"
                  * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                    will be set to "-infinity", defining an open range
                    "< range.max"

              * `goodTotalRatio` (`pulumi.Input[dict]`) - A means to compute a ratio of `good_service` to `total_service`.
                Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
                Must specify exactly two of good, bad, and total service filters.
                The relationship good_service + bad_service = total_service
                will be assumed.  Structure is documented below.
                * `badServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  quantifying bad service provided, either demanded service that
                  was not provided or demanded service that was of inadequate
                  quality. Exactly two of
                  good, bad, or total service filter must be defined (where
                  good + bad = total is assumed)
                  Must have ValueType = DOUBLE or ValueType = INT64 and
                  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
                * `goodServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  quantifying good service provided. Exactly two of
                  good, bad, or total service filter must be defined (where
                  good + bad = total is assumed)
                  Must have ValueType = DOUBLE or ValueType = INT64 and
                  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
                * `totalServiceFilter` (`pulumi.Input[str]`) - A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
                  quantifying total demanded service. Exactly two of
                  good, bad, or total service filter must be defined (where
                  good + bad = total is assumed)
                  Must have ValueType = DOUBLE or ValueType = INT64 and
                  must have MetricKind = DELTA or MetricKind = CUMULATIVE.

            * `threshold` (`pulumi.Input[float]`) - A duration string, e.g. 10s.
              Good service is defined to be the count of requests made to
              this service that return in no more than threshold.

          * `metricMeanInRange` (`pulumi.Input[dict]`) - Criterion that describes a window as good if the metric's value
            is in a good range, *averaged* across returned streams.
            One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.
            Average value X of `time_series` should satisfy
            `range.min <= X < range.max` for a good window.  Structure is documented below.
            * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

            * `timeSeries` (`pulumi.Input[str]`) - A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              specifying the TimeSeries to use for evaluating window
              quality. The provided TimeSeries must have
              ValueType = INT64 or ValueType = DOUBLE and
              MetricKind = GAUGE.
              Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.

          * `metricSumInRange` (`pulumi.Input[dict]`) - Criterion that describes a window as good if the metric's value
            is in a good range, *summed* across returned streams.
            Summed value `X` of `time_series` should satisfy
            `range.min <= X < range.max` for a good window.
            One of `good_bad_metric_filter`,
            `good_total_ratio_threshold`, `metric_mean_in_range`,
            `metric_sum_in_range` must be set for `windows_based_sli`.  Structure is documented below.
            * `range` (`pulumi.Input[dict]`) - Range of numerical values. The computed good_service
              will be the count of values x in the Distribution such
              that range.min <= x < range.max. inclusive of min and
              exclusive of max. Open ranges can be defined by setting
              just one of min or max. Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.  Structure is documented below.
              * `max` (`pulumi.Input[float]`) - max value for the range (inclusive). If not given,
                will be set to "infinity", defining an open range
                ">= range.min"
              * `min` (`pulumi.Input[float]`) - Min value for the range (inclusive). If not given,
                will be set to "-infinity", defining an open range
                "< range.max"

            * `timeSeries` (`pulumi.Input[str]`) - A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
              specifying the TimeSeries to use for evaluating window
              quality. The provided TimeSeries must have
              ValueType = INT64 or ValueType = DOUBLE and
              MetricKind = GAUGE.
              Summed value `X` should satisfy
              `range.min <= X < range.max` for a good window.

          * `windowPeriod` (`pulumi.Input[str]`) - Duration over which window quality is evaluated, given as a
            duration string "{X}s" representing X seconds. Must be an
            integer fraction of a day and at least 60s.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["basic_sli"] = basic_sli
        __props__["calendar_period"] = calendar_period
        __props__["display_name"] = display_name
        __props__["goal"] = goal
        __props__["name"] = name
        __props__["project"] = project
        __props__["request_based_sli"] = request_based_sli
        __props__["rolling_period_days"] = rolling_period_days
        __props__["service"] = service
        __props__["slo_id"] = slo_id
        __props__["windows_based_sli"] = windows_based_sli
        return Slo(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
