"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrdsDB = exports.DrdsDBProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const drds_generated_1 = require("./drds.generated");
Object.defineProperty(exports, "DrdsDBProperty", { enumerable: true, get: function () { return drds_generated_1.RosDrdsDB; } });
/**
 * A ROS resource type:  `ALIYUN::DRDS::DrdsDB`
 */
class DrdsDB extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::DRDS::DrdsDB`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDrdsDB = new drds_generated_1.RosDrdsDB(this, id, {
            dbInstType: props.dbInstType,
            type: props.type === undefined || props.type === null ? 'HORIZONTAL' : props.type,
            drdsInstanceId: props.drdsInstanceId,
            rdsInstance: props.rdsInstance,
            dbInstanceIsCreating: props.dbInstanceIsCreating,
            instDbName: props.instDbName,
            dbName: props.dbName,
            encode: props.encode,
            accountName: props.accountName,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDrdsDB;
    }
}
exports.DrdsDB = DrdsDB;
//# sourceMappingURL=data:application/json;base64,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