"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrdsInstance = exports.DrdsInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const drds_generated_1 = require("./drds.generated");
Object.defineProperty(exports, "DrdsInstanceProperty", { enumerable: true, get: function () { return drds_generated_1.RosDrdsInstance; } });
/**
 * A ROS resource type:  `ALIYUN::DRDS::DrdsInstance`
 */
class DrdsInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::DRDS::DrdsInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDrdsInstance = new drds_generated_1.RosDrdsInstance(this, id, {
            description: props.description,
            zoneId: props.zoneId,
            pricingCycle: props.pricingCycle,
            instanceSeries: props.instanceSeries,
            quantity: props.quantity,
            specification: props.specification,
            duration: props.duration,
            payType: props.payType,
            vswitchId: props.vswitchId,
            type: props.type,
            mySqlVersion: props.mySqlVersion === undefined || props.mySqlVersion === null ? '5' : props.mySqlVersion,
            vpcId: props.vpcId,
            isAutoRenew: props.isAutoRenew,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDrdsInstance;
        this.attrDrdsInstanceId = rosDrdsInstance.attrDrdsInstanceId;
        this.attrInternetEndpoint = rosDrdsInstance.attrInternetEndpoint;
        this.attrIntranetEndpoint = rosDrdsInstance.attrIntranetEndpoint;
        this.attrOrderId = rosDrdsInstance.attrOrderId;
    }
}
exports.DrdsInstance = DrdsInstance;
//# sourceMappingURL=data:application/json;base64,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