from antx import transfer
import pytest


@pytest.fixture(scope="module")
def source_text():
    return """[1a]
[1a.1]༄༅། །མདོ་སྡེ་ཧ་པ་བཞུགས་སོ། །
[1b]
[1b.1]{D340}༄༅༅། །རྒྱ་གར་སྐད་དུ། ཀརྨ་ཤ་ཏ་ཀ། བོད་སྐད་དུ། ལས་བརྒྱ་ཐམ་པ་པ། བམ་པོ་དང་པོ། ཐམས་ཅད་མཁྱེན་པ་ལ་ཕྱག་འཚལ་ལོ། །གང་ལས་
[1b.2]འཇིག་རྟེན་བླ་མ་བདེ་གཤེགས་ཐོས་པའི་སྒོ་ནས་རབ་སྙན་བརྟན་པའི་གསུང་ལྡན་གྱིས། །སེམས་ཅན་རྣམས་ལ་ཕན་པ་འབའ་ཞིག་བཞེད་ཕྱིར་བཤད་པ་རྣམ་པ་སྣ་ཚོགས་རང་ཉིད་ཀྱིས། །
[1b.3]ལོག་པར་ལྟ་བའི་མུན་ནག་ཆེན་པོ་ཐིབས་པོར་འཐོམས་ཤིང་འཁྲུགས་པ་རྣམས་ལ་རབ་གསུངས་པ། །དེ་ཡི་མིང་ནི་ལས་རྣམ་བརྒྱ་པ་ཞེས་བྱ་ཡོངས་སུ་ཚང་བ་བདག་གིས་བཤད་ཀྱིས་
[1b.4]ཉོན། །སྤྱི་སྡོམ་ནི། ཁྱི་མོ་དང་ནི་ཤིང་རྟ་དང་། །ཀ་ཙང་ཀ་ལ་བྱམས་མི་སྡུག །བྱ་དང་འཕྱེ་བོ་གང་པོ་དང་། །བུ་རྣམས་དང་ནི་བརྒྱ་བྱིན་ནོ། །སྡོམ་ནི། ཁྱི་མོ་མིག་ཆུང་
[1b.5]རྫོགས་བྱེད་དང་། །སྒུར་གཉིས་འཆར་ཀ་རྒྱལ་མཚན་དང་། 񉏠།བདེ་བྱེད་མ་དང་ནོར་བུའི་འོད། །སྣ་མའི་མེ་ཏོག་ང་བྱིན་དང་། །འདུས་མོ་དང་ནི་ཚེམ་བུ་མཁན། །ཁྱི་མོ་ཞེས་བྱ་
[2a]
[2a.1]བ་ནི། གླེང་གཞི་མཉན་དུ་ཡོད་པ་ན་བཞུགས་ཏེ། དེའི་ཚེ་མཉན་དུ་ཡོད་པ་ན། ཁྱིམ་བདག་ཕྱུག་ཅིང་ནོར་མང་ལ་ལོངས་སྤྱོད་ཆེ་བ་ཡོངས་སུ་འཛིན་པ་ཡངས་ཤིང་རྒྱ་ཆེ་བ། རྣམ་ཐོས་ཀྱི་བུའི་ནོར་དང་ལྡན་པ། རྣམ་ཐོས་ཀྱི་བུའི་ནོར་དང་འགྲན་
[2a.2]པ་ཞིག་གནས་ཏེ། མུ་སྟེགས་ཅན་ལ་དགའོ། །དེ་ནས་དེས་ཐབས་ཟླར་བབ་པ་ལས་ཆུང་མ་བླངས་ནས། དེ་དེ་དང་ལྷན་ཅིག་ཏུ་རྩེ་ཞིང་དགའ་ལ་དགའ་མགུར་སྤྱོད་དོ། །དེ་རྩེ་ཞིང་དགའ་ལ་དགའ་མགུར་སྤྱོད་པ་ལས་ཕྱིས་དེའི་ཆུང་མ་ལ་བུ་ཆགས་ནས་དེ་ཟླ་བ་དགུའམ་
"""


@pytest.fixture(scope="module")
def target_text():
    return """༄༅#
༅། །རྒྱ་གར་སྐད་དུ། ཀརྨ་ཤ་ཏ་ཀ། བོད་སྐད་དུ། ལས་བརྒྱ་
ཐམ་པ་པ། བམ་པོ་དང་པོ། ཐམས་ཅད་མཁྱེན་པ་ལ་ཕྱག་འཚལ་ལོ། །གང་
ལས་འཇིག་རྟེན་བླ་མ་བདེ་གཤེགས་ཐོས་པའི་སྒོ་ནས་རབ་སྙན་བརྟན་པའི་གསུང་
ལྡན་གྱིས། །སེམས་ཅན་རྣམས་ལ་ཕན་པ་འབའ་ཞིག་བཞེད་ཕྱིར་བཤད་པ་རྣམ་
པ་སྣ་ཚོགས་རང་ཉིད་ཀྱིས། །ལོག་པར་ལྟ་བའི་མུན་ནག་ཆེན་པོ་ཐིབས་པོར་
:འཐོམས་ཤིང#་འཁྲུགས་པ་རྣམས་ལ་རབ་གསུངས་པ། །:དེ་ཡི་#མིང་ནི་ལས་
རྣམ་#བརྒྱ་པ་ཞེས་བྱ་ཡོངས་སུ་ཚང་བ་བདག་གིས་བཤད་ཀྱིས་#ཉོན། །སྤྱི་སྡོམ་
ནི། ཁྱི་མོ་དང་ནི་ཤིང་རྟ་དང་། །ཀ་ཙང་#ཀ་ལ་བྱམས་མི་སྡུག །བྱ་དང་འཕྱེ་
བོ་#གང་པོ་དང་། །བུ་རྣམས་དང་ནི་བརྒྱ་བྱིན་ནོ། །སྡོམ་ནི། ཁྱི་མོ་མིག་ཆུང་#
རྫོགས་བྱེད་དང་། །སྒུར་གཉིས་འཆར་ཀ་རྒྱལ་མཚན་#དང་། །བདེ་བྱེད་མ་
དང་ནོར་བུའི་འོད། །སྣ་མའི་མེ་ཏོག་ང་#བྱིན་དང་། །འདུས་མོ་དང་ནི་ཚེམ་བུ་
མཁན། །ཁྱི་མོ་ཞེས་བྱ་བ་ནི། གླེང་:གཞི་མཉན་དུ་ཡོད་པ་ན་བཞུགས་ཏེ།
དེའི་ཚེ་མཉན་དུ་ཡོད་པ་ན། ཁྱིམ་བདག་ཕྱུག་ཅིང་ནོར་མང་ལ་ལོངས་སྤྱོད་ཆེ་
བ་ཡོངས་སུ་འཛིན་པ་ཡངས་ཤིང་རྒྱ་ཆེ་བ། རྣམ་ཐོས་ཀྱི་བུའི་ནོར་དང་ལྡན་པ།
རྣམ་ཐོས་ཀྱི་བུའི་ནོར་དང་འགྲན་པ་ཞིག་གནས་ཏེ། མུ་སྟེགས་ཅན་ལ་དགའོ། །
དེ་ནས་དེས་ཐབས་ཟླར་བབ་པ་ལས་ཆུང་#མ་བླངས་ནས། དེ་དེ་དང་ལྷན་ཅིག་
ཏུ་རྩེ་ཞིང་དགའ་ལ་དགའ་མགུར་སྤྱོད་དོ། །དེ་རྩེ་ཞིང་དགའ་ལ་དགའ་མགུར་
སྤྱོད་པ་ལས་ཕྱིས་དེའི་ཆུང་མ་ལ་#བུ་ཆགས་ནས་དེ་ཟླ་བ་དགུའམ་བཅུ་ལོན་པ་
"""


@pytest.fixture(scope="module")
def annotation_patterns():
    return [["pages", "(\[\d+[ab]\])"], ["lines", "\[\d+.\.\d\]"]]


def test_ann_transfer(source_text, target_text, annotation_patterns):
    annotated = transfer(source_text, annotation_patterns, target_text, "txt")
    assert (
        annotated
        == """[1a]༄༅#
[1b]༅། །རྒྱ་གར་སྐད་དུ། ཀརྨ་ཤ་ཏ་ཀ། བོད་སྐད་དུ། ལས་བརྒྱ་
ཐམ་པ་པ། བམ་པོ་དང་པོ། ཐམས་ཅད་མཁྱེན་པ་ལ་ཕྱག་འཚལ་ལོ། །གང་
ལས་འཇིག་རྟེན་བླ་མ་བདེ་གཤེགས་ཐོས་པའི་སྒོ་ནས་རབ་སྙན་བརྟན་པའི་གསུང་
ལྡན་གྱིས། །སེམས་ཅན་རྣམས་ལ་ཕན་པ་འབའ་ཞིག་བཞེད་ཕྱིར་བཤད་པ་རྣམ་
པ་སྣ་ཚོགས་རང་ཉིད་ཀྱིས། །ལོག་པར་ལྟ་བའི་མུན་ནག་ཆེན་པོ་ཐིབས་པོར་
:འཐོམས་ཤིང#་འཁྲུགས་པ་རྣམས་ལ་རབ་གསུངས་པ། །:དེ་ཡི་#མིང་ནི་ལས་
རྣམ་#བརྒྱ་པ་ཞེས་བྱ་ཡོངས་སུ་ཚང་བ་བདག་གིས་བཤད་ཀྱིས་#ཉོན། །སྤྱི་སྡོམ་
ནི། ཁྱི་མོ་དང་ནི་ཤིང་རྟ་དང་། །ཀ་ཙང་#ཀ་ལ་བྱམས་མི་སྡུག །བྱ་དང་འཕྱེ་
བོ་#གང་པོ་དང་། །བུ་རྣམས་དང་ནི་བརྒྱ་བྱིན་ནོ། །སྡོམ་ནི། ཁྱི་མོ་མིག་ཆུང་#
རྫོགས་བྱེད་དང་། །སྒུར་གཉིས་འཆར་ཀ་རྒྱལ་མཚན་#དང་། །བདེ་བྱེད་མ་
དང་ནོར་བུའི་འོད། །སྣ་མའི་མེ་ཏོག་ང་#བྱིན་དང་། །འདུས་མོ་དང་ནི་ཚེམ་བུ་
མཁན། །ཁྱི་མོ་ཞེས་བྱ་[2a]བ་ནི། གླེང་:གཞི་མཉན་དུ་ཡོད་པ་ན་བཞུགས་ཏེ།
དེའི་ཚེ་མཉན་དུ་ཡོད་པ་ན། ཁྱིམ་བདག་ཕྱུག་ཅིང་ནོར་མང་ལ་ལོངས་སྤྱོད་ཆེ་
བ་ཡོངས་སུ་འཛིན་པ་ཡངས་ཤིང་རྒྱ་ཆེ་བ། རྣམ་ཐོས་ཀྱི་བུའི་ནོར་དང་ལྡན་པ།
རྣམ་ཐོས་ཀྱི་བུའི་ནོར་དང་འགྲན་པ་ཞིག་གནས་ཏེ། མུ་སྟེགས་ཅན་ལ་དགའོ། །
དེ་ནས་དེས་ཐབས་ཟླར་བབ་པ་ལས་ཆུང་#མ་བླངས་ནས། དེ་དེ་དང་ལྷན་ཅིག་
ཏུ་རྩེ་ཞིང་དགའ་ལ་དགའ་མགུར་སྤྱོད་དོ། །དེ་རྩེ་ཞིང་དགའ་ལ་དགའ་མགུར་
སྤྱོད་པ་ལས་ཕྱིས་དེའི་ཆུང་མ་ལ་#བུ་ཆགས་ནས་དེ་ཟླ་བ་དགུའམ་བཅུ་ལོན་པ་
"""
    )
