/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.databases.Bucket;
import no.priv.garshol.duke.databases.InMemoryKeyValueStore;
import no.priv.garshol.duke.databases.KeyValueStore;
import no.priv.garshol.duke.utils.StringUtils;

public class KeyValueDatabase
implements Database {
    private Configuration config;
    private KeyValueStore store = new InMemoryKeyValueStore();
    private int max_search_hits = 1000000;
    private float min_relevance;
    private static final boolean DEBUG = false;
    private static final int CUTOFF_FACTOR_1 = 20;
    private static final int CUTOFF_FACTOR_2 = 50;

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
    }

    public void setMaxSearchHits(int max_search_hits) {
        this.max_search_hits = max_search_hits;
    }

    public void setMinRelevance(float min_relevance) {
        this.min_relevance = min_relevance;
    }

    @Override
    public boolean isInMemory() {
        return this.store.isInMemory();
    }

    @Override
    public void index(Record record) {
        long id = this.store.makeNewRecordId();
        this.store.registerRecord(id, record);
        for (Property p : this.config.getIdentityProperties()) {
            for (String extid : record.getValues(p.getName())) {
                this.store.registerId(id, extid);
            }
        }
        for (Property p : this.config.getLookupProperties()) {
            String propname = p.getName();
            for (String value : record.getValues(propname)) {
                String[] tokens = StringUtils.split(value);
                for (int ix = 0; ix < tokens.length; ++ix) {
                    this.store.registerToken(id, propname, tokens[ix]);
                }
            }
        }
    }

    @Override
    public Record findRecordById(String id) {
        return this.store.findRecordById(id);
    }

    @Override
    public Collection<Record> findCandidateMatches(Record record) {
        List<Bucket> buckets = this.lookup(record);
        Collections.sort(buckets);
        double score_sum = 0.0;
        for (Bucket b : buckets) {
            score_sum += b.getScore();
        }
        double score_so_far = 0.0;
        int threshold = buckets.size() - 1;
        while (score_so_far / score_sum < (double)this.min_relevance) {
            score_so_far += buckets.get(threshold).getScore();
            --threshold;
        }
        HashMap<Long, Score> candidates = new HashMap<Long, Score>();
        int next_bucket = this.collectCandidates(candidates, buckets, ++threshold);
        this.bumpScores(candidates, buckets, next_bucket);
        if (this.max_search_hits > candidates.size() && (double)this.min_relevance == 0.0) {
            ArrayList<Record> cands = new ArrayList<Record>(candidates.size());
            for (Long id : candidates.keySet()) {
                cands.add(this.store.findRecordById(id));
            }
            return cands;
        }
        int ix = 0;
        Score[] scores = new Score[candidates.size()];
        double max_score = 0.0;
        for (Score s : candidates.values()) {
            scores[ix++] = s;
            if (!(s.score > max_score)) continue;
            max_score = s.score;
        }
        candidates = null;
        PriorityQueue pq = new PriorityQueue(scores);
        int count = Math.min(scores.length, this.max_search_hits);
        ArrayList<Record> records = new ArrayList<Record>(count);
        for (ix = 0; ix < count; ++ix) {
            Score s = pq.next();
            if (!(s.score >= (double)this.min_relevance)) continue;
            records.add(this.store.findRecordById(s.id));
        }
        return records;
    }

    @Override
    public void commit() {
        this.store.commit();
    }

    @Override
    public void close() {
        this.store.close();
    }

    public String toString() {
        return "KeyValueDatabase(" + this.store + "), max_search_hits=" + this.max_search_hits + ", min_relevance=" + this.min_relevance;
    }

    private void bumpScores(Map<Long, Score> candidates, List<Bucket> buckets, int ix) {
        while (ix < buckets.size()) {
            Bucket b = buckets.get(ix);
            if (b.nextfree > 50 * candidates.size()) {
                return;
            }
            double score = b.getScore();
            for (Score s : candidates.values()) {
                if (!b.contains(s.id)) continue;
                s.score += score;
            }
            ++ix;
        }
    }

    private int collectCandidates(Map<Long, Score> candidates, List<Bucket> buckets, int threshold) {
        int ix;
        for (ix = 0; ix < threshold && candidates.size() < 20 * this.max_search_hits; ++ix) {
            Bucket b = buckets.get(ix);
            long[] ids = b.records;
            double score = b.getScore();
            for (int ix2 = 0; ix2 < b.nextfree; ++ix2) {
                Score s = candidates.get(ids[ix2]);
                if (s == null) {
                    s = new Score(ids[ix2]);
                    candidates.put(ids[ix2], s);
                }
                s.score += score;
            }
        }
        return ix;
    }

    private List<Bucket> lookup(Record record) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        for (Property p : this.config.getLookupProperties()) {
            String propname = p.getName();
            Collection<String> values = record.getValues(propname);
            if (values == null) continue;
            for (String value : values) {
                String[] tokens = StringUtils.split(value);
                for (int ix = 0; ix < tokens.length; ++ix) {
                    Bucket b = this.store.lookupToken(propname, tokens[ix]);
                    if (b == null || b.records == null) continue;
                    long[] ids = b.records;
                    buckets.add(b);
                }
            }
        }
        return buckets;
    }

    public static class PriorityQueue {
        private Score[] scores;
        private int size;

        public PriorityQueue(Score[] scores) {
            this.scores = scores;
            this.size = scores.length;
            this.build_heap();
        }

        private void build_heap() {
            for (int ix = this.size / 2; ix >= 0; --ix) {
                this.heapify(ix);
            }
        }

        private void heapify(int ix) {
            int left = ix * 2 + 1;
            if (left >= this.size) {
                return;
            }
            int right = left + 1;
            int largest = ix;
            if (this.scores[left].score > this.scores[ix].score) {
                largest = left;
            }
            if (right < this.size && this.scores[right].score > this.scores[largest].score) {
                largest = right;
            }
            if (largest != ix) {
                Score tmp = this.scores[largest];
                this.scores[largest] = this.scores[ix];
                this.scores[ix] = tmp;
                this.heapify(largest);
            }
        }

        public Score next() {
            Score next = this.scores[0];
            --this.size;
            if (this.size >= 0) {
                this.scores[0] = this.scores[this.size];
                this.scores[this.size] = null;
                this.heapify(0);
            }
            return next;
        }
    }

    public static class Score
    implements Comparable<Score> {
        public long id;
        public double score;

        public Score(long id) {
            this.id = id;
        }

        @Override
        public int compareTo(Score other) {
            if (other.score < this.score) {
                return -1;
            }
            if (other.score > this.score) {
                return 1;
            }
            return 0;
        }
    }
}

