/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.RecordBuilder;
import no.priv.garshol.duke.utils.SparqlClient;
import no.priv.garshol.duke.utils.SparqlResult;

public class SparqlDataSource
extends ColumnarDataSource {
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private String endpoint;
    private String query;
    private String username;
    private String password;
    protected int pagesize = 1000;
    private boolean triple_mode = true;

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPageSize(int pagesize) {
        this.pagesize = pagesize;
    }

    public void setTripleMode(boolean triple_mode) {
        this.triple_mode = triple_mode;
    }

    public int getPageSize() {
        return this.pagesize;
    }

    public boolean getTripleMode() {
        return this.triple_mode;
    }

    public String getQuery() {
        return this.query;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public RecordIterator getRecords() {
        this.verifyProperty(this.endpoint, "endpoint");
        this.verifyProperty(this.query, "query");
        if (this.triple_mode) {
            return new TripleModeIterator();
        }
        return new TabularIterator();
    }

    @Override
    public void writeConfig(ConfigWriter cw) {
        String name = "sparql";
        cw.writeStartElement("sparql", null);
        cw.writeParam("endpoint", this.getEndpoint());
        cw.writeParam("query", this.getQuery());
        cw.writeParam("page-size", this.getPageSize());
        cw.writeParam("triple-mode", this.getTripleMode());
        cw.writeParam("username", this.getUsername());
        cw.writeParam("password", this.getPassword());
        this.writeColumnsConfig(cw);
        cw.writeEndElement("sparql");
    }

    @Override
    protected String getSourceName() {
        return "SPARQL";
    }

    public SparqlResult runQuery(String endpoint, String query) {
        return SparqlClient.execute(endpoint, query, this.username, this.password);
    }

    class TabularIterator
    extends SparqlIterator {
        TabularIterator() {
        }

        @Override
        public Record next() {
            this.builder.newRecord();
            for (int colix = 0; colix < this.variables.size(); ++colix) {
                Collection cols = (Collection)SparqlDataSource.this.columns.get(this.variables.get(colix));
                if (cols == null) continue;
                for (Column col : cols) {
                    this.addValue(colix, col);
                }
            }
            ++this.pagerow;
            if (this.pagerow >= this.page.size()) {
                this.fetchNextPage();
            }
            return this.builder.getRecord();
        }
    }

    class TripleModeIterator
    extends SparqlIterator {
        TripleModeIterator() {
        }

        @Override
        public Record next() {
            String resource = ((String[])this.page.get(this.pagerow))[0];
            Collection cols = (Collection)SparqlDataSource.this.columns.get("?uri");
            if (cols == null) {
                throw new DukeConfigException("No '?uri' column. It's required in triple mode");
            }
            Column uricol = (Column)cols.iterator().next();
            this.builder.newRecord();
            this.builder.setValue(uricol, resource);
            while (this.pagerow < this.page.size() && resource.equals(((String[])this.page.get(this.pagerow))[0])) {
                while (this.pagerow < this.page.size() && resource.equals(((String[])this.page.get(this.pagerow))[0])) {
                    cols = (Collection)SparqlDataSource.this.columns.get(((String[])this.page.get(this.pagerow))[1]);
                    if (cols != null) {
                        for (Column col : cols) {
                            this.addValue(2, col);
                        }
                    }
                    ++this.pagerow;
                }
                if (this.pagerow < this.page.size()) continue;
                this.fetchNextPage();
            }
            return this.builder.getRecord();
        }
    }

    abstract class SparqlIterator
    extends RecordIterator {
        protected int pageno;
        protected int pagerow;
        protected List<String> variables;
        protected List<String[]> page;
        protected RecordBuilder builder;

        public SparqlIterator() {
            this.builder = new RecordBuilder(SparqlDataSource.this);
            this.fetchNextPage();
        }

        @Override
        public boolean hasNext() {
            return this.pagerow < this.page.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void fetchNextPage() {
            if (SparqlDataSource.this.pagesize == 0 && this.pageno > 0) {
                this.page = Collections.EMPTY_LIST;
                this.pagerow = 0;
                ++this.pageno;
                return;
            }
            String thisquery = SparqlDataSource.this.query;
            if (SparqlDataSource.this.pagesize != 0) {
                thisquery = thisquery + " limit " + SparqlDataSource.this.pagesize + " offset " + this.pageno * SparqlDataSource.this.pagesize;
            }
            if (SparqlDataSource.this.logger != null) {
                SparqlDataSource.this.logger.debug("SPARQL query: " + thisquery);
            }
            SparqlResult result = SparqlDataSource.this.runQuery(SparqlDataSource.this.endpoint, thisquery);
            this.variables = result.getVariables();
            this.page = result.getRows();
            if (SparqlDataSource.this.triple_mode && !this.page.isEmpty() && this.page.get(0).length != 3) {
                throw new DukeConfigException("In triple mode SPARQL queries must produce exactly three columns!");
            }
            if (SparqlDataSource.this.logger != null) {
                SparqlDataSource.this.logger.debug("SPARQL result rows: " + this.page.size());
            }
            this.pagerow = 0;
            ++this.pageno;
        }

        protected void addValue(int valueix, Column col) {
            if (col == null) {
                return;
            }
            String value = this.page.get(this.pagerow)[valueix];
            this.builder.addValue(col, value);
        }
    }
}

