/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.DukeConfigException;

public class CommandLineParser {
    private Map<String, Option> options = new HashMap<String, Option>();
    private Map<Character, Option> shortnames = new HashMap<Character, Option>();
    private int minargs;
    private int maxargs = 1000000;

    public String[] parse(String[] argv) throws CommandLineParserException {
        int pos;
        int ix;
        for (ix = 0; ix < argv.length && argv[ix].charAt(0) == '-'; ++ix) {
            Option option;
            String name;
            String value = null;
            pos = argv[ix].indexOf(61);
            boolean islong = argv[ix].startsWith("--");
            if (pos != -1) {
                value = argv[ix].substring(pos + 1);
                name = argv[ix].substring(islong ? 2 : 1, pos);
            } else {
                name = argv[ix].substring(islong ? 2 : 1);
            }
            if (islong) {
                option = this.getOption(name);
            } else {
                if (name.length() != 1) {
                    throw new CommandLineParserException("Option with single - had long name: " + name);
                }
                option = this.getOption(name.charAt(0));
            }
            if (option == null) {
                throw new CommandLineParserException("No such option: " + argv[ix] + " '" + name + "'");
            }
            if (option instanceof BooleanOption) {
                ((BooleanOption)option).turnon();
                if (value == null) continue;
                throw new CommandLineParserException("This option takes no value " + argv[ix]);
            }
            StringOption o = (StringOption)option;
            if (value == null) {
                throw new CommandLineParserException("No value for option " + argv[ix]);
            }
            o.setValue(value);
        }
        if (argv.length - ix < this.minargs) {
            throw new CommandLineParserException("Must have at least " + this.minargs + " arguments; got " + (argv.length - ix));
        }
        if (argv.length - ix > this.maxargs) {
            throw new CommandLineParserException("Can't have more than " + this.maxargs + " arguments; got " + (argv.length - ix));
        }
        String[] args = new String[argv.length - ix];
        pos = 0;
        while (ix < argv.length) {
            if (argv[ix].charAt(0) == '-') {
                throw new CommandLineParserException("Option " + argv[ix] + " appears after file arguments");
            }
            args[pos++] = argv[ix];
            ++ix;
        }
        return args;
    }

    public Option getOption(String longname) {
        return this.options.get(longname);
    }

    public Option getOption(char shortname) {
        return this.shortnames.get(Character.valueOf(shortname));
    }

    public boolean getOptionState(String longname) {
        return ((BooleanOption)this.options.get(longname)).getState();
    }

    public String getOptionValue(String longname) {
        return ((StringOption)this.options.get(longname)).getValue();
    }

    public int getOptionInteger(String longname, int defaultvalue) {
        String val = ((StringOption)this.options.get(longname)).getValue();
        if (val == null) {
            return defaultvalue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new DukeConfigException("Option --" + longname + " must be an integer, not '" + val + "'");
        }
    }

    public double getOptionDouble(String longname, double defaultvalue) {
        String val = ((StringOption)this.options.get(longname)).getValue();
        if (val == null) {
            return defaultvalue;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            throw new DukeConfigException("Option --" + longname + " must be a double, not '" + val + "'");
        }
    }

    public void setMinimumArguments(int minargs) {
        this.minargs = minargs;
    }

    public void setMaximumArguments(int maxargs) {
        this.maxargs = maxargs;
    }

    public void registerOption(Option option) {
        this.options.put(option.getLongname(), option);
        this.shortnames.put(Character.valueOf(option.getShortname()), option);
    }

    public void addStringOption(String longname, char shortname) {
        this.registerOption(new StringOption(longname, shortname));
    }

    public void addBooleanOption(String longname, char shortname) {
        this.registerOption(new BooleanOption(longname, shortname));
    }

    public static class CommandLineParserException
    extends RuntimeException {
        public CommandLineParserException(String msg) {
            super(msg);
        }
    }

    public static class StringOption
    extends Option {
        private String value;

        public StringOption(String longname, char shortname) {
            super(longname, shortname);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class BooleanOption
    extends Option {
        private boolean state;

        public BooleanOption(String longname, char shortname) {
            super(longname, shortname);
        }

        public BooleanOption(String longname) {
            super(longname);
        }

        public boolean getState() {
            return this.state;
        }

        public void turnon() {
            this.state = true;
        }
    }

    public static abstract class Option {
        private char shortname;
        private String longname;

        public Option(String longname) {
            this.longname = longname;
        }

        public Option(String longname, char shortname) {
            this.longname = longname;
            this.shortname = shortname;
        }

        public String getLongname() {
            return this.longname;
        }

        public char getShortname() {
            return this.shortname;
        }
    }
}

