/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.JDBCLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCLinkDatabaseTest {
    private JDBCLinkDatabase linkdb;

    @Before
    public void setup() {
        this.linkdb = new JDBCLinkDatabase("org.h2.Driver", "jdbc:h2:mem:", "h2", new Properties());
        this.linkdb.init();
    }

    @After
    public void cleanup() {
        this.linkdb.clear();
        this.linkdb.close();
    }

    @Test
    public void testBadDatabase() {
        try {
            new JDBCLinkDatabase("org.h2.Driver", "jdbc:h2:mem:", "unknowndb", new Properties());
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAllLinksForEmpty() {
        Assert.assertTrue((boolean)this.linkdb.getAllLinksFor("nonexistentid").isEmpty());
    }

    @Test
    public void testGetSinceForeverEmpty() {
        Assert.assertTrue((boolean)this.linkdb.getChangesSince(0L).isEmpty());
    }

    @Test
    public void testGetSinceForever() {
        Link ll2;
        Link ll1;
        Link l1 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        Link l2 = new Link("1", "3", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        List links = this.linkdb.getChangesSince(0L);
        Assert.assertEquals((int)2, (int)links.size());
        if (((Link)links.get(0)).equals((Object)l2)) {
            ll1 = (Link)links.get(1);
            ll2 = (Link)links.get(0);
        } else {
            ll1 = (Link)links.get(0);
            ll2 = (Link)links.get(1);
        }
        Assert.assertEquals((Object)l1, (Object)ll1);
        Assert.assertEquals((Object)l2, (Object)ll2);
    }

    @Test
    public void testGetSinceOnlyHalf() {
        Link l1 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        this.pause();
        long thetime = System.currentTimeMillis();
        this.pause();
        Link l2 = new Link("1", "3", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        List links = this.linkdb.getChangesSince(thetime);
        Assert.assertEquals((int)1, (int)links.size());
        Assert.assertEquals((Object)l2, links.get(0));
    }

    @Test
    public void testGetBeforeOnlyHalf() {
        Link l1 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        this.pause();
        long thetime = System.currentTimeMillis();
        this.pause();
        Link l2 = new Link("1", "3", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        List links = this.linkdb.getChangesSince(0L, thetime);
        Assert.assertEquals((int)1, (int)links.size());
        Assert.assertEquals((Object)l1, links.get(0));
    }

    @Test
    public void testGetBeforeAndSince() {
        long since = System.currentTimeMillis();
        this.pause();
        Link l1 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        this.pause();
        long before = System.currentTimeMillis();
        this.pause();
        Link l2 = new Link("1", "3", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        List links = this.linkdb.getChangesSince(since, before);
        Assert.assertEquals((int)1, (int)links.size());
        Assert.assertEquals((Object)l1, links.get(0));
    }

    @Test
    public void testGetPageOnlyOne() {
        Link l1 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        this.pause();
        Link l2 = new Link("1", "3", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        this.pause();
        Link l3 = new Link("1", "4", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l3);
        this.pause();
        Link l4 = new Link("1", "5", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l4);
        this.pause();
        this.pause();
        long thetime = System.currentTimeMillis();
        List links = this.linkdb.getChangesSince(0L, thetime + 200L, 1);
        Assert.assertEquals((int)1, (int)links.size());
        TestUtils.verifySame(l4, (Link)links.get(0));
    }

    @Test
    public void testOverride() {
        Link l1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        Link l2 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        List all = this.linkdb.getAllLinks();
        Assert.assertEquals((int)1, (int)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0), (Link)all.iterator().next());
    }

    @Test
    public void testOverride2() {
        Link l1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        this.linkdb.assertLink(l1);
        Link l2 = new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l2);
        List all = this.linkdb.getAllLinks();
        Assert.assertEquals((int)1, (int)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0), (Link)all.iterator().next());
    }

    private void pause() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

