/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.NumericComparator;
import org.junit.Before;
import org.junit.Test;

public class NumericComparatorTest {
    private NumericComparator comp;

    @Before
    public void setUp() {
        this.comp = new NumericComparator();
    }

    @Test
    public void testEqual() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("42", "42"));
    }

    @Test
    public void testEqual2() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("42.0", "42.0"));
    }

    @Test
    public void testHalf() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("21.0", "42.0"));
    }

    @Test
    public void testHalfInverted() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("42.0", "21.0"));
    }

    @Test
    public void testHalfBelowMin() {
        this.comp.setMinRatio(0.75);
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("21.0", "42.0"));
    }

    @Test
    public void testHalfAboveMin() {
        this.comp.setMinRatio(0.25);
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("21.0", "42.0"));
    }

    @Test
    public void testZero() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("0.0", "0.0"));
    }

    @Test
    public void testFirstIsZero() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("0.0", "42.0"));
    }

    @Test
    public void testSecondIsZero() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("42.0", "0.0"));
    }

    @Test
    public void testOneNegativeOnePositive() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("-1", "2"));
    }

    @Test
    public void testNegativeNumbers() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("-1", "-2"));
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("-2", "-1"));
    }
}

