/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.SoundexComparator;
import org.junit.Before;
import org.junit.Test;

public class SoundexComparatorTest {
    private SoundexComparator comp;

    @Test
    public void testEmpty() {
        this.check("", "");
    }

    @Test
    public void testSue() {
        this.check("S000", "Sue");
    }

    @Test
    public void testSUE() {
        this.check("S000", "SUE");
    }

    @Test
    public void testGarshol() {
        this.check("G624", "Garshol");
    }

    @Test
    public void testGARSHOL() {
        this.check("G624", "GARSHOL");
    }

    @Test
    public void testGarskol() {
        this.check("G624", "Garskol");
    }

    @Test
    public void testGARSKOL() {
        this.check("G624", "GARSKOL");
    }

    private void check(String key, String value) {
        Assert.assertEquals((String)("wrong key for '" + value + "'"), (String)key, (String)SoundexComparator.soundex((String)value));
    }

    @Before
    public void setup() {
        this.comp = new SoundexComparator();
    }

    @Test
    public void testEqual() {
        Assert.assertEquals((String)"wrong score for equal values", (Object)1.0, (Object)this.comp.compare("LMG", "LMG"));
    }

    @Test
    public void testEqualCode() {
        Assert.assertEquals((String)"wrong score for values with equal codes", (Object)0.9, (Object)this.comp.compare("Garshol", "Garskol"));
    }

    @Test
    public void testDifferentCode() {
        Assert.assertEquals((String)"wrong score for values with different codes", (Object)0.0, (Object)this.comp.compare("Garshol", "Sue"));
    }
}

