/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.ArrayList;
import junit.framework.Assert;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.InMemoryDataSource;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.Test;

public class InMemoryDataSourceTest {
    @Test
    public void testEmpty() {
        InMemoryDataSource src = new InMemoryDataSource();
        RecordIterator it = src.getRecords();
        Assert.assertFalse((String)"empty data source contains records", (boolean)it.hasNext());
    }

    @Test
    public void testSimple() {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1"));
        records.add(TestUtils.makeRecord("ID", "2"));
        records.add(TestUtils.makeRecord("ID", "3"));
        InMemoryDataSource src = new InMemoryDataSource(records);
        RecordIterator it = src.getRecords();
        Assert.assertTrue((String)"record missing", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong record", (String)((Record)it.next()).getValue("ID"), (String)"1");
        Assert.assertTrue((String)"record missing", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong record", (String)((Record)it.next()).getValue("ID"), (String)"2");
        Assert.assertTrue((String)"record missing", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong record", (String)((Record)it.next()).getValue("ID"), (String)"3");
        Assert.assertFalse((String)"too many records", (boolean)it.hasNext());
    }
}

