/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.SparqlDataSource;
import no.priv.garshol.duke.utils.SparqlResult;
import org.junit.Before;
import org.junit.Test;

public class SparqlDataSourceTest {
    private PagedTestSparqlDataSource source;
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final Pattern LIMIT = Pattern.compile("\\s+limit\\s+(\\d+)", 2);
    private static final Pattern OFFSET = Pattern.compile("\\s+offset\\s+(\\d+)", 2);

    @Before
    public void setup() {
        this.source = new PagedTestSparqlDataSource();
        this.source.setEndpoint("http://localhost:8890/sparql");
        this.source.setQuery("select * { where ?s ?p ?o }");
    }

    @Test
    public void testEmpty() {
        this.source.setVariables(new String[0]);
        this.source.setRows(new String[0][]);
        RecordIterator it = this.source.getRecords();
        Assert.assertFalse((String)"empty data source contains records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)1, (int)this.source.getPages());
    }

    @Test
    public void testTripleModeNoUri() {
        this.setupTripleConfig1("?url");
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}});
        try {
            RecordIterator it = this.source.getRecords();
            it.next();
            Assert.fail((String)"No config exception, despite missing '?uri' column");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testTripleModeFourColumns() {
        this.source.addColumn(new Column("?uri", "ID", null, null));
        this.source.addColumn(new Column("http://a/name", "NAME", null, null));
        this.source.addColumn(new Column("http://a/age", "AGE", null, null));
        this.source.addColumn(new Column("http://a/blubb", "BLUBB", null, null));
        this.source.setVariables(new String[]{"S", "P", "O", "C"});
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1", "blubb"}});
        try {
            RecordIterator it = this.source.getRecords();
            it.next();
            Assert.fail((String)"Didn't catch four result columns in triple mode");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    private void setupTripleConfig1(String urlcol) {
        this.source.addColumn(new Column(urlcol, "ID", null, null));
        this.source.addColumn(new Column("http://a/name", "NAME", null, null));
        this.source.addColumn(new Column("http://a/age", "AGE", null, null));
        this.source.setVariables(new String[]{"S", "P", "O"});
    }

    @Test
    public void testSingleTriple() {
        this.setupTripleConfig1("?uri");
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"1", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", null, (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than one record", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTwoTriples() {
        this.setupTripleConfig1("?uri");
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}, {"http://a/1", "http://a/age", "32"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"1", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"32", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than one record", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTwoRecords() {
        this.setupTripleConfig1("?uri");
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}, {"http://a/1", "http://a/age", "32"}, {"http://a/2", "http://a/name", "2"}, {"http://a/2", "http://a/age", "23"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"1", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"32", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"2", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"23", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than two records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTwoRecordsDoubleValue() {
        this.setupTripleConfig1("?uri");
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}, {"http://a/1", "http://a/name", "one"}, {"http://a/1", "http://a/age", "32"}, {"http://a/2", "http://a/name", "2"}, {"http://a/2", "http://a/age", "23"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong AGE", (String)"32", (String)r.getValue("AGE"));
        Collection values = r.getValues("NAME");
        Assert.assertEquals((String)"wrong number of NAMEs", (int)2, (int)values.size());
        Assert.assertTrue((String)"NAMEs doesn't contain '1'", (boolean)values.contains("1"));
        Assert.assertTrue((String)"NAMEs doesn't contain 'one'", (boolean)values.contains("one"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"2", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"23", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than two records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTripleMissingColumn() {
        this.setupTripleConfig1("?uri");
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}, {"http://a/1", "http://a/age", "32"}, {"http://a/1", "http://a/wtf", "whee"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"1", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"32", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than one record", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testThreeRecordsPaging1() {
        this.runThreeRecordsPaging(1, 7);
    }

    @Test
    public void testThreeRecordsPaging2() {
        this.runThreeRecordsPaging(2, 4);
    }

    @Test
    public void testThreeRecordsPaging3() {
        this.runThreeRecordsPaging(3, 3);
    }

    private void runThreeRecordsPaging(int pagesize, int pages) {
        this.setupTripleConfig1("?uri");
        this.source.setPageSize(pagesize);
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}, {"http://a/1", "http://a/age", "32"}, {"http://a/2", "http://a/name", "2"}, {"http://a/2", "http://a/age", "23"}, {"http://a/3", "http://a/name", "3"}, {"http://a/3", "http://a/age", "2323"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"1", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"32", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"2", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"23", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only two records", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/3", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"3", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"2323", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than three records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)pages, (int)this.source.getPages());
    }

    @Test
    public void testTripleModeNoPaging() {
        this.setupTripleConfig1("?uri");
        this.source.setPageSize(0);
        this.source.setRows(new String[][]{{"http://a/1", "http://a/name", "1"}, {"http://a/1", "http://a/age", "32"}, {"http://a/2", "http://a/name", "2"}, {"http://a/2", "http://a/age", "23"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"1", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"32", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"2", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"23", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than two records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)1, (int)this.source.getPages());
    }

    private void setupTabularConfig1() {
        this.source.setTripleMode(false);
        this.source.addColumn(new Column("ID", "ID", null, null));
        this.source.addColumn(new Column("NAME", "NAME", null, null));
        this.source.addColumn(new Column("AGE", "AGE", null, null));
        this.source.setVariables(new String[]{"ID", "NAME", "AGE"});
    }

    @Test
    public void testSingleRow() {
        this.setupTabularConfig1();
        this.source.setRows(new String[][]{{"http://a/1", "Peter", "15"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Peter", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"15", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than one record", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTwoRows() {
        this.setupTabularConfig1();
        this.source.setRows(new String[][]{{"http://a/1", "Peter", "15"}, {"http://a/2", "George", "151"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Peter", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"15", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"George", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"151", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than two records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTableModeMissingColumn() {
        this.setupTabularConfig1();
        this.source.setVariables(new String[]{"ID", "NAME", "AGE", "EXTRA"});
        this.source.setRows(new String[][]{{"http://a/1", "Peter", "15", "ignore"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Peter", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"15", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than one record", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)2, (int)this.source.getPages());
    }

    @Test
    public void testTableModePaging() {
        this.setupTabularConfig1();
        this.source.setPageSize(1);
        this.source.setRows(new String[][]{{"http://a/1", "Peter", "15"}, {"http://a/2", "George", "151"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Peter", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"15", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"George", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"151", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than two records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)3, (int)this.source.getPages());
    }

    @Test
    public void testTableModePaging3() {
        this.runTableModePageTest(1, 4);
    }

    @Test
    public void testTableModePaging3a() {
        this.runTableModePageTest(2, 3);
    }

    @Test
    public void testTableModePaging3b() {
        this.runTableModePageTest(3, 2);
    }

    private void runTableModePageTest(int pagesize, int pages) {
        this.setupTabularConfig1();
        this.source.setPageSize(pagesize);
        this.source.setRows(new String[][]{{"http://a/1", "Peter", "15"}, {"http://a/2", "George", "151"}, {"http://a/3", "Fluffy", "25151"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Peter", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"15", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"George", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"151", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only two records", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/3", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Fluffy", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"25151", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than three records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)pages, (int)this.source.getPages());
    }

    @Test
    public void testTableModeNoPaging() {
        this.setupTabularConfig1();
        this.source.setPageSize(0);
        this.source.setRows(new String[][]{{"http://a/1", "Peter", "15"}, {"http://a/2", "George", "151"}});
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((String)"data source contains no records", (boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/1", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"Peter", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"15", (String)r.getValue("AGE"));
        Assert.assertTrue((String)"data source contains only one record", (boolean)it.hasNext());
        r = (Record)it.next();
        Assert.assertEquals((String)"wrong ID", (String)"http://a/2", (String)r.getValue("ID"));
        Assert.assertEquals((String)"wrong NAME", (String)"George", (String)r.getValue("NAME"));
        Assert.assertEquals((String)"wrong AGE", (String)"151", (String)r.getValue("AGE"));
        Assert.assertFalse((String)"data source contains more than two records", (boolean)it.hasNext());
        Assert.assertEquals((String)"wrong number of pages", (int)1, (int)this.source.getPages());
    }

    class PagedTestSparqlDataSource
    extends SparqlDataSource {
        private String[] vars;
        private String[][] rows;
        private int pages;

        PagedTestSparqlDataSource() {
        }

        public void setVariables(String[] vars) {
            this.vars = vars;
        }

        public void setRows(String[][] rows) {
            this.rows = rows;
        }

        public SparqlResult runQuery(String endpoint, String query) {
            int limit = this.parseLimit(query);
            int offset = this.parseOffset(query);
            if (this.pagesize == 0) {
                Assert.assertTrue((String)"paging not truly disabled", (limit == -1 && offset == -1 ? 1 : 0) != 0);
            }
            SparqlResult result = new SparqlResult();
            for (String var : this.vars) {
                result.addVariable(var);
            }
            int end = limit == -1 ? this.rows.length : Math.min(offset + limit, this.rows.length);
            if (offset == -1) {
                offset = 0;
            }
            for (int ix = offset; ix < end; ++ix) {
                result.addRow(this.rows[ix]);
            }
            ++this.pages;
            return result;
        }

        public int getPages() {
            return this.pages;
        }

        private int parseLimit(String query) {
            Matcher m = LIMIT.matcher(query);
            if (!m.find()) {
                return -1;
            }
            return Integer.valueOf(m.group(1));
        }

        private int parseOffset(String query) {
            Matcher m = OFFSET.matcher(query);
            if (!m.find()) {
                return -1;
            }
            return Integer.valueOf(m.group(1));
        }
    }
}

