/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.integration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import no.priv.garshol.duke.Duke;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.utils.LinkDatabaseUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IT {
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();

    @Test
    public void testFailWithNoArguments() throws IOException {
        Result r = this.duke("");
        Assert.assertEquals((String)"didn't fail with error code", (long)1L, (long)r.code);
        Assert.assertTrue((String)("Duke gave no error message: " + r.out), (boolean)r.out.contains("ERROR:"));
    }

    @Test
    public void testShowMatches() throws IOException {
        Result r = this.duke("--showmatches doc/example-data/countries.xml");
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        Assert.assertTrue((String)"not enough matches", (r.countOccurrences("MATCH 0.") > 50 ? 1 : 0) != 0);
    }

    @Test
    public void testMakeLinkFile() throws IOException {
        File linkfile = this.tmpdir.newFile();
        Result r = this.duke("--showmatches --linkfile=\"" + linkfile.getAbsolutePath() + "\" doc/example-data/countries.xml");
        int outmatches = r.countOccurrences("MATCH 0.");
        LinkDatabase db = LinkDatabaseUtils.loadTestFile((String)linkfile.getAbsolutePath());
        Assert.assertEquals((String)"disagreement on number of matches", (long)outmatches, (long)db.getAllLinks().size());
    }

    @Test
    public void testShowData() throws IOException {
        Result r = this.duke("--showdata doc/example-data/countries.xml");
        Assert.assertEquals((String)"wrong number of IDs", (long)522L, (long)r.countOccurrences("ID: "));
        Assert.assertEquals((String)"wrong number of NAMEs", (long)522L, (long)r.countOccurrences("NAME: "));
        Assert.assertEquals((String)"wrong number of AREAs", (long)522L, (long)r.countOccurrences("AREA: "));
        Assert.assertEquals((String)"wrong number of CAPITALs", (long)522L, (long)r.countOccurrences("CAPITAL: "));
    }

    @Test
    @Ignore
    public void testTestFile() throws IOException {
        File linkfile = this.tmpdir.newFile();
        Result r = this.duke("--linkfile=\"" + linkfile.getAbsolutePath() + "\" doc/example-data/countries.xml");
        Assert.assertTrue((String)("couldn't write link file: " + r.out), (r.code == 0 ? 1 : 0) != 0);
        r = this.duke("--testfile=\"" + linkfile.getAbsolutePath() + "\" doc/example-data/countries.xml");
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        Assert.assertTrue((String)("Can't find precision output: " + r.out), (boolean)r.contains("Precision "));
    }

    @Test
    public void testGenetic() throws IOException {
        File cfgfile = this.tmpdir.newFile();
        Result r = this.genetic("--testfile=doc/example-data/countries-test.txt --generations=2 --output=" + cfgfile.getAbsolutePath() + " doc/example-data/countries.xml");
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        Assert.assertEquals((String)"Didn't run for 2 generations", (long)2L, (long)r.countOccurrences("BEST: "));
        float bestscore = r.floatAfterLast("BEST: ");
        Assert.assertTrue((String)"couldn't find a good solution", ((double)bestscore > 0.95 ? 1 : 0) != 0);
        r = this.duke("--testfile=doc/example-data/countries-test.txt --singlematch " + cfgfile.getAbsolutePath());
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        float realscore = r.floatAfterLast("f-number ");
    }

    @Test
    public void testGeneticActive() throws IOException {
        File cfgfile = this.tmpdir.newFile();
        Result r = this.genetic("--generations=4 --output=" + cfgfile.getAbsolutePath() + " --population=20 --testfile=doc/example-data/countries-test.txt --scientific doc/example-data/countries.xml");
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        Assert.assertEquals((String)"Didn't run for 4 generations", (long)4L, (long)r.countOccurrences("===== GENERATION "));
        float bestscore = r.floatAfterLast("ACTUAL BEST: ");
        Assert.assertTrue((String)"couldn't find a good solution", ((double)bestscore > 0.85 ? 1 : 0) != 0);
        r = this.duke("--testfile=doc/example-data/countries-test.txt --singlematch " + cfgfile.getAbsolutePath());
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        float realscore = r.floatAfterLast("f-number ");
    }

    @Test
    public void testDebugCompare() throws IOException {
        Result r = this.runjava("DebugCompare", "--reindex doc/example-data/countries.xml http://dbpedia.org/resource/Andorra 7021");
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        Assert.assertTrue((String)"didn't reindex", (boolean)r.contains("Reindexing"));
        Assert.assertTrue((String)"no mention of NAME", (boolean)r.contains("NAME"));
        Assert.assertTrue((String)"no mention of AREA", (boolean)r.contains("AREA"));
        Assert.assertTrue((String)"no mention of CAPITAL", (boolean)r.contains("CAPITAL"));
        Assert.assertTrue((String)"doesn't think Andorra is equal to itself", ((double)r.floatAfterLast("Overall: ") > 0.9 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testGeneticLong() throws IOException {
        Result r = this.genetic("--testfile=doc/example-data/countries-test.txt doc/example-data/countries.xml");
        Assert.assertEquals((String)("failed with error code: " + r.out), (long)0L, (long)r.code);
        Assert.assertEquals((String)"Didn't run for 100 generations", (long)100L, (long)r.countOccurrences("BEST: "));
        Assert.assertTrue((String)"couldn't find a good solution", ((double)r.floatAfterLast("BEST: ") > 0.95 ? 1 : 0) != 0);
    }

    private Result duke(String args) throws IOException {
        return this.runjava("Duke", args);
    }

    private Result genetic(String args) throws IOException {
        return this.runjava("genetic.Driver", args);
    }

    private Result runjava(String klass, String args) throws IOException {
        String jar = "target/duke-" + Duke.getVersion() + ".jar";
        String cmd = "java -cp " + jar + " no.priv.garshol.duke." + klass + " " + args;
        return this.run(cmd);
    }

    private Result run(String cmd) throws IOException {
        String line;
        Process p = Runtime.getRuntime().exec(cmd);
        StringBuilder tmp = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = r.readLine()) != null) {
            tmp.append(line + " ");
        }
        r.close();
        r = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = r.readLine()) != null) {
            tmp.append(line + " ");
        }
        r.close();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new Result(tmp.toString(), p.exitValue());
    }

    private static class Result {
        public String out;
        public int code;

        public Result(String out, int code) {
            this.out = out;
            this.code = code;
        }

        public int countOccurrences(String sub) {
            int pos = 0;
            int count = 0;
            while ((pos = this.out.indexOf(sub, pos)) != -1) {
                ++count;
                pos += sub.length();
            }
            return count;
        }

        public boolean contains(String sub) {
            return this.out.indexOf(sub) != -1;
        }

        public float floatAfterLast(String sub) {
            char ch;
            int ix;
            int postpos;
            int pos = 0;
            while ((postpos = this.out.indexOf(sub, pos)) != -1) {
                pos = postpos + sub.length();
            }
            for (ix = pos; ix < this.out.length() && ((ch = this.out.charAt(ix)) == '.' || ch >= '0' && ch <= '9'); ++ix) {
            }
            if (pos == ix) {
                throw new DukeException("Couldn't find float in " + this.out);
            }
            return Float.valueOf(this.out.substring(pos, ix)).floatValue();
        }

        public String toString() {
            return "[Run result, code " + this.code + ", output:\n" + this.out + "\n]";
        }
    }
}

