/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.JDBCLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordImpl;
import no.priv.garshol.duke.matchers.LinkDatabaseMatchListener;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkDatabaseMatchListenerTest {
    private LinkDatabase linkdb;
    private LinkDatabaseMatchListener listener;

    @Before
    public void setup() {
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("id"));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setProperties(props);
        config.setThreshold(0.45);
        this.linkdb = this.makeDatabase();
        if (this.linkdb instanceof JDBCLinkDatabase) {
            ((JDBCLinkDatabase)this.linkdb).init();
        }
        this.listener = new LinkDatabaseMatchListener((Configuration)config, this.linkdb);
    }

    protected LinkDatabase makeDatabase() {
        return new JDBCLinkDatabase("org.h2.Driver", "jdbc:h2:mem:", "h2", new Properties());
    }

    @After
    public void cleanup() {
        this.linkdb.clear();
        this.linkdb.close();
    }

    @Test
    public void testEmpty() {
        Assert.assertTrue((boolean)this.linkdb.getAllLinks().isEmpty());
    }

    @Test
    public void testEmptyRecord() {
        Record r1 = this.makeRecord();
        Record r2 = this.makeRecord("id", "2");
        try {
            this.listener.startProcessing();
            this.listener.batchReady(1);
            this.listener.matches(r1, r2, 1.0);
            this.listener.batchDone();
            this.listener.endProcessing();
            Assert.fail((String)"accepted match with empty record");
        }
        catch (DukeException dukeException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleRecord() {
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matches(r1, r2, 0.95);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 0.95), (Link)all.iterator().next());
    }

    @Test
    public void testSingleRecordRetract() {
        this.testSingleRecord();
        this.pause();
        Record r1 = this.makeRecord("id", "1");
        this.listener.startProcessing();
        this.listener.batchReady(0);
        this.listener.noMatchFor(r1);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.RETRACTED, LinkKind.SAME, 0.0), (Link)all.iterator().next());
    }

    @Test
    public void testSingleRecordPerhaps() {
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matchesPerhaps(r1, r2, 0.7);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.INFERRED, LinkKind.MAYBESAME, 0.7), (Link)all.iterator().next());
    }

    @Test
    public void testUpgradeFromPerhaps() {
        this.testSingleRecordPerhaps();
        this.pause();
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matches(r1, r2, 1.0);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 1.0), (Link)all.iterator().next());
    }

    @Test
    public void testOverride() {
        Link l1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(l1);
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matches(r1, r2, 1.0);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0), (Link)all.iterator().next());
    }

    @Test
    public void testOverride2() {
        Link l1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        this.linkdb.assertLink(l1);
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matches(r1, r2, 1.0);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        TestUtils.verifySame(new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0), (Link)all.iterator().next());
    }

    @Test
    public void testNoMatchFor() {
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        Record r3 = this.makeRecord("id", "3");
        Record r4 = this.makeRecord("id", "4");
        this.listener.startProcessing();
        this.listener.batchReady(3);
        this.listener.matches(r1, r3, 1.0);
        this.listener.noMatchFor(r2);
        this.listener.matches(r3, r1, 1.0);
        this.listener.matches(r3, r4, 1.0);
        this.listener.batchDone();
        this.listener.endProcessing();
        Link l1 = new Link("1", "3", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        Link l2 = new Link("3", "4", LinkStatus.INFERRED, LinkKind.SAME, 1.0);
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(l1));
        Assert.assertTrue((boolean)all.contains(l2));
    }

    @Test
    public void testEmptyBatch() {
        this.listener.startProcessing();
        this.listener.endProcessing();
        Assert.assertTrue((boolean)this.linkdb.getAllLinks().isEmpty());
    }

    @Test
    public void testSingleRecordIdempotent() {
        Record r1 = this.makeRecord("id", "1");
        Record r2 = this.makeRecord("id", "2");
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matches(r1, r2, 0.95);
        this.listener.batchDone();
        this.listener.endProcessing();
        Collection all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        Link original = (Link)all.iterator().next();
        TestUtils.verifySame(new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 0.95), original);
        this.listener.startProcessing();
        this.listener.batchReady(1);
        this.listener.matches(r1, r2, 0.947);
        this.listener.batchDone();
        this.listener.endProcessing();
        all = this.linkdb.getAllLinks();
        Assert.assertEquals((long)1L, (long)all.size());
        Link newlink = (Link)all.iterator().next();
        TestUtils.verifySame(new Link("1", "2", LinkStatus.INFERRED, LinkKind.SAME, 0.95), newlink);
        Assert.assertEquals((long)original.getTimestamp(), (long)newlink.getTimestamp());
    }

    private void pause() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Record makeRecord() {
        return new RecordImpl(new HashMap());
    }

    private Record makeRecord(String prop, String val) {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put(prop, Collections.singleton(val));
        return new RecordImpl(data);
    }
}

