/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.comparators.ExactComparator;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest {
    @Test
    public void testTrivial() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)2L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
        config.validate();
    }

    @Test
    public void testWithZeroes() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        props.add(new PropertyImpl("IGNORE", (Comparator)comp, 0.0, 0.0));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)2L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
        config.validate();
    }

    @Test
    public void testJustOne() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.0, 1.0);
        props.add(name);
        props.add(new PropertyImpl("EMAIL", (Comparator)comp, 0.0, 0.0));
        props.add(new PropertyImpl("IGNORE", (Comparator)comp, 0.0, 0.0));
        props.add(new PropertyImpl("IGNORE2", (Comparator)comp, 0.0, 0.0));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)lookups.size(), (long)1L);
        Assert.assertTrue((boolean)lookups.contains(name));
        config.validate();
    }

    @Test
    public void testNoProperties() throws IOException {
        ConfigurationImpl config = new ConfigurationImpl();
        try {
            config.validate();
            Assert.fail((String)"Configuration with no properties accepted");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testNoIdProperties() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        try {
            config.validate();
            Assert.fail((String)"Configuration with no ID properties accepted");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testThresholdTooHigh() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(1.0);
        config.setProperties(props);
        try {
            config.validate();
            Assert.fail((String)"Configuration which will never match anything accepted");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testLookupProperties() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        config.validate();
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)2L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
    }

    @Test
    public void testLookupPropertiesDefault() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        email.setLookupBehaviour(Property.Lookup.DEFAULT);
        props.add(email);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        config.validate();
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)2L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
    }

    @Test
    public void testLookupPropertiesTurnedOn() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        PropertyImpl phone = new PropertyImpl("PHONE", (Comparator)comp, 0.4, 0.51);
        props.add(phone);
        phone.setLookupBehaviour(Property.Lookup.TRUE);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        config.validate();
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)3L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
        Assert.assertTrue((boolean)lookups.contains(phone));
    }

    @Test
    public void testLookupPropertiesNotByDefault() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.48, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.48, 0.8);
        props.add(email);
        PropertyImpl phone = new PropertyImpl("PHONE", (Comparator)comp, 0.48, 0.51);
        props.add(phone);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        config.validate();
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)2L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
    }

    @Test
    public void testLookupPropertiesRequired() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        PropertyImpl name = new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8);
        props.add(name);
        PropertyImpl email = new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8);
        props.add(email);
        PropertyImpl phone = new PropertyImpl("PHONE", (Comparator)comp, 0.4, 0.51);
        props.add(phone);
        phone.setLookupBehaviour(Property.Lookup.REQUIRED);
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        config.validate();
        Collection lookups = config.getLookupProperties();
        Assert.assertEquals((long)3L, (long)lookups.size());
        Assert.assertTrue((boolean)lookups.contains(name));
        Assert.assertTrue((boolean)lookups.contains(email));
        Assert.assertTrue((boolean)lookups.contains(phone));
    }

    @Test
    public void testCantHaveTwoIdProperties() throws IOException {
        ExactComparator comp = new ExactComparator();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID1"));
        props.add(new PropertyImpl("ID2"));
        props.add(new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.86));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setThreshold(0.85);
        config.setProperties(props);
        try {
            config.validate();
            Assert.fail((String)"Can't have two ID properties in same config.");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }
}

