/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import no.priv.garshol.duke.CompactRecord;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordImpl;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import org.junit.Assert;

public class TestUtils {
    public static Record makeRecord() {
        return new RecordImpl(new HashMap());
    }

    public static Record makeRecord(String p1, String v1) {
        return TestUtils.makeRecord(p1, v1, null, null, null, null);
    }

    public static Record makeRecord(String p1, String v1, String p2, String v2) {
        return TestUtils.makeRecord(p1, v1, p2, v2, null, null);
    }

    public static Record makeRecord(String p1, String v1, String p2, String v2, String p3, String v3) {
        CompactRecord rec = new CompactRecord();
        rec.addValue(p1, v1);
        if (v2 != null) {
            rec.addValue(p2, v2);
        }
        if (v3 != null) {
            rec.addValue(p3, v3);
        }
        return rec;
    }

    public static void verifySame(Link l1, Link l2) {
        Assert.assertEquals((String)"wrong ID1", (Object)l1.getID1(), (Object)l2.getID1());
        Assert.assertEquals((String)"wrong ID2", (Object)l1.getID2(), (Object)l2.getID2());
        Assert.assertEquals((String)"wrong status", (Object)l1.getStatus(), (Object)l2.getStatus());
        Assert.assertEquals((String)"wrong kind", (Object)l1.getKind(), (Object)l2.getKind());
        Assert.assertEquals((double)l1.getConfidence(), (double)l2.getConfidence(), (double)1.0E-4);
    }

    public static class Pair {
        public Record r1;
        public Record r2;
        public double conf;

        public Pair(Record r1, Record r2, double conf) {
            this.r1 = r1;
            this.r2 = r2;
            this.conf = conf;
        }
    }

    public static class TestListener
    extends AbstractMatchListener {
        private List<Pair> matches = new ArrayList<Pair>();
        private int records;
        private int nomatch;
        private int maybes;

        public List<Pair> getMatches() {
            return this.matches;
        }

        public int getRecordCount() {
            return this.records;
        }

        public int getNoMatchCount() {
            return this.nomatch;
        }

        public int getMaybeCount() {
            return this.maybes;
        }

        public void batchReady(int size) {
            this.records += size;
        }

        public void matches(Record r1, Record r2, double confidence) {
            this.matches.add(new Pair(r1, r2, confidence));
        }

        public void matchesPerhaps(Record r1, Record r2, double confidence) {
            ++this.maybes;
        }

        public void noMatchFor(Record r) {
            ++this.nomatch;
        }
    }
}

