# tennis-rank
Computes tennis player ranks using pagerank algorithm on match graph

## Install

Using pip:

```shell
pip install tennisrank
```

Run tests:

```
make lint
make test
```

## Example

```python
from tennisrank.utils import load_atp
from tennisrank.model import Player, PlayerRank
from tennisrank.algorithm import TennisRank

matches = load_atp(2021)
ranker = TennisRank(matches)
top = 3
for surface in ['all', 'hard', 'clay', 'grass']:
    print(f'Top {top} on {surface} surface (unit weight):')
    ranks = ranker.get_ranks(surface=surface, point_diff=False)
    for player_rank in ranks[:top]:
        print('-', player_rank)
    print(f'{len(ranks)-top} more...')
    print()
```

Creates the following output:

```text
Top 3 on all surface (unit weight):
- PlayerRank(player=Player(id=104925, name='Novak Djokovic'), rank=1, surface='all')
- PlayerRank(player=Player(id=126774, name='Stefanos Tsitsipas'), rank=2, surface='all')
- PlayerRank(player=Player(id=106421, name='Daniil Medvedev'), rank=3, surface='all')
299 more...

Top 3 on hard surface (unit weight):
- PlayerRank(player=Player(id=106421, name='Daniil Medvedev'), rank=1, surface='hard')
- PlayerRank(player=Player(id=104925, name='Novak Djokovic'), rank=2, surface='hard')
- PlayerRank(player=Player(id=100644, name='Alexander Zverev'), rank=3, surface='hard')
251 more...

Top 3 on clay surface (unit weight):
- PlayerRank(player=Player(id=104745, name='Rafael Nadal'), rank=1, surface='clay')
- PlayerRank(player=Player(id=104925, name='Novak Djokovic'), rank=2, surface='clay')
- PlayerRank(player=Player(id=126774, name='Stefanos Tsitsipas'), rank=3, surface='clay')
190 more...

Top 3 on grass surface (unit weight):
- PlayerRank(player=Player(id=104925, name='Novak Djokovic'), rank=1, surface='grass')
- PlayerRank(player=Player(id=200000, name='Felix Auger Aliassime'), rank=2, surface='grass')
- PlayerRank(player=Player(id=126610, name='Matteo Berrettini'), rank=3, surface='grass')
155 more...
```

## Publish new version

> For developers

### Via Github Actions

- Update version number in pyproject.toml
- Merge to main (via PR, direct push to main or other way)
- Create new release on Github 

### Direct to PyPI

Build and upload:

```shell
python -m build
twine upload dist/*
```