# Generated by Django 3.2.7 on 2022-02-28 18:31

from django.conf import settings
import django.contrib.auth.validators
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import simpel.simpel_auth.managers
import simpel.simpel_auth.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
                'abstract': False,
            },
            managers=[
                ('objects', simpel.simpel_auth.managers.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('avatar', models.ImageField(blank=True, upload_to=simpel.simpel_auth.utils.upload_avatar_to, verbose_name='profile picture')),
                ('pid', models.CharField(help_text='Personal Identifier Number', max_length=15, null=True, verbose_name='PID')),
                ('tax_id', models.CharField(blank=True, help_text='Tax ID', max_length=15, null=True, verbose_name='Tax ID')),
                ('full_name', models.CharField(max_length=50, verbose_name='full name')),
                ('short_name', models.CharField(blank=True, max_length=150, verbose_name='short name')),
                ('title', models.CharField(blank=True, max_length=255, null=True, verbose_name='Title')),
                ('blood_type', models.CharField(blank=True, max_length=3, null=True, verbose_name='blood_type')),
                ('gender', models.CharField(choices=[('L', 'Male'), ('P', 'Female')], default='L', max_length=1, verbose_name='gender')),
                ('religion', models.CharField(blank=True, max_length=25, null=True, verbose_name='religion')),
                ('date_of_birth', models.DateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='date of birth')),
                ('place_of_birth', models.CharField(blank=True, max_length=255, null=True, verbose_name='place of birth')),
                ('preferred_language', models.CharField(default='', help_text='Select language for the admin', max_length=10, verbose_name='preferred language')),
                ('current_time_zone', models.CharField(default='', help_text='Select your current time zone', max_length=40, verbose_name='current time zone')),
                ('user', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'user profile',
                'verbose_name_plural': 'user profiles',
            },
        ),
        migrations.CreateModel(
            name='LinkedContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('linked_object_id', models.IntegerField(blank=True, help_text='Linked instance primary key.', null=True)),
                ('contact_type', models.CharField(choices=[('phone', 'Phone'), ('email', 'Email'), ('mobile', 'Mobile'), ('whatsapp', 'Whatsapp'), ('website', 'Website')], default='phone', help_text='E.g. Phone or mobile', max_length=255, verbose_name='type')),
                ('contact', models.CharField(help_text='Phone number or etc.', max_length=255, verbose_name='contact')),
                ('is_verified', models.BooleanField(default=False, editable=False)),
                ('linked_object_type', models.ForeignKey(blank=True, help_text='Linked object type', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='linked_contacts', to='contenttypes.contenttype')),
            ],
        ),
        migrations.CreateModel(
            name='LinkedAddress',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('linked_object_id', models.IntegerField(blank=True, help_text='Linked instance primary key.', null=True)),
                ('primary', models.BooleanField(default=False)),
                ('address_type', models.CharField(choices=[('home', 'Home'), ('office', 'Office'), ('branch_office', 'Branch Office'), ('billing', 'Billing'), ('shipping', 'Shipping'), ('drop_shipping', 'Dropshipping'), ('deliverable', 'Deliverable'), ('else', 'Else')], default='billing', help_text='E.g. Shipping or billing', max_length=255, verbose_name='type')),
                ('name', models.CharField(help_text='If blank, contact name will be used.', max_length=255, verbose_name='name')),
                ('phone', models.CharField(help_text='In case we need to make a call.', max_length=255, null=True, verbose_name='Phone')),
                ('address', models.CharField(max_length=255, null=True, verbose_name='address')),
                ('city', models.CharField(max_length=255, null=True, verbose_name='city')),
                ('province', models.CharField(max_length=255, null=True, verbose_name='province')),
                ('country', models.CharField(max_length=255, null=255, verbose_name='country')),
                ('zipcode', models.CharField(max_length=10, null=True, verbose_name='zip code')),
                ('linked_object_type', models.ForeignKey(blank=True, help_text='Linked object type', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='linked_address', to='contenttypes.contenttype')),
            ],
        ),
        migrations.CreateModel(
            name='Flag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('flagged_object_id', models.IntegerField(help_text='Flagged object primary key.')),
                ('value', models.IntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(10)])),
                ('flagged_object_type', models.ForeignKey(help_text='Flagged object type', on_delete=django.db.models.deletion.CASCADE, related_name='flags', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(limit_choices_to={'is_partial': True}, on_delete=django.db.models.deletion.CASCADE, related_name='favorite_products', to=settings.AUTH_USER_MODEL, verbose_name='Item')),
            ],
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.CharField(choices=[('success', 'success'), ('info', 'info'), ('warning', 'warning'), ('error', 'error')], default='info', max_length=20)),
                ('unread', models.BooleanField(db_index=True, default=True)),
                ('actor_object_id', models.CharField(max_length=255)),
                ('verb', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('target_object_id', models.CharField(blank=True, max_length=255, null=True)),
                ('action_object_object_id', models.CharField(blank=True, max_length=255, null=True)),
                ('timestamp', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('public', models.BooleanField(db_index=True, default=True)),
                ('deleted', models.BooleanField(db_index=True, default=False)),
                ('emailed', models.BooleanField(db_index=True, default=False)),
                ('data', models.JSONField(blank=True, null=True)),
                ('action_object_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notify_action_object', to='contenttypes.contenttype')),
                ('actor_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notify_actor', to='contenttypes.contenttype')),
                ('recipient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to=settings.AUTH_USER_MODEL)),
                ('target_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notify_target', to='contenttypes.contenttype')),
            ],
            options={
                'db_table': 'simpel_auth_notification',
                'ordering': ('-timestamp',),
                'index_together': {('recipient', 'unread')},
            },
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='action time')),
                ('action_object_id', models.CharField(blank=True, max_length=255, null=True)),
                ('action_flag', models.PositiveSmallIntegerField(choices=[(1, 'Addition'), (2, 'Change'), (3, 'Deletion'), (4, 'Creation'), (5, 'Validation'), (6, 'Approval'), (7, 'Rejection'), (8, 'Process'), (9, 'Closing'), (10, 'Clone'), (11, 'Convertion'), (12, 'Completion'), (13, 'Cancelation')], verbose_name='action flag')),
                ('note', models.TextField(blank=True, verbose_name='activity note')),
                ('data', models.JSONField(blank=True, null=True, verbose_name='activity data')),
                ('action_object_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='activities', to='contenttypes.contenttype')),
                ('actor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='actor')),
            ],
            options={
                'verbose_name': 'Activity',
                'verbose_name_plural': 'Activities',
                'db_table': 'simpel_auth_activity',
                'ordering': ['-timestamp'],
                'index_together': {('timestamp', 'actor', 'action_flag')},
            },
            managers=[
                ('objects', simpel.simpel_auth.managers.ActivityManager()),
            ],
        ),
    ]
