# Generated by Django 3.2.7 on 2022-02-28 18:33

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import simpel.simpel_invoices.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        ('simpel_products', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('date_trashed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date trashed')),
                ('date_pending', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date pending')),
                ('date_validated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date validated')),
                ('date_canceled', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date canceled')),
                ('date_paid', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date paid')),
                ('status', models.IntegerField(choices=[(15, 'Trash'), (23, 'Pending'), (17, 'Valid'), (40, 'Canceled'), (25, 'Paid'), (26, 'Closed')], default=23)),
                ('date_closed', models.DateTimeField(blank=True, default=None, editable=False, null=True, verbose_name='Date closed')),
                ('issued_date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Issued date')),
                ('due_date', models.DateTimeField(default=simpel.simpel_invoices.models.invoice_due_date, verbose_name='Due date')),
                ('customer_id', models.IntegerField(blank=True, null=True, verbose_name='Customer ID')),
                ('reference_id', models.CharField(max_length=255, null=True, verbose_name='Reference')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('data', models.JSONField(blank=True, null=True, verbose_name='Extra data')),
                ('items_count', models.IntegerField(default=0, editable=False, verbose_name='Items Count')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('discount', models.DecimalField(decimal_places=2, default=0, max_digits=15, verbose_name='Discount')),
                ('downpayment', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Downpayment')),
                ('repayment', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Repayment')),
                ('refund', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Refund')),
                ('payable', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Payable')),
                ('paid', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Paid')),
                ('grand_total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Grand Total')),
                ('customer_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='invoice_customers', to='contenttypes.contenttype', verbose_name='Customer Type')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='invoices', to='simpel_products.group', verbose_name='Group')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_invoices.invoice_set+', to='contenttypes.contenttype')),
                ('reference_type', models.ForeignKey(blank=True, help_text='Please select reference type, then provide valid inner id as reference, otherwise leave it blank.', limit_choices_to={'model__in': ['salesorder']}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='invoices', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='invoices', to=settings.AUTH_USER_MODEL, verbose_name='Created By')),
            ],
            options={
                'verbose_name': 'Invoice',
                'verbose_name_plural': 'Invoices',
                'db_table': 'simpel_invoice',
                'permissions': (('trash_invoice', 'Can trash Invoice'), ('validate_invoice', 'Can validate Invoice'), ('cancel_invoice', 'Can cancel Invoice'), ('close_invoice', 'Can close Invoice'), ('import_invoice', 'Can import Invoice'), ('export_invoice', 'Can export Invoice')),
                'index_together': {('user', 'group', 'customer_type', 'customer_id', 'status')},
            },
        ),
        migrations.CreateModel(
            name='InvoiceItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='name')),
                ('alias_name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='alias_name')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('price', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Price')),
                ('subtotal', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Sub Total')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('invoice', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='simpel_invoices.invoice')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='invoice_items', to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Invoice Item',
                'verbose_name_plural': 'Invoice Items',
                'db_table': 'simpel_invoice_item',
                'index_together': {('invoice', 'product')},
            },
        ),
        migrations.CreateModel(
            name='InvoiceItemBundle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='name')),
                ('price', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Price')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundles', to='simpel_invoices.invoiceitem')),
                ('product', models.ForeignKey(limit_choices_to={'is_partial': True}, on_delete=django.db.models.deletion.PROTECT, related_name='invoice_bundles', to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Invoice Item Bundle',
                'verbose_name_plural': 'Invoice Item Bundles',
                'db_table': 'simpel_invoice_item_bundle',
                'index_together': {('item', 'product')},
            },
        ),
    ]
