# Generated by Django 3.2.7 on 2022-02-28 19:16

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Partner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('doc', models.CharField(choices=[('KTP', 'Kartu Tanda Penduduk'), ('SIM', 'Surat Izin Mengemudi'), ('TDP', 'Tanda Daftar Perusahaan')], default='KTP', help_text='Identity documents', max_length=5, verbose_name='Identity Document')),
                ('idn', models.CharField(help_text='Identification Number', max_length=15, null=True, verbose_name='Identification Number')),
                ('tax_id', models.CharField(blank=True, help_text='Tax ID', max_length=15, null=True, verbose_name='Tax ID')),
                ('name', models.CharField(db_index=True, help_text='Can be person name/organization etc as needed.', max_length=255, verbose_name='name')),
                ('text', models.TextField(blank=True, default='No profile information', help_text='Describe your self/organization profile.', max_length=245, null=True)),
                ('html', models.TextField(blank=True, editable=False, max_length=2550, null=True)),
                ('attachment', models.FileField(blank=True, help_text='Partner file attachment: PDF format file.', null=True, upload_to='', verbose_name='Attachment')),
                ('partner_type', models.CharField(choices=[('personal', 'Personal'), ('organization', 'Organization')], default='organization', max_length=255, verbose_name='Partner type')),
                ('is_active', models.BooleanField(default=False, editable=False)),
                ('is_verified', models.BooleanField(default=False, editable=False)),
                ('is_customer', models.BooleanField(default=True, verbose_name='Customer')),
                ('is_supplier', models.BooleanField(default=False, verbose_name='Supplier')),
                ('joined_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('modified_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'Partner',
                'verbose_name_plural': 'Partners',
                'db_table': 'simpel_partner',
                'ordering': ('name',),
                'permissions': (('import_partner', 'Can import Partner'), ('export_partner', 'Can export Partner'), ('change_partner_user', 'Can change Partner user account'), ('activate_partner', 'Can activate Partner'), ('verify_partner', 'Can verify Partner')),
            },
        ),
    ]
