# Generated by Django 3.2.7 on 2022-02-28 18:32

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import simpel.simpel_sales.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('simpel_products', '0001_initial'),
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SalesOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('date_pending', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date pending')),
                ('date_validated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date validated')),
                ('date_canceled', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date canceled')),
                ('date_completed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date completed')),
                ('date_processed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date processed')),
                ('date_closed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date closed')),
                ('date_invoiced', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date invoiced')),
                ('status', models.IntegerField(choices=[(23, 'Pending'), (17, 'Valid'), (40, 'Canceled'), (20, 'Processed'), (22, 'Invoiced'), (26, 'Closed'), (21, 'Complete')], default=23)),
                ('customer_id', models.IntegerField(blank=True, null=True, verbose_name='Customer ID')),
                ('reference', models.CharField(blank=True, help_text='Purchase Order number.', max_length=50, null=True, verbose_name='PO Number')),
                ('discount', models.DecimalField(decimal_places=2, default=0, max_digits=15, verbose_name='Discount')),
                ('expired_at', models.DateTimeField(blank=True, default=simpel.simpel_sales.models.sales_order_expired, editable=False, null=True)),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('data', models.JSONField(blank=True, null=True, verbose_name='Extra data')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('grand_total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Grand Total')),
                ('customer_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='salesorders', to='contenttypes.contenttype', verbose_name='Customer Type')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='salesorders', to='simpel_products.group', verbose_name='Group')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_sales.salesorder_set+', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sales_orders', to=settings.AUTH_USER_MODEL, verbose_name='Created By')),
            ],
            options={
                'verbose_name': 'Sales Order',
                'verbose_name_plural': 'Sales Orders',
                'db_table': 'simpel_sales_order',
                'permissions': (('import_salesorder', 'Can import Sales Order'), ('export_salesorder', 'Can export Sales Order'), ('validate_salesorder', 'Can validate Sales Order'), ('process_salesorder', 'Can process Sales Order'), ('complete_salesorder', 'Can complete Sales Order'), ('close_salesorder', 'Can close Sales Order')),
                'index_together': {('user', 'group', 'customer_type', 'customer_id', 'status')},
            },
        ),
        migrations.CreateModel(
            name='SalesOrderItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='name')),
                ('alias_name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='alias name')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('price', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Price')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('total_bundles', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total Bundles')),
                ('subtotal', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Sub Total')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('product', models.ForeignKey(limit_choices_to={'is_sellable': True}, on_delete=django.db.models.deletion.PROTECT, related_name='order_items', to='simpel_products.product')),
                ('salesorder', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='simpel_sales.salesorder')),
            ],
            options={
                'verbose_name': 'Order Item',
                'verbose_name_plural': 'Order Items',
                'db_table': 'simpel_sales_order_item',
                'ordering': ('position', 'reg_number'),
                'permissions': (('import_salesorderitem', 'Can import Sales Order Item'), ('export_salesorderitem', 'Can export Sales Order Item')),
                'index_together': {('salesorder', 'product')},
            },
        ),
        migrations.CreateModel(
            name='SalesQuotation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('date_pending', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date pending')),
                ('date_validated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date validated')),
                ('status', models.IntegerField(choices=[(23, 'Pending'), (17, 'Valid')], default=23)),
                ('expired_at', models.DateTimeField(blank=True, default=simpel.simpel_sales.models.sales_order_expired, null=True)),
                ('customer_id', models.IntegerField(blank=True, null=True, verbose_name='Customer ID')),
                ('discount', models.DecimalField(decimal_places=2, default=0, max_digits=15, verbose_name='Discount')),
                ('reference', models.CharField(blank=True, help_text='Purchase Order number.', max_length=50, null=True, verbose_name='PO Number')),
                ('note', models.TextField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('data', models.JSONField(blank=True, null=True, verbose_name='Extra data')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('grand_total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Grand Total')),
                ('customer_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='salesorder_customers', to='contenttypes.contenttype', verbose_name='Customer Type')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='salesquotations', to='simpel_products.group', verbose_name='Group')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_sales.salesquotation_set+', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='quotations', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Sales Quotation',
                'verbose_name_plural': 'Sales Quotations',
                'db_table': 'simpel_sales_quotation',
                'permissions': (('import_salesquotation', 'Can import Sales Quotation'), ('export_salesquotation', 'Can export Sales Quotation'), ('validate_salesquotation', 'Can validate Sales Quotation'), ('process_salesquotation', 'Can process Sales Quotation'), ('accept_salesquotation', 'Can accept Sales Quotation')),
                'index_together': {('user', 'group', 'customer_type', 'customer_id', 'status')},
            },
        ),
        migrations.CreateModel(
            name='SalesQuotationItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('name', models.CharField(blank=True, db_index=True, editable=False, max_length=255, null=True, verbose_name='name')),
                ('alias_name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='alias name')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('price', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Price')),
                ('total_bundles', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total Bundles')),
                ('subtotal', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Sub Total')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('product', models.ForeignKey(limit_choices_to={'is_sellable': True}, on_delete=django.db.models.deletion.PROTECT, related_name='quotation_items', to='simpel_products.product')),
                ('salesquotation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='simpel_sales.salesquotation')),
            ],
            options={
                'verbose_name': 'Quotation Item',
                'verbose_name_plural': 'Quotations Items',
                'db_table': 'simpel_sales_quotation_item',
                'ordering': ('position',),
                'permissions': (('import_salesquotationitem', 'Can import Sales Quotation Item'), ('export_salesquotationitem', 'Can export Sales Quotation Item')),
                'index_together': {('salesquotation', 'product')},
            },
        ),
        migrations.CreateModel(
            name='SalesSetting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('salesorder_expiration', models.IntegerField(blank=True, null=True, verbose_name='Sales Order Expiration')),
                ('salesorder_signer_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Sales Order Signer')),
                ('salesorder_signer_position', models.CharField(blank=True, max_length=255, null=True, verbose_name='Sales Order Signer Position')),
                ('salesorder_signer_eid', models.CharField(blank=True, max_length=255, null=True, verbose_name='Sales Order Signer EID')),
                ('salesquotation_signer_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Sales Quotation Signer')),
                ('salesquotation_signer_position', models.CharField(blank=True, max_length=255, null=True, verbose_name='Sales Quotation Signer Position')),
                ('salesquotation_signer_eid', models.CharField(blank=True, max_length=255, null=True, verbose_name='Sales Quotation Signer EID')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProformaInvoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('salesorder', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='proforma', to='simpel_sales.salesorder', verbose_name='Order')),
            ],
            options={
                'verbose_name': 'Proforma Invoice',
                'verbose_name_plural': 'Proforma Invoices',
                'db_table': 'simpel_sales_proforma_invoice',
                'permissions': (('import_proformainvoice', 'Can import Proforma Invoice'), ('export_proformainvoice', 'Can export Proforma Invoice')),
            },
        ),
        migrations.CreateModel(
            name='SalesQuotationItemBundle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='name')),
                ('price', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Price')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundles', to='simpel_sales.salesquotationitem')),
                ('product', models.ForeignKey(limit_choices_to={'is_partial': True, 'is_sellable': True}, on_delete=django.db.models.deletion.PROTECT, related_name='quotation_item_bundles', to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Quotation Item Bundle',
                'verbose_name_plural': 'Quotation Item Bundles',
                'db_table': 'simpel_sales_quotation_item_bundle',
                'ordering': ('position', 'reg_number'),
                'permissions': (('import_salesquotationitembundle', 'Can import Sales Quotation Item Bundle'), ('export_salesquotationitembundle', 'Can export Sales Quotation Item Bundle')),
                'unique_together': {('item', 'product')},
                'index_together': {('item', 'product')},
            },
        ),
        migrations.CreateModel(
            name='SalesOrderItemBundle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, editable=False)),
                ('deleted_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('name', models.CharField(blank=True, db_index=True, editable=False, max_length=255, null=True, verbose_name='name')),
                ('price', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Price')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('total', models.DecimalField(decimal_places=2, default=0, editable=False, max_digits=15, verbose_name='Total')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundles', to='simpel_sales.salesorderitem')),
                ('product', models.ForeignKey(limit_choices_to={'is_partial': True, 'is_sellable': True}, on_delete=django.db.models.deletion.PROTECT, related_name='order_item_bundles', to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Order Item Bundle',
                'verbose_name_plural': 'Order Item Bundles',
                'db_table': 'simpel_sales_order_item_bundle',
                'ordering': ('position',),
                'permissions': (('import_salesorderitembundle', 'Can import Sales Order Item Bundle'), ('export_salesorderitembundle', 'Can export Sales Order Item Bundle')),
                'unique_together': {('item', 'product')},
                'index_together': {('item', 'product')},
            },
        ),
    ]
