## Name of the project

At the top of the file there should be a short introduction and/ or overview that explains **what** the project is.

#### Project status

List the project status (keep one of the below bullets):

* Completed with active maintenance
* Completed with no active maintenance
* In progress
* On hold
* Under review
* Just started

## Motivation

A short description of the motivation behind the creation and maintenance of the project. This should explain **why** the project exists.

## Confluence

If a confluence page exists for the project, link it here.

## Requirements

If your code requires environment variables to be set, access to specific databases, or requires certain software to be available, mention those here. Additionally, if there is a requirements.txt or .Rprofile needed, list that here.

## Getting started

Provide code examples and explanations of how to get the project up and running.

## Example use and output

Show what the library or code does as concisely as possible; the reader should be able to figure out **how** your project solves their problem by looking at the code example. Make sure the API you are showing off is obvious, and that your code is short and concise.

## Tests

If your project includes tests, describe and show how to run them with code examples.

## Reference notes

Depending on the size of the project, if it is small and simple enough the reference docs can be added to the README. For medium size to larger projects include the documentation within the docs/ subfolder of this repo template.

## Contributors

Let the reader know who to reach out to with questions by listing the main contributors.

* Contributor name 1 (email1@nordstrom.com)
* Contributor name 2 (email2@nordstrom.com)

Also let people know how they can dive into the project, include important links to things like issue trackers if applicable.
